function vexinterrupt.options.main()
	return {
		type = "group",
		args = {
			title={name="|CFFFF7D0AVersion: |r"..GetAddOnMetadata("vexinterrupt", "Version").."\n", type="description", order=1, fontSize="large"},
			author={name="|CFFFF7D0AAuthor: |rVexar Aegwynn-EU\n", type="description", order=2, fontSize="large"},
			slashcmds={name="\n\nSlash Cmds:\n/vexinterrupt\n/vexi", type="description", order=3, fontSize="large"},
			space={name="\n\n", type="description", order=4, fontSize="large"},
			
			
			activate = {
				name = "Enable Addon",
				order=5, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["active"]=key end,
				get = function() return vexinterrupt_data["active"] end,
				},
				
			defaults = {
				name = "Reset to defaults",
				order=6, type = "execute",
				func = function(info,val) vexinterrupt_data = vexalarm.initialize.checkTableData(vexinterrupt.defaults, vexinterrupt_data, true) end,
				},
			}
		}
end

function vexinterrupt.options.messages()
	return {
		type = "group",
		args = {	
			interrupts = {
				name = "Interrupts",
				order=11, type ="group", dialogInline = true,
				args = {
					activate = {
						name = "Activate Output",
						order=1, type = "toggle", width="double",
						set = function(self,key) vexinterrupt_data["msg"]["SPELL_INTERRUPT"][1]=key end,
						get = function() return vexinterrupt_data["msg"]["SPELL_INTERRUPT"][1] end,
						},
					interrupt = {
						name = "Interrupt message",
						order=2, type = "input", multiline = false,
						width = "double",
						set = function(info,val) vexinterrupt_data["msg"]["SPELL_INTERRUPT"][2]=val end,
						get = function() return vexinterrupt_data["msg"]["SPELL_INTERRUPT"][2] end
						},
					interruptdefault = {
						name = "reset to defaults",
						order=3, type = "execute",
						func = function(info,val) vexinterrupt_data["msg"]["SPELL_INTERRUPT"][2]=vexinterrupt.defaults["msg"]["SPELL_INTERRUPT"][2] end,
						},
					info = {name = "You can use [spelllink] and [spellname] to parse the spell as a link or just the name into the message. [target] and [targetRaidIcon] parse the name of the interrupted character and the raid icon set on that char into the message.", type = "description", order=10,fontSize="small",},
					},
				},
			interruptspace = {name = " ", type = "description", order=12,fontSize="medium",},
			dispell = {
				name = "Dispells",
				order=20, type ="group", dialogInline = true,
				args = {
					activate = {
						name = "Activate Output",
						order=1, type = "toggle", width="double",
						set = function(self,key) vexinterrupt_data["msg"]["SPELL_DISPEL"][1]=key end,
						get = function() return vexinterrupt_data["msg"]["SPELL_DISPEL"][1] end,
						},
					interrupt = {
						name = "Dispell message",
						order=2, type = "input", multiline = false,
						width = "double",
						set = function(info,val) vexinterrupt_data["msg"]["SPELL_DISPEL"][2]=val end,
						get = function() return vexinterrupt_data["msg"]["SPELL_DISPEL"][2] end
						},
					interruptdefault = {
						name = "reset to defaults",
						order=3, type = "execute",
						func = function(info,val) vexinterrupt_data["msg"]["SPELL_DISPEL"][2]=vexinterrupt.defaults["msg"]["SPELL_DISPEL"][2] end,
						},
					info = {name = "You can use [spelllink] and [spellname] to parse the spell as a link or just the name into the message. [target] and [targetRaidIcon] parse the name of the interrupted character and the raid icon set on that char into the message.\n\nDispells only work on NPCs not on other players!", type = "description", order=10,fontSize="small",},
					},
				},
			dispellspace = {name = " ", type = "description", order=21,fontSize="medium",},
			spellsteals = {
				name = "Spellsteal",
				order=30, type ="group", dialogInline = true,
				args = {
					activate = {
						name = "Activate Output",
						order=1, type = "toggle", width="double",
						set = function(self,key) vexinterrupt_data["msg"]["SPELL_STOLEN"][1]=key end,
						get = function() return vexinterrupt_data["msg"]["SPELL_STOLEN"][1] end,
						},
					interrupt = {
						name = "Spellsteal message",
						order=2, type = "input", multiline = false,
						width = "double",
						set = function(info,val) vexinterrupt_data["msg"]["SPELL_STOLEN"][2]=val end,
						get = function() return vexinterrupt_data["msg"]["SPELL_STOLEN"][2] end
						},
					interruptdefault = {
						name = "reset to defaults",
						order=3, type = "execute",
						func = function(info,val) vexinterrupt_data["msg"]["SPELL_STOLEN"][2]=vexinterrupt.defaults["msg"]["SPELL_STOLEN"][2] end,
						},
					info = {name = "You can use [spelllink] and [spellname] to parse the spell as a link or just the name into the message. [target] and [targetRaidIcon] parse the name of the interrupted character and the raid icon set on that char into the message.", type = "description", order=10,fontSize="small",},
					},
				},
			atspace = {name = " ", type = "description", order=31,fontSize="medium",},
			arcaneTorrent = {
				name = "Atypical Spells",
				order=40, type ="group", dialogInline = true,
				args = {
				
					info = {name = "Still in testing, deactivated till tested properly", type = "description", order=1,fontSize="small",},
					-- info = {name = "Some spells (Arcante Torrent, Frag Belts from Engineers, etc) don't trigger the 'SPELL_INTERRUPTED' event. There's no way to tell if an interrupt with said spells was successful. However It is still possible to track whether an enemy was effected by said 'atypical spells'.", type = "description", order=1,fontSize="small",},
					-- activate = {
						-- name = "Activate Output",
						-- order=2, type = "toggle", width="double",
						-- set = function(self,key) vexinterrupt_data["msg"]["ATYPICAL"][1]=key end,
						-- get = function() return vexinterrupt_data["msg"]["ATYPICAL"][1] end,
						-- },
					-- interrupt = {
						-- name = "Arcane Torrent message",
						-- order=3, type = "input", multiline = false,
						-- width = "double",
						-- set = function(info,val) vexinterrupt_data["msg"]["ATYPICAL"][2]=val end,
						-- get = function() return vexinterrupt_data["msg"]["ATYPICAL"][2] end
						-- },
					-- interruptdefault = {
						-- name = "reset to defaults",
						-- order=4, type = "execute",
						-- func = function(info,val) vexinterrupt_data["msg"]["ATYPICAL"][2]=vexinterrupt.defaults["msg"]["ATYPICAL"][2] end,
						-- },
					-- tags = {name = "[spelllink] and [spellname] are NOT available", type = "description", order=10,fontSize="small",},
					},
				},
			},
		}
end

function vexinterrupt.options.settings()
	local channels = {
		["SAY"] = "say",
		["GUILD "] = "guild",
		["INSTANCE_CHAT"] = "Instance chat",
		["OFFICER"] = "officer",
		["PARTY"] = "party",
		["RAID"] = "raid",
		["RAID_WARNING"] = "raid warning",
		["YELL"] = "yell",
		}
	
	return {
		type = "group",
		args = {
			grp = {
				name = "Only active when in a grp or raid",
				order=1, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["inGrpOnly"]=key end,
				get = function() return vexinterrupt_data["inGrpOnly"] end,
				},
			space = {name = "\n\n", type = "description", order=5,fontSize="medium",},
			general = {
				name = 'Activate in "General"-Zones',
				order=10, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["general"]=key end,
				get = function() return vexinterrupt_data["zones"]["general"] end,
				},
			generaloutput = {
				name = "Output Channel",
				order=11, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["general"] = key end,
				get = function() return vexinterrupt_data["channel"]["general"] end,
				},
			bg = {
				name = 'Activate in BGs',
				order=20, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["bg"]=key end,
				get = function() return vexinterrupt_data["zones"]["bg"] end,
				},
			bgoutput = {
				name = "Output Channel",
				order=21, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["bg"] = key end,
				get = function() return vexinterrupt_data["channel"]["bg"] end,
				},
			arena = {
				name = 'Activate in Arena',
				order=30, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["arena"]=key end,
				get = function() return vexinterrupt_data["zones"]["arena"] end,
				},
			arenaoutput = {
				name = "Output Channel",
				order=31, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["arena"] = key end,
				get = function() return vexinterrupt_data["channel"]["arena"] end,
				},
			raid = {
				name = 'Activate in Raid-Instances',
				order=40, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["raid"]=key end,
				get = function() return vexinterrupt_data["zones"]["raid"] end,
				},
			raidoutput = {
				name = "Output Channel",
				order=41, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["raid"] = key end,
				get = function() return vexinterrupt_data["channel"]["raid"] end,
				},
			dng = {
				name = 'Activate in Dungeons',
				order=50, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["dng"]=key end,
				get = function() return vexinterrupt_data["zones"]["dng"] end,
				},
			dngoutput = {
				name = "Output Channel",
				order=51, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["dng"] = key end,
				get = function() return vexinterrupt_data["channel"]["dng"] end,
				},
			mythdng = {
				name = 'Activate in Mythic Dungeons',
				order=70, type = "toggle", width="double",
				set = function(self,key) vexinterrupt_data["zones"]["mythdng"]=key end,
				get = function() return vexinterrupt_data["zones"]["mythdng"] end,
				},
			mythdngoutput = {
				name = "Output Channel",
				order=71, type = "select", style = "dropdown", width="normal",
				values = channels,
				set = function(self,key) vexinterrupt_data["channel"]["mythdng"] = key end,
				get = function() return vexinterrupt_data["channel"]["mythdng"] end,
				},
			},
		}
end
