function vexinterrupt.initialize(reload)
	vexinterrupt.playerName = select(1, UnitName("player"))
	
	if vexinterrupt_data == nil then
		vexinterrupt_data = {}
	end
	
	local resetMessages = false
	if vexinterrupt_data["varVersion"] ~= vexinterrupt.defaults["varVersion"] then
		resetMessages = true
	end
	
	vexinterrupt_data = vexinterrupt.checkTableData(vexinterrupt.defaults, vexinterrupt_data, false)
	
	if resetMessages then
		vexinterrupt_data["msg"]["SPELL_INTERRUPT"][2] = vexinterrupt.defaults["msg"]["SPELL_INTERRUPT"][2]
		vexinterrupt_data["msg"]["SPELL_DISPEL"][2] = vexinterrupt.defaults["msg"]["SPELL_DISPEL"][2]
		vexinterrupt_data["msg"]["SPELL_STOLEN"][2] = vexinterrupt.defaults["msg"]["SPELL_STOLEN"][2]
	end
	
	vexinterrupt.started = true
	
	if not(reload) then
		vexinterrupt.options.panel_main = vexinterrupt.AceConfigDialog:AddToBlizOptions("Vex Interrupt", "Vex Interrupt")
		vexinterrupt.options.panel_messages = vexinterrupt.AceConfigDialog:AddToBlizOptions("Vex Interrupt Messages", "Messages", "Vex Interrupt")
		vexinterrupt.options.panel_settings = vexinterrupt.AceConfigDialog:AddToBlizOptions("Vex Interrupt Settings", "Settings", "Vex Interrupt")
	end
	vexinterrupt.AceConfig:RegisterOptionsTable("Vex Interrupt", vexinterrupt.options.main(), {})
	vexinterrupt.AceConfig:RegisterOptionsTable("Vex Interrupt Messages", vexinterrupt.options.messages(), {})
	vexinterrupt.AceConfig:RegisterOptionsTable("Vex Interrupt Settings", vexinterrupt.options.settings(), {})
	
	vexinterrupt.scanTool.frame = CreateFrame( "GameTooltip", "ScanTooltip", nil, "GameTooltipTemplate" )
	vexinterrupt.scanTool.frame:SetOwner( WorldFrame, "ANCHOR_NONE" )
	vexinterrupt.scanTool.text = _G["ScanTooltipTextLeft2"]
end

function vexinterrupt.checkTableData(defaults, saved, force)
	local temp = {}
	if force or type(saved) ~= "table" then temp=defaults
	else
		for key,val in pairs(defaults) do
			if type(val) == "table" then
				temp[key] = {}
				if saved[key] == nil then
					temp[key] = val
				else
					temp[key] = vexinterrupt.checkTableData(defaults[key], saved[key], force)
				end
			else
				if saved[key] == nil then
					temp[key] = val
				else
					temp[key] = saved[key]
				end
			end
		end
	end
	return temp
end

vexinterrupt.defaults = {
	["varVersion"] = 1,
	["active"] = true,
	["inGrpOnly"] = false,
	["zones"] = {
		["general"] = true,
		["bg"] = false,
		["arena"] = false,
		["raid"] = true,
		["dng"] = true,
		["cm"] = true,
		["mythdng"] = true,
		},
	["channel"] = {
		["general"] = "SAY",
		["bg"] = "SAY",
		["arena"] = "SAY",
		["raid"] = "SAY",
		["dng"] = "SAY",
		["cm"] = "SAY",
		["mythdng"] = "SAY",
		},
	["msg"] = {
		["SPELL_INTERRUPT"] = {
			true,
			"! [spelllink]",
			},
		["SPELL_DISPEL"] = {
			true,
			"X [spelllink]",
			},
		["SPELL_STOLEN"] = {
			true,
			"X [spelllink]",
			},
		["ATYPICAL"] = {		-- ARCANE TORRENT, FRAG BELT			2600	66888
			true,
			"!",
			},
		},
	}
