-- Veneer
-- Templates.lua
-- Created: 10/24/2016 9:16 AM
-- %file-revision%
--
-- Mover Widget base
local ADDON, addon = ...
local print = DEVIAN_WORKSPACE and function(...) _G.print('VnTpl', ...) end or nop
local PlaySoundKitID = DEVIAN_WORKSPACE and PlaySoundKitID or nop
local ipairs, pairs = ipairs, pairs
local pack, unpack = pack, unpack

local Handler, ConfigLayer, Animation = {}, {}, {}

VeneerConfigLayerMixin = ConfigLayer
VeneerAnimationMixin = Animation
VeneerHandlerMixin = Handler
Handler.anchorPoint = 'CENTER'
Handler.anchorPriority = 4
Handler.data = {}
addon.HandlerBase = Handler
addon.ConfigLayerBase = ConfigLayer
addon.AnimationBase = Animation

local ANCHOR_BUTTON_TYPES = {
  'TOPLEFT', 'TOP', 'TOPRIGHT', 'RIGHT', 'LEFT', 'CENTER', 'BOTTOMLEFT', 'BOTTOM', 'BOTTOMRIGHT'
}

function ConfigLayer:OnLoad()
  local handler = self:GetParent()
  print(handler:GetName(), '-> ConfigLayer loaded', addon.ConfigMode)
  handler.ConfigLayers = handler.ConfigLayers or {}
  for i, region in ipairs(handler.ConfigLayers) do
    region:SetShown(addon.ConfigMode)
  end
  self.handler = handler
end

function ConfigLayer:OnShow()
  self:Update()
end

local AnchorButton_OnClick = function(self)

  local module = self:GetParent().handler
  module.anchorPoint = self.anchorPoint
  module:Print('Anchor set to '.. self.anchorPoint)
  self:GetParent():Update()
end

local RelativeButton_OnClick = function(self)
end

local RelativeButton_OnDragStart = function(self) end
local RelativeButton_OnDragStop = function(self) end


function ConfigLayer:Update()
  if not self.anchorButtons then
    self.anchorButtons = {}
    for _, anchorPoint in ipairs(ANCHOR_BUTTON_TYPES) do
      local button = CreateFrame('Button', nil, self, 'VeneerAnchorButtonTemplate')
      button.anchorPoint = anchorPoint
      button:RegisterForClicks('AnyUp')
      button:SetScript('OnClick', AnchorButton_OnClick)
      button:SetPoint(anchorPoint)
      button:SetSize(16,16)

      self.anchorButtons[anchorPoint] = button
    end
  end

  for anchorPoint, button in pairs(self.anchorButtons) do
    if anchorPoint == self.handler.anchorPoint then
      button:GetNormalTexture():SetColorTexture(0,1,0,1)
    else
      button:GetNormalTexture():SetColorTexture(0.5,0.5,0.5,1)
    end
  end

  if self.handler.anchorFrom and self.handler.anchorFrame then
    local rb = self.relativeButton
    if not rb then
      rb = CreateFrame('Button', nil, self, 'VeneerAnchorButtonTemplate')
      self.relativeButton = rb
      rb:RegisterForClicks('AnyUp')
      rb:RegisterForDrag('AnyDown')
      rb:SetScript('OnClick', RelativeButton_OnClick)
      rb:SetScript('OnDragStart', RelativeButton_OnDragStart)
      rb:SetScript('OnDragStop', RelativeButton_OnDragStop)
    end

  print('|cFF00FF88Config|r',self.handler.anchorFrom, self.handler.anchorFrame)
    rb:SetPoint(self.handler.anchorFrom, _G[self.handler.anchorFrame], self.handler.anchorFrom, 0, 0)
  print(rb:GetPoint(1))
    rb:GetNormalTexture():SetColorTexture(1,1,1,1)
    rb:SetSize(16,16)
  end


  self:RegisterForDrag('LeftButton')
end



function ConfigLayer:OnDragStart()
  self.originalX, self.originalY = self:GetCenter()
  self.handler:SetMovable(true)
  self.handler:StartMoving()
end
function ConfigLayer:OnDragStop()

  local newX, newY = self:GetCenter()
  local dX = newX - self.originalX
  local dY = newY - self.originalY
  print('registering new X/Y:', dX, dY)


  self.handler:StopMovingOrSizing()
end

function ConfigLayer:OnUpdate()
  local handler = self:GetParent()
  handler.ConfigLayers = handler.ConfigLayers or {}

  self.ConfigName:SetText(handler:GetName())
  self.ConfigID:SetText(handler:GetID())
end

-- Sets a state flag for use in OnUpdate conditionals
function Animation:OnPlay()
  PlaySoundKitID(229)
  self.animating = true
  print('|cFF00FF00Anim:OnPlay|r @', unpack(self.sourcePoint))
end
function Animation:OnStop()
  PlaySoundKitID(229)
  self.animating = nil
  print('|cFF00FF00Anim:OnFinish|r @', unpack(self.destPoint))
end
function Animation:OnFinished()
  PlaySoundKitID(229)
  self.animating = nil
  print('|cFF00FF00Anim:OnFinish|r @', unpack(self.destPoint))
end


function Handler:OnLoad()
  print(self:GetName(), 'loaded')
  self.debug = DEVIAN_WORKSPACE and function(...) _G.print(self:GetName(), ...) end or nop
  self.debug('OnLoad() template')
end

-- Replace if module requires anything besides fixing frame anchors


function Handler:OnShow()
  self:Reanchor()
  _G.Veneer:DynamicReanchor()
end
function Handler:OnHide()
  _G.Veneer:DynamicReanchor()
end
function Handler:Reanchor (anchorAll)
  _G.Veneer:DynamicReanchor()
end

-- Replace if module needs to do more than reconcile SavedVariables pointers
function Handler:Setup()
  print(self:GetName(), '|cFF00FF88Setup()')
  local configName = self:GetName():gsub('^Veneer', '')
  VeneerData[configName] = VeneerData[configName] or self.defaultSettings or {}

  for k,v in pairs(self.data) do
    if not VeneerData[configName][k] then
      print('reconciling pre-data:', k, v)
      VeneerData[configName][k] = v
    end
  end

  if self.EventList then
    for _, event in ipairs(self.EventList) do
      print(self:GetName(), event, 'registered')
      self:RegisterEvent(event)
    end
  end

  local guid = UnitGUID('player')
  self.data = VeneerData[configName]
  self.data[guid] = self.data[guid] or {}
  self.profile = self.data[guid]
  print('data table loaded:', configName)
  self.initialized = true
end

-- Replace to stop collated outputs.
function Handler:Print(...)
  local txt = '|cFFFFFF00'..self:GetName()..'|r:'
  for i = 1, select('#', ...) do
    txt = txt .. ' '.. tostring(select(i, ...))
  end
  DEFAULT_CHAT_FRAME:AddMessage(txt)
end

-- Replace if not using the ConfigLayer template
function Handler:UpdateConfigLayers (configMode)
  -- Override to manage config visual elements when a config update is fired from /vn or login
  if not self:IsShown() then
    self:SetShown(configMode)
    self:Reanchor()
  end
  self.configMode = configMode
end
