
local plugin = CreateFrame('Frame', 'VeneerOptions', UIParent, 'TooltipBorderedFrameTemplate')
local vn, print = LibStub("LibKraken").register(Veneer, plugin)

local fields = {}
local templateTypes = {
  slider = 'Slider',
  radio = 'Frame',
  number = 'EditBox',
  check = 'CheckButton'
}
local templateNames = {
  slider = 'OptionsSliderTemplate',
  radio = '',
  number = 'NumericInputSpinnerTemplate',
  check = 'UICheckButtonTemplate'
}
local OnLoad, OnUpdate, OnValueChanged = {}, {}, {}
local frameHeadings = {}

local framePadding = 14
local frameMaxWidth = 400


local ToggleVeneerOptions = function()

  plugin:Show()
  if plugin.initialized then
    return
  end

  local sizeChanged = false
  local frameDepth = framePadding
  local frameWidth = framePadding
  local lineWidth = framePadding
  local lineNum = 1
  local lineColumn = 1

  for i, module in ipairs(vn.modules) do
    if module.options then
      if not frameHeadings[module] then
        frameHeadings[module] = plugin:CreateFontString(nil, 'OVERLAY', 'VeneerNumberFontLarge')
        frameHeadings[module]:SetText(module.options.nameString or module:GetName())
        frameHeadings[module].height = frameHeadings[module]:GetHeight()

        frameHeadings[module]:SetPoint('TOPLEFT', plugin, 'TOPLEFT', lineColumn, -frameDepth)
        frameDepth = frameDepth +  frameHeadings[module].height
      end

      for index, args in ipairs(module.options) do
        local fullIndex = (i*1000)+index
        print('config field', fullIndex)
        if not fields[fullIndex] then
          fields[fullIndex] = {}
        end
        local opt = fields[fullIndex]

        if not opt.frame then
          sizeChanged = true

          local configType = args.type
          print('Creating', templateTypes[configType] or 'Frame', 'from', templateNames[configType])
          opt.frame = CreateFrame(templateTypes[configType] or 'Frame', 'VeneerOptions' .. args.name, plugin, templateNames[configType])

          if OnLoad[configType] then
            OnLoad[configType](opt.frame, args)
          end
          if opt.OnLoad then
            opt.OnLoad(opt.frame)
          end

          if args.OnUpdate then
            opt.frame.Update = function(self)
              OnUpdate[configType](self, args)
              args.OnUpdate(self, args)
            end
          else
            opt.frame.Update = function(self)
              OnUpdate[configType](self, args)
            end
          end

          opt.frame:Update()

          opt.frame:SetPoint('TOPLEFT', plugin, 'TOPLEFT', lineColumn, -frameDepth)


          opt.name = args.name
          opt.line = lineNum
          opt.column = lineColumn

          -- measure after initializer
          frameDepth = frameDepth + opt.frame:GetHeight()
          lineWidth = lineWidth + opt.frame:GetWidth()
          opt.depth = frameDepth
          opt.width = lineWidth
          local isOverlapped = (lineWidth > frameMaxWidth)
          if args.fullwidth or isOverlapped then
            lineNum = lineNum + 1
            if isOverlapped then
              lineWidth = framePadding + opt.frame:GetWidth()
              lineColumn = 1
            else
              lineWidth = framePadding
              lineColumn = lineColumn + 1
            end
          end

          if lineWidth > frameWidth then
            sizeChanged = true
            frameWidth = lineWidth
          end


        end






      end
    end
  end

  if sizeChanged then
    plugin:SetSize(frameWidth + framePadding, frameDepth + framePadding)

    plugin:SetPoint('CENTER')
  end

end

OnLoad.slider = function(self, args)
  print('min:', args.min, 'max:', args.max, 'steps:', args.step)
  self:SetMinMaxValues(args.min or 0, args.max or 420)
  self:SetValueStep(1)
  self:SetStepsPerPage(5)
  self:SetObeyStepOnDrag(true)
end

OnUpdate.slider = function(self, args)
  local base = args.handler or vn.db
  self:SetValue(vn.db[self.name] or 1)
end

OnValueChanged.slider = function()
end

plugin.cmd = function(cmd)
  cmd = string.lower(cmd)
  if cmd:match('config') then
    ToggleVeneerOptions()
    return true
  end
end

plugin.init = function()
  --ToggleVeneerOptions()
end
