-- Veneer
-- WorldState.lua
-- Created: 10/7/2016 10:55 PM
-- %file-revision%
-- An extensible panel group for HUD values
local _, vn = ...
local L = vn.L
local print = DEVIAN_WORKSPACE and function(...) print('VnWorldState', ...) end or nop

VeneerOrderHallMixin = {
  anchorPoint = 'TOP',
  anchorFrom = 'TOP',
  anchorPriority = 1,
  anchorX = 0,
  anchorY = 0,
  addonTrigger = 'Blizzard_OrderHallUI',
  addonFrame = 'OrderHallCommandBar',
}
--- Order Hall mod
local requiresUpdate
local ocb
function VeneerOrderHallMixin:Setup()
  print('|cFFFFFF00'..self:GetName()..':Setup()')
  ocb = OrderHallCommandBar
  hooksecurefunc(ocb, 'RefreshCategories', function()
    requiresUpdate = true
  end)
  hooksecurefunc(ocb, 'RefreshCurrency',
    function()
      requiresUpdate = true
    end)
  hooksecurefunc(ocb, 'SetShown', function(_, isShown)
    if self:IsShown() ~= isShown then
      self:SetShown(isShown)
      Veneer:DynamicReanchor()
    end
  end)
  hooksecurefunc(ocb, 'RefreshAll', function()
    self:Update()
  end)

  ocb:ClearAllPoints()
  ocb:SetAllPoints(self)


  ocb.WorldMapButton:Hide()
  ocb.AreaName:Hide()

  ocb.Currency:SetFontObject(VeneerHeaderFont)
  ocb.Currency:ClearAllPoints()
  ocb.Currency:SetPoint('BOTTOMLEFT', ocb.ClassIcon, 'BOTTOMRIGHT', 15, 0)

  ocb.CurrencyIcon:ClearAllPoints()
  ocb.CurrencyIcon:SetPoint('TOP', ocb.ClassIcon, 'TOPRIGHT')
  
  ocb.Background:SetColorTexture(0,0,0,0.5)

  -- frame that calls up the resources tooltip
  ocb.CurrencyHitTest:SetPoint('LEFT', ocb.CurrencyIcon, 'LEFT')
  ocb.CurrencyHitTest:SetPoint('RIGHT', ocb.Currency, 'RIGHT')
  
  
  self:SetSize(700, 23)
  self:SetShown(C_Garrison.IsPlayerInGarrison(LE_GARRISON_TYPE_7_0))
end

function VeneerOrderHallMixin:OnUpdate()
  if requiresUpdate then
    self:Update()
  end
  
end

function VeneerOrderHallMixin:OnLoad()
  Veneer:AddHandler(self)
  self:EnableMouse(false)
end


function VeneerOrderHallMixin:OnShow()
  if ocb then
    --self:Print('|cFF00AAFF'..self:GetName()..'|r:OnShow()', ocb:IsShown(), self:IsShown())
    self:Update()
  end
end

function VeneerOrderHallMixin:Update()
  self:SetShown(C_Garrison.IsPlayerInGarrison(LE_GARRISON_TYPE_7_0) or (GetSubZoneText() == L["The Vindicaar"]))
  local lastFrame
  local categoriesWidth = 0
  local troops = OrderHallCommandBar.TroopSummary
  if troops then
    for _, category in ipairs(troops) do
      category.Count:SetFontObject(VeneerHeaderFont)
      category.Count:SetTextColor(1,1,1,1)
      category.Count:ClearAllPoints()
      category.Count:SetPoint('BOTTOMRIGHT', category.Icon, 'BOTTOMRIGHT', -1, 1)
  
      category:ClearAllPoints()
      if lastFrame then
        lastFrame:SetPoint('TOPRIGHT', category, 'TOPLEFT', 0, 0)
      end
      category:SetSize(category.TroopPortraitCover:GetSize())
      
      lastFrame = category
      categoriesWidth = categoriesWidth + category:GetWidth()
      end
    
    if lastFrame then
      lastFrame:SetPoint('TOPRIGHT', ocb, 'TOPRIGHT', 0, 0)
    end
    
  end
  self:SetWidth(ocb.ClassIcon:GetWidth() + 15 + ocb.Currency:GetWidth() + ocb.CurrencyIcon:GetWidth() + categoriesWidth)
  requiresUpdate = nil
  --print('|cFF00AAFF'..self:GetName()..'|r:Update()', OrderHallCommandBar:IsVisible(), self:IsShown())
  --print(debugstack(6))
  Veneer:DynamicReanchor()
end




