-- Veneer
-- TalkingHead.lua
-- Created: 10/23/2016 5:18 AM
-- %file-revision%
--

local FRAME_PADDING = 2

local print = DEVIAN_WORKSPACE and function(...) print('VnTalkingHead', ...) end or nop
local thf
local m = {

  anchorPoint = 'TOPLEFT',
  anchorFrom = 'TOPLEFT',
  anchorX = 0,
  anchorY = 0,
  anchorFrame = 'ChatFrame1',

}
VeneerTalkingHeadMixin = m

local qf = {}


function m:OnLoad()
  Veneer:AddHandler(self, self.anchorPoint)
  LoadAddOn('Blizzard_TalkingHeadUI')
  thf = TalkingHeadFrame
end

function m:Setup()
  print('|cFF00AAFF'..self:GetName()..'|r:Setup()', thf:IsShown(), self:IsShown())


  --hooksecurefunc(thf, 'SetPoint', function(...)
  --  print('SetPoint', ...)
  --  print(debugstack())
  --end)

  self.Name:SetAllPoints(thf.NameFrame.Name)
  self.Text:SetAllPoints(thf.TextFrame.Text)
  self.Portrait:SetAllPoints(thf.PortraitFrame.Portrait)
  self:SetSize(thf:GetSize())

  self:ApplySettings()

  self:SetShown(true)
  self:ClearAnchor()
end

function m:ApplySettings()
  if not thf then
    return
  end

  thf.NameFrame.Name:ClearAllPoints()
  thf.TextFrame.Text:ClearAllPoints()
  thf.PortraitFrame.Portrait:ClearAllPoints()

  print('|cFF00AAFF'..self:GetName()..'|r:OnShow()', thf:IsShown(), self:IsShown())
  thf.BackgroundFrame.TextBackground:SetColorTexture(0,0,0,.5)

  thf.NameFrame.Name:SetPoint('TOPLEFT', thf.PortraitFrame.Portrait, 'TOPRIGHT', FRAME_PADDING, 0)
  thf.NameFrame.Name:SetPoint('RIGHT', thf, 'RIGHT', -FRAME_PADDING, 0)
  thf.PortraitFrame.Portrait:SetPoint('TOPLEFT', thf, 'TOPLEFT', FRAME_PADDING, -FRAME_PADDING)


  thf.TextFrame.Text:SetPoint('TOPLEFT', thf.NameFrame.Name, 'BOTTOMLEFT', 0, -FRAME_PADDING)
  thf.TextFrame.Text:SetPoint('BOTTOMRIGHT', thf, 'BOTTOMRIGHT', -FRAME_PADDING, FRAME_PADDING)

  thf.BackgroundFrame.TextBackground:SetColorTexture(0,0,0,.75)

  thf.MainFrame.CloseButton:SetPoint('TOPRIGHT', thf, 'TOPRIGHT', 0, 0)

  --thf:EnableMouse(false)
  thf:ClearAllPoints()
  thf:SetAllPoints(self)

end

function m:ClearAnchor()
  if not thf then
    return
  end

  UIPARENT_MANAGED_FRAME_POSITIONS["TalkingHeadFrame"] = nil
  for i, alertSubSystem in pairs(AlertFrame.alertFrameSubSystems) do
    if alertSubSystem.anchorFrame == thf then
      tremove(AlertFrame.alertFrameSubSystems, i)
      return
    end
  end
end

function m:OnShow()
  if thf then
    print('|cFF00AAFF'..self:GetName()..'|r:OnShow()', thf:IsShown(), self:IsShown())
    print(debugstack())
    self:Update()
  end
end

function m:Reanchor()
  self:ClearAllPoints()
  self:SetPoint(self.anchorPoint, _G[self.anchorFrame], self.anchorFrom, self.anchorX, self.anchorY)
  self:SetPoint('RIGHT', _G[self.anchorFrame], 'RIGHT', 2, 0)
  -- independent module,
end

function m:OnHide()
  if thf then
    print('|cFF00AAFF'..self:GetName()..'|r:OnHide()', thf:IsShown(), self:IsShown())
  end
  Veneer:Reanchor()
end

function m:Update()
  if not thf then
    return
  end

  Veneer:InternalReanchor(self)
end
