
local print = DEVIAN_WORKSPACE and function(...) print('VnRoster', ...) end or nop



VeneerPetBattleActionMixin = {}
VeneerPetBattleInfoMixin = {}
local pb = VeneerPetBattleInfoMixin
local action = VeneerPetBattleActionMixin


function pb:OnShow()
  self:ClearAllPoints()
  self:SetPoint('TOPLEFT', PetBattleFrame.EnemyBuffFrame, 'BOTTOMLEFT', 0, -12)
  self:RegisterEvent('PET_BATTLE_PET_ROUND_PLAYBACK_COMPLETE')
  self:RegisterEvent('PET_BATTLE_ACTION_SELECTED')
  self:RegisterEvent('PET_BATTLE_TURN_STARTED')
  print('pet on show')
  self:Refresh()
end

function pb:OnHide()
  print('pet on hide')
  self:UnregisterAllEvents()
end

function pb:OnEvent(event)
  print('pb event|cFFFF8800', event)
  self:Refresh()
end

function pb:Refresh()
  local myPetSlot = C_PetBattles.GetActivePet(1)
  local myPetType = C_PetBattles.GetPetType(1, myPetSlot)

  local index = 0
  local nonActiveIndex = 0
  local lastFrame, lastNonActive
  for petSlot = 1, C_PetBattles.GetNumPets(2) do

    for abilitySlot = 1,3 do
      local _, name, texture, cooldown, tooltip,_, abilityType, noStrongWeakHints = C_PetBattles.GetAbilityInfo(2, petSlot, abilitySlot)
      local petHealth = C_PetBattles.GetHealth(2, petSlot)

      if petHealth >= 1 then
        local isUsable, currentCooldown, currentLockdown = C_PetBattles.GetAbilityState(2, petSlot, abilitySlot);
        --print(index, petSlot, abilitySlot, name, currentCooldown, currentLockdown, cooldown, petHealth)

        index = index + 1
        local frame = self.Abilities[index]

        frame.ownerID = 2
        frame.petIndex = petSlot
        frame.abIndex = abilitySlot
        frame.tooltip = tooltip
        frame.Name:SetText(name)
        frame.Icon:SetTexture(texture)
        frame.TypeIcon:SetTexture("Interface\\PetBattles\\PetIcon-"..PET_TYPE_SUFFIX[abilityType])


        for i = 1,C_PetBattles.GetNumPets(1) do
          local myPetType = C_PetBattles.GetPetType(1, i)
          if not (myPetType or abilityType) then
            frame.BetterIcon[i]:Hide();
          else
            local modifier = C_PetBattles.GetAttackModifier(abilityType, myPetType)
            if ( noStrongWeakHints or modifier == 1 ) then
              frame.BetterIcon[i]:Hide();
            elseif (modifier > 1) then
              frame.BetterIcon[i]:SetTexture("Interface\\PetBattles\\BattleBar-AbilityBadge-Strong");
              frame.BetterIcon[i]:Show();
            elseif (modifier < 1) then
              frame.BetterIcon[i]:SetTexture("Interface\\PetBattles\\BattleBar-AbilityBadge-Weak");
              frame.BetterIcon[i]:Show();
            end

          end
        end


        if cooldown >= 1 then
          frame.Border2:Show()
        else

          frame.Border2:Hide()
        end


        currentCooldown = (currentCooldown >= 1) and currentCooldown or 0
        if petHealth == 0 then
          frame.Cooldown:SetText(nil)
          frame.Cooldown:SetTextColor(1,0,0)
        else
          if currentLockdown >= 1 and currentLockdown > currentCooldown then
            frame.Cooldown:SetTextColor(1,0,0)
          else
            frame.Cooldown:SetTextColor(1,1,1)
          end
          frame.Cooldown:SetText((currentCooldown >= 1) and currentCooldown or nil)
        end

        frame:ClearAllPoints()
        if petSlot ==  C_PetBattles.GetActivePet(2) then
          frame:SetSize(48,48)
          frame.Border2:SetSize(72,72)
          frame.Icon:SetDesaturated(false)
          frame.Name:SetTextColor(1,1,0)
          if lastFrame then
            frame:SetPoint('TOPLEFT', lastFrame, 'BOTTOMLEFT', 0, -4)
          else
            frame:SetPoint('TOPLEFT', self, 'TOPLEFT')
          end
          lastFrame = frame
        else
          frame:SetSize(24,24)
          frame.Border2:SetSize(36,36)
          frame.Name:SetTextColor(0.5,0.5,0.5)
          frame.Icon:SetDesaturated(true)
          if lastNonActive then
            frame:SetPoint('TOPLEFT', lastNonActive, 'BOTTOMLEFT', 0, -2)
          else
            frame:SetPoint('TOPLEFT', self, 'TOPLEFT', 128, 0)
          end
          lastNonActive = frame
        end
        frame:Show()
      end
    end
  end

  for i = index + 1, #self.Abilities do
    self.Abilities[i]:Hide()
  end
end

function action:OnEnter()
  PetBattleAbilityTooltip_SetAbility(self.ownerID, self.petIndex, self.abIndex);
  PetBattleAbilityTooltip_Show("TOPRIGHT", self:GetParent(), "TOPLEFT", -5, 0, self.additionalText);
end

function action:OnLeave()
  PetBattlePrimaryAbilityTooltip:Hide();
end
