
local print = DEVIAN_WORKSPACE and function(...) print('LFGFrame', ...) end or nop

VeneerRosterKunMixin = {
  anchorFrame = 'LFGListFrame',
  anchorPoint = 'TOPLEFT',

  InvasionsDirty = true,
  AchievementsDirty = true,
  GuildInfoDirty = true,
  blocks = {},
}


local module = VeneerRosterKunMixin

function module:OnLoad()
  Veneer:AddHandler(self, self.anchorPoint)
  self:RegisterEvent('ADDON_LOADED')

  hooksecurefunc("LFGListCategorySelection_StartFindGroup", function(panel, questID)
    print('LFGListCategorySelection_StartFindGroup', panel:GetParent(), questID)
  end)
  hooksecurefunc("LFGListCategorySelection_SelectCategory", function(panel, categoryID, filters)
    print('LFGListCategorySelection_SelectCategory', panel:GetParent(), categoryID, filters)
    print('\n',debugstack(3))
  end)
  hooksecurefunc("LFGListSearchPanel_SetCategory", function(panel, categoryID, filters, baseFilters)
    print('LFGListSearchPanel_SetCategory', panel:GetParent(), categoryID, filters, baseFilters)
  end)
end

function module:Setup()
  VeneerHandlerMixin.Setup(self)
  self:SetParent(LFGListFrame)
  self:SetPoint('TOPLEFT', LFGListFrame,'TOPRIGHT')
  self:SetShown(true)
end

function module:SetDirty()
  if self:IsVisible() then
    self:Update()
  else
    self.GuildInfoDirty = true
    self.AchievementsDirty = true
    self.InvasionsDirty = true
  end
end
local firstLoad = true
function module:OnShow()
  print('|cFF00FFFFOnShow()|r')
  self:Update(firstLoad)
  firstLoad = nil

  local locationName = GetRealZoneText()

  if not C_LFGList.GetActiveEntryInfo() and locationName and locationName:match('Invasion') and not InCombatLockdown() then
    PVEFrame_ShowFrame("GroupFinderFrame", LFGListPVEStub);
    local panel = LFGListFrame.CategorySelection
    LFGListCategorySelection_SelectCategory(panel, 6, 0);
    LFGListCategorySelection_StartFindGroup(panel, locationName);
  end
end

function module:UpdateGuildInfo()
  local numMembers = GetNumGuildMembers()
  print(numMembers)
  for i = 1, numMembers do
    --print(GetGuildRosterInfo(i))
  end
  self.GuildInfoDirty = nil
end

-- cheevos to link
local overlaps = {
  [11781] = 11875,
  [12002] = 12111,
}
local cheevos = {
  -- Mythic Prog
  {
    -- Antorus
    12002, -- argus
    12001, -- aggramar
    12000, -- coven
    11999, -- barry
    11998, -- kin'garoth
    11997, -- imonar
    11996, -- eonar
    11995, -- portal keeper
    11994, -- high command
    11993, -- doggos
    11992, -- worldbreaker

    -- Tomb of Sargeras
    11781, -- kj
    11780, -- avatar
    11779, -- maiden
    11776, -- mistress
    11778, -- host,
    11777, -- sisters
    11775, -- harjatan,
    11774, -- di,
    11773, -- goroth
  },
  -- Completion
  {
    12111, -- CE Argus,
    12110, -- AotC Argus,
    11875, -- CE KJ
    11874, -- AotC KJ
    11790 -- Deceiver's Fall,


  },
  -- Mythic+
  {
    11162, -- master
    11185, -- conqueror
  }
}

local invasion = {}
local cheev = {}

function cheev:OnClick()
  local resultID = LFGListFrame.SearchPanel.selectedResult or self:GetParent().selectedID
  print('current selection = ', resultID)
  if ACTIVE_CHAT_EDIT_BOX then
    ChatEdit_InsertLink(self.link)
  elseif resultID then
    local id, activityID, name, comment, voiceChat, iLvl, honorLevel, age, numBNetFriends, numCharFriends, numGuildMates, isDelisted, leaderName = C_LFGList.GetSearchResultInfo(resultID);
    --print(name, comment, leaderName)
    ChatFrame_OpenChat("/w "..leaderName.." "..self.link, DEFAULT_CHAT_FRAME)
  end
end

function invasion:OnClick()
  if not InCombatLockdown() then
  PVEFrame_ShowFrame("GroupFinderFrame", LFGListPVEStub);
  local panel = LFGListFrame.CategorySelection
  LFGListCategorySelection_SelectCategory(panel, 6, 0);
  LFGListCategorySelection_StartFindGroup(panel, self.searchText);
  end

end

local listed = {}


function module:Update(forced)
  if self.GuildInfoDirty or forced then
    self:UpdateGuildInfo()
  end
  local numBlocks =  0
  if self.AchievementsDirty or forced then
    numBlocks = self:UpdateAchievementLinks(numBlocks)
  end

  if self.InvasionsDirty or forced then
    numBlocks =  self:UpdateInvasionButtons(numBlocks)
  end

  local lastBlock
  local contentsHeight = 0
  for index, block in ipairs(self.blocks) do
    if index > numBlocks then
      block:Hide()
    else
      block:ClearAllPoints()
      if lastBlock then
        block:SetPoint('TOPLEFT', lastBlock, 'BOTTOMLEFT', 0, -2)
      else
        block:SetPoint('TOPLEFT', LFGListFrame, 'TOPRIGHT', 0, 0)
      end
      block:Show()
      lastBlock = block

      contentsHeight = contentsHeight + block:GetHeight()
    end
  end
  self:SetHeight(contentsHeight)
end


function module:GetBlock(index)

  local block =self.blocks[index]
  if not block then
    block = CreateFrame('Button', 'VeneerRosterKunBlock'..index, self, 'VeneerRosterKunBlock')

    block:SetID(index)
    self.blocks[index] = block
  end
  return block
end

function module:UpdateInvasionButtons(offset)
  print('UpdateInvasionButtons()')
  offset = offset or 0
  local lastBlock = self.lastAchievement

  local contentsHeight = 0
  local areaPOIs = C_WorldMap.GetAreaPOIForMap(GetCurrentMapAreaID(), 1);
  if areaPOIs then


    for i, areaPoiID in ipairs(areaPOIs) do
      local poiInfo = C_WorldMap.GetAreaPOIInfo(GetCurrentMapAreaID(), areaPoiID, 1);

      offset = offset + 1
      --print(index)
      local block = self:GetBlock(offset)
      block:SetScript('OnClick', invasion.OnClick)
      block.Label:SetText(poiInfo.description)
      block.Icon:SetAtlas(poiInfo.atlasName)
      block.searchText = poiInfo.description
      block.buttonType = 'group-poi'
    end
  end
  return offset, contentsHeight
end

function module:UpdateAchievementLinks(offset)
  print('UpdateAchievementLinks()')
  offset = offset or 0
  local resultID = LFGListFrame.SearchPanel.selectedResult or self.selectedID
  self:Show()


  local contentsHeight = 0
  for _, group in ipairs(cheevos) do
    for _, id in ipairs(group) do
      local _, name, points, completed, month, day, year, description, flags, icon = GetAchievementInfo(id)
      if completed then
        -- if the highest mythic kill
        if listed[overlaps[id]] then
          break
        end
        offset = offset + 1
        local block = self:GetBlock(offset)
        block:SetScript('OnClick', cheev.OnClick)
        --print(index)

        block.link = GetAchievementLink(id)
        block.Icon:SetTexture(icon)
        block.Label:SetText(name)
        block.buttonType = 'cheevo'

        contentsHeight = contentsHeight + block:GetHeight()

        --print(index, name, icon)
        listed[id] = true
        break;
      end
    end
  end

  self.lastAchievement = lastBlock

  return offset, contentsHeight

  --[[
   --]]


end

function module:SetupGuildUI()
  self:UnregisterEvent('ADDON_LOADED')
end
function module:OnEvent(event, ...)
  print('|cFFFF0088OnEvent()|r', event, ...)
  if event == 'ADDON_LOADED' then
    local addon = ...
    if addon == 'Blizzard_GuildUI' then
      self:SetupGuildUI()
    end
  elseif event == 'LFG_LIST_SEARCH_RESULTS_RECEIVED' then
  elseif event == 'LFG_LIST_SEARCH_RESULT_UPDATED' then
  end
end
