--
-- Created by IntelliJ IDEA.
-- User: Nick
-- Date: 3/25/2017
-- Time: 7:07 PM
-- To change this template use File | Settings | File Templates.
--

local print = DEVIAN_WORKSPACE and function(...) print('Currency', ...) end or nop
local profileUpdate, needsUpdate


local itemBlock =  {}
local currencyBlock = {}


local events = {
  'CHAT_MSG_LOOT',
  "ZONE_CHANGED_NEW_AREA", "ZONE_CHANGED_INDOORS", "ZONE_CHANGED",
  'BAG_UPDATE', 'CURRENCY_DISPLAY_UPDATE', 'CHAT_MSG_CURRENCY',
}

local blocks = {
  ["Ancient Mana"] = {
    currencyID = 1155,
    showMax = true,
    zones = {
      ['Suramar'] = true,
    },
  },
  ["Blood of Sargeras"] = {
    itemID = 124124,
  },
  ["Legionfall War Supplies"] = {
    currencyID = 1342,
    zones = {
      ["Broken Shore"] = true
    }
  },
  ["Nethershard"] = {
    currencyID = 1226,
    zones = {
      ["Broken Shore"] = true
    }
  },
  ["Veiled Argunite"] = {
    currencyID = 1508,
    zones = {
      ["Antoran Wastes"] = true,
      ["Krokuun"] = true,
      ["MacAree"] = true,
    }
  },
}
local items, currencies = {}, {}


VeneerCurrencyMixin = {
  Blocks = {},
  HideCombat = true,
  EventList = {'PLAYER_ENTERING_WORLD'},
  moduleName = 'Currency Watch',
  anchorPoint = 'TOP',
  anchorPriority = 2,
}
VeneerCurrencyBlockMixin = {}
local module = VeneerCurrencyMixin
local block = VeneerCurrencyBlockMixin



local function RegisterEvents (frame, events)
  for _, event in ipairs(events) do
    print('|cFFFF0088'..(frame.name or frame:GetName())..'|r', 'listening to', event)
    frame:RegisterEvent(event)
  end
end

function module:Setup()
  self:Reanchor()
end

function module:OnLoad ()
  Veneer:AddHandler(self)

  for _, event in ipairs(events) do
    self:RegisterEvent(event)
  end


  for name, info in pairs(blocks) do
    local block = CreateFrame('Frame', nil, self, 'VeneerCurrencyTemplate')
    block.name = name
    for k,v in pairs(info) do
      print(name, k, '=', v)
      block[k] = v
    end

    block.debug = function(...)
      print('|cFF0088FF<'..block.name..'>|r', ...)
    end
    block.id = info.itemID or info.currencyID

    block:SetScript('OnEnter', itemBlock.OnEnter or block.OnEnter)
    block:SetScript('OnLeave', itemBlock.OnLeave or block.OnLeave)

    if info.itemID then
      local itemID = info.itemID
      items[itemID] = {
        count = 0,
        frame = block
      }
      block.Update = itemBlock.Update
    elseif info.currencyID then
      local currencyID = info.currencyID
      block.Update = currencyBlock.Update
    end



    if info.zones then
      local zones = info.zones
      local of = block.Update
      function block:Update()

        local zone = GetRealZoneText()
        local subZone = GetSubZoneText()
        local canShow = ((zone and self.zones[zone]) or (subZone and self.zones[subZone])) and true or false
        block.debug('Zone Check', zone, subZone, canShow)
        if of then
          canShow = canShow and of(self)
        end
        return canShow
      end
    end
  end

  self:RegisterEvent('PLAYER_REGEN_ENABLED')
  self:RegisterEvent('PLAYER_REGEN_DISABLED')
end

function module:OnEvent (event, arg)
  --print(self:GetName(), 'OnEvent', event, arg)
  self:Update()
end

function module:Update()
  --print(self:GetName(), 'Reanchor()')
  if InCombatLockdown() then
    self:SetShown(false)
    return
  end


  for itemID in pairs(items) do
    items[itemID].count = 0
  end

  local canShow = false
  if BagBrother then
    for i, bag in pairs(BagBrother.Player) do
      if type(bag) == 'table' then
        --print(i)
        for j, item in pairs(bag) do
          local itemID, count = string.match(item ,"^(%d+):.+;(%d*)")
          itemID = tonumber(itemID)
                if itemID then
                  --print(j, itemID)
            count = tonumber(count)
            if count and count >= 1 then
              local texture = GetItemIcon(itemID)
              --print(itemID)

              if items[itemID] then
                items[itemID].count = items[itemID].count + (count or 1)
                if not items[itemID].texture then
                  items[itemID].texture = texture
                  --print('tracked currency tally', items[itemID].count, '|T'..texture..':16:16|t')
                  items[itemID].frame.Icon:SetTexture(texture)
                end
              end
            end
          end
        end
      end

    end
  else
    for i = 0, NUM_BAG_SLOTS do
      local numSlots = GetContainerNumSlots(i)
      for j = 1, numSlots do
        local itemID = GetContainerItemID(i, j)
        local texture, count = GetContainerItemInfo(i,j)
        if items[itemID] then

          items[itemID].count = items[itemID].count + (count or 1)
          if not items[itemID].texture then
            items[itemID].texture = texture
            print('tracked currency tally', items[itemID].count, '|T'..texture..':16:16|t')
            items[itemID].frame.Icon:SetTexture(texture)
          end
        end
      end
    end
  end



  local lastBlock
  local totalWidth = 0
  for _, block in ipairs(self.Blocks) do
    local blockIsShown = block:Update()
    print(block.name, blockIsShown)
    block:SetShown(blockIsShown)
    canShow = canShow or blockIsShown


    if blockIsShown then
      block:ClearAllPoints()
      if lastBlock then
        block:SetPoint('TOPLEFT', lastBlock, 'TOPRIGHT')
      else
        block:SetPoint('TOPLEFT', self, 'TOPLEFT')
      end
      lastBlock = block

      block:SetHeight(24)
      block:SetWidth(block.Icon:GetWidth() + block.Label:GetStringWidth()+4)
      totalWidth = totalWidth + block:GetWidth()
    end
    print('|cFF0088FF'..block.name..'|r', block:IsShown(), block:GetSize())
  end

  self:UpdateProfile()
  self:SetWidth(totalWidth)

  needsUpdate = nil
  print(self:IsShown(), '|cFF00FF88'..self:GetName()..'|r', self:GetSize())
  self:SetShown(canShow)
  Veneer:DynamicReanchor()
end

function module:UpdateProfile()
  if not self.profile then
    profileUpdate = true
    return
  end

  for itemID, info in pairs(items) do
    self.profile.Items = self.profile.Items or {}
    self.profile.Items[itemID] = info
  end
end

function module:OnUpdate()
  if needsUpdate then
    self:Update(GetRealZoneText(), GetSubZoneText())
  elseif profileUpdate then
    self:UpdateProfile()
  end

end

function block:OnEnter()
  if not InCombatLockdown() then
    GameTooltip:SetOwner(self, "ANCHOR_BOTTOMRIGHT");
    if self.currencyID then
      GameTooltip:SetCurrencyTokenByID(self.currencyID);
    else
      GameTooltip:SetItemByID(self.itemID);
    end
    GameTooltip:Show();
  end
end
function block:OnLeave()
  if GameTooltip:IsOwned(self) then
    GameTooltip_Hide()
  end
end


function itemBlock:Update()
  if items[self.itemID].count >= 1 then
    self.Icon:SetTexture(GetItemIcon(self.id))
    self.Label:SetFormattedText("%d", items[self.id].count)
    return true
  end
  return false
end

function currencyBlock:Update()
  local name, earned, texture, earnedThisWeek, weeklyMax, totalMax = GetCurrencyInfo(self.id)

  self.Icon:SetTexture(texture)
  if self.showMax then
    self.Label:SetFormattedText("%d / %d", earned, totalMax)
  else
    self.Label:SetFormattedText("%d", earned)
  end
  return true
end
