--
-- Background data gathering for things that are only available from set places


local print = DEVIAN_WORKSPACE and function(...) print('Bank', ...) end or nop
local profileUpdate, needsUpdate
VeneerBankDBMixin = {}
local m = VeneerBankDBMixin

function m:Setup()


  self:RegisterEvent('BANKFRAME_OPENED')
  self:RegisterEvent('BANKFRAME_CLOSED')

  self:SetPoint('CENTER', UIParent, 'CENTER')
  self:SetSize(100,100)
  m.Info:SetPoint('CENTER', self, 'CENTER')

  print('Setup()')


  self.Info:SetFontObject(GameFontNormal)
  self.Info:SetText('Setup')

  for k,v in pairs(self) do
    print(k,v)
  end
end

local itemsByID = {}
local itemsBySlot = {}
local bankslots = {-1}
function m:OnEvent(event)
  print('OnEvent', event)

  for i = 1, NUM_BANKBAGSLOTS do
    if not tContains(bankslots, i) then
      tinsert(bankslots, i)
    end
  end

  for _, container in pairs(bankslots) do
    for slot = 1, GetContainerNumSlots(container) do
      local item = GetContainerItemID()

      local itemID = GetContainerItemID(container, slot)
      local texture, count, locked, quality, lootable, link = GetContainerItemInfo(container, slot)
      if itemsByID[itemID] then
        itemsByID[itemID].count = itemsByID[itemID].count + (count or 1)
        if not itemsByID[itemID].texture then
          itemsByID[itemID].texture = texture
          print('tracked currency tally', itemsByID[itemID].count, '|T'..texture..':16:16|t')
          itemsByID[itemID].frame.Icon:SetTexture(texture)
        end
      end

      itemsBySlot[container] = itemsBySlot[container] or {}
      itemsBySlot[container][slot] = itemsBySlot[container][slot] or {}
      itemsBySlot[container][slot].texture = texture
      itemsBySlot[container][slot].count = count
      itemsBySlot[container][slot].quality = quality
      itemsBySlot[container][slot].lootable = lootable
      itemsBySlot[container][slot].link = link

    end

  end
end




