local emotes = {
	-- Add emotes here, they will be surrounded with ":"
	-- Images must be .tga format, 32x32 pixels in the Emotes folder
	"56percent",
	"angery",
	"boonta",
	"bozibad2",
	"bozibad2_1",
	"bozibad2_2",
	"bozibad2_3",
	"bozibad2_4",
	"bozikiss",
	"bred",
	"catidiot",
	"deflatedsherrin",
	"dinnerboy",
	"doublethink",
	"gkick", 
	"monkaTOS", 
	"nize", 
	"rolf",
	"seemsbozi",
}

-- Restart game after adding emotes

-------------------------------------------------------------------------------------------------
-- Do not edit below this line
-------------------------------------------------------------------------------------------------

local defaultpack = {};
local emoticons = {};

for i, emote in ipairs(emotes) do
	defaultpack[emote] = "Interface\\AddOns\\UnluckyTwitchEmotes\\Emotes\\"..emote..".tga:28:28";
	emoticons[":"..emote.. ":"] = emote;
end

-- Spaghetti code - no ":" for this baby
local emote = "Pog"
defaultpack[emote] = "Interface\\AddOns\\UnluckyTwitchEmotes\\Emotes\\"..emote..".tga:28:28";
emoticons[emote] = emote;

-- Hook into function used to construct the dropdown menu

local Emoticons_LoadChatFrameDropdown_old = Emoticons_LoadChatFrameDropdown;

function Emoticons_LoadChatFrameDropdown(self, level, menuList)

	local info = Lib_UIDropDownMenu_CreateInfo();
	if (level or 1) == 1 then
		local info = Lib_UIDropDownMenu_CreateInfo();
		info.hasArrow = true;
		info.text = "Unlucky";
		info.value = false;
		info.menuList = "Unlucky";
		Lib_UIDropDownMenu_AddButton(info);
	end

	if (menuList == "Unlucky") then
		for k,v in ipairs(emotes) do
			info.text       = "|T"..defaultpack[v].."|t :"..v..":";
			info.value      = ":"..v..":";
			info.func = Emoticons_Dropdown_OnClick;
			Lib_UIDropDownMenu_AddButton(info, level);
		end
	else
		Emoticons_LoadChatFrameDropdown_old(self, level, menuList)
	end
end

-- Re-register the init function with our hooked function declaration
Lib_UIDropDownMenu_Initialize(EmoticonChatFrameDropDown, Emoticons_LoadChatFrameDropdown, "MENU", 1);

local Emoticons_Dropdown_OnClick_old = Emoticons_Dropdown_OnClick;

function Emoticons_Dropdown_OnClick(self,arg1,arg2,arg3)
	ChatEdit_ActivateChat(ChatEdit_ChooseBoxForSend());
	Emoticons_Dropdown_OnClick_old(self, arg1, arg2, arg3);
	ChatEdit_ChooseBoxForSend():SetText(ChatEdit_ChooseBoxForSend():GetText().." ");
end

local Emoticons_Deformat_old = Emoticons_Deformat;

function Emoticons_Deformat(msg)
	for k,v in pairs(emoticons) do
		msg=string.gsub(msg,"|T"..defaultpack[k].."%:28%:28|t",v);
	end
	return Emoticons_Deformat_old(msg);
end

local Emoticons_InsertEmoticons_old = Emoticons_InsertEmoticons;

function Emoticons_InsertEmoticons(msg)
	for k,v in pairs(emoticons) do
		if (string.find(msg,k,1,true)) then
			msg = string.gsub(msg,"(%s)"..k.."(%s)","%1|T"..defaultpack[v].."|t%2");
			msg = string.gsub(msg,"(%s)"..k.."$","%1|T"..defaultpack[v].."|t");
			msg = string.gsub(msg,"^"..k.."(%s)","|T"..defaultpack[v].."|t%1");
			msg = string.gsub(msg,"^"..k.."$","|T"..defaultpack[v].."|t");
			msg = string.gsub(msg,"(%s)"..k.."(%c)","%1|T"..defaultpack[v].."|t%2");
			msg = string.gsub(msg,"(%s)"..k.."(%s)","%1|T"..defaultpack[v].."|t%2");
		end
	end
	return Emoticons_InsertEmoticons_old(msg);
end