local DB_VERSION = 0.00;

local _, tb = ...;

local MAX_BIT_FLAGS_TUTORIAL = 4294934528;
local cvar_fields = {
	"shipyardMissionTutorialFirst",
	"shipyardMissionTutorialBlockade",
	"shipyardMissionTutorialAreaBuff",
	"lastVoidStorageTutorial",
};
local bit_fields = {
	LE_FRAME_TUTORIAL_ARTIFACT_APPEARANCE_TAB,
	LE_FRAME_TUTORIAL_ARTIFACT_KNOWLEDGE,
	LE_FRAME_TUTORIAL_ARTIFACT_RELIC_MATCH,
	LE_FRAME_TUTORIAL_BAG_SETTINGS,
	LE_FRAME_TUTORIAL_BAG_SLOTS_AUTHENTICATOR,
	LE_FRAME_TUTORIAL_BONUS_ROLL_ENCOUNTER_JOURNAL_LINK,
	LE_FRAME_TUTORIAL_BOOSTED_SPELL_BOOK,
	LE_FRAME_TUTORIAL_BOUNTY_FINISHED,
	LE_FRAME_TUTORIAL_BOUNTY_INTRO,
	LE_FRAME_TUTORIAL_BRAWL,
	LE_FRAME_TUTORIAL_CLEAN_UP_BAGS,
	LE_FRAME_TUTORIAL_FRIENDS_LIST_QUICK_JOIN,
	LE_FRAME_TUTORIAL_GAME_TIME_AUCTION_HOUSE,
	LE_FRAME_TUTORIAL_GARRISON_BUILDING,
	LE_FRAME_TUTORIAL_GARRISON_LANDING,
	LE_FRAME_TUTORIAL_GARRISON_ZONE_ABILITY,
	LE_FRAME_TUTORIAL_HEIRLOOM_JOURNAL,
	LE_FRAME_TUTORIAL_HEIRLOOM_JOURNAL_LEVEL,
	LE_FRAME_TUTORIAL_HEIRLOOM_JOURNAL_TAB,
	LE_FRAME_TUTORIAL_HONOR_TALENT_FIRST_TALENT,
	LE_FRAME_TUTORIAL_HONOR_TALENT_HONOR_LEVELS,
	LE_FRAME_TUTORIAL_HONOR_TALENT_PRESTIGE,
	LE_FRAME_TUTORIAL_INVENTORY_FIXUP_CHECK_EXPANSION_LEGION,
	LE_FRAME_TUTORIAL_INVENTORY_FIXUP_EXPANSION_LEGION,
	LE_FRAME_TUTORIAL_LFG_LIST,
	LE_FRAME_TUTORIAL_PET_JOURNAL,
	LE_FRAME_TUTORIAL_PROFESSIONS,
	LE_FRAME_TUTORIAL_REAGENT_BANK_UNLOCK,
	LE_FRAME_TUTORIAL_RELIC_FORGE_LEARN_TRAIT,
	LE_FRAME_TUTORIAL_RELIC_FORGE_PREVIEW_RELIC,
	LE_FRAME_TUTORIAL_RELIC_FORGE_SOCKETED_RELIC,
	LE_FRAME_TUTORIAL_REPUTATION_EXALTED_PLUS,
	LE_FRAME_TUTORIAL_SPEC,
	LE_FRAME_TUTORIAL_SPELLBOOK,
	LE_FRAME_TUTORIAL_TALENT,
	LE_FRAME_TUTORIAL_TOYBOX,
	LE_FRAME_TUTORIAL_TOYBOX_FAVORITE,
	LE_FRAME_TUTORIAL_TOYBOX_MOUSEWHEEL_PAGING,
	LE_FRAME_TUTORIAL_TRANSMOG_JOURNAL_TAB,
	LE_FRAME_TUTORIAL_TRANSMOG_MODEL_CLICK,
	LE_FRAME_TUTORIAL_TRANSMOG_OUTFIT_DROPDOWN,
	LE_FRAME_TUTORIAL_TRANSMOG_SETS_TAB,
	LE_FRAME_TUTORIAL_TRANSMOG_SETS_VENDOR_TAB,
	LE_FRAME_TUTORIAL_TRANSMOG_SPECS_BUTTON,
	LE_FRAME_TUTORIAL_TRIAL_BANKED_XP,
	LE_FRAME_TUTORIAL_WORLD_MAP_FRAME,
	LE_FRAME_TUTORIAL_X,
};

tb.frame = CreateFrame("Frame", "TutorialBusterFrame", UIParent);
tb.frame:RegisterEvent("PLAYER_ENTERING_WORLD");
tb.frame:SetScript("OnEvent", function(self, event, ...)
	return tb[event] and tb[event](tb, ...);
end);

function tb:PLAYER_ENTERING_WORLD(self, ...)
	if (not GetCVar("lastGarrisonMissionTutorial") or tonumber(GetCVar("lastGarrisonMissionTutorial")) < MAX_BIT_FLAGS_TUTORIAL) then
		SetCVar("lastGarrisonMissionTutorial", MAX_BIT_FLAGS_TUTORIAL);
	end
	if (not GetCVar("orderHallMissionTutorial") or tonumber(GetCVar("orderHallMissionTutorial")) < MAX_BIT_FLAGS_TUTORIAL) then
		SetCVar("orderHallMissionTutorial", MAX_BIT_FLAGS_TUTORIAL);
	end

	local _, field;
	for _,field in pairs(cvar_fields) do
		if (tonumber(GetCVar(field)) == 0) then
			SetCVar(field, 1);
		end
	end
	for _,field in pairs(bit_fields) do
		if (not GetCVarBitfield("closedInfoFrames", field)) then
			SetCVarBitfield("closedInfoFrames", field, true);
		end
	end
	
	tb.frame:UnregisterEvent("ADDON_LOADED");
end