﻿DEFAULT_LANGUAGE = nil
KNOWN_LANGUAGES = nil

SLASH_TRANS1 = "/trans"
SLASH_TRANS2 = "/translate"

ASCII = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^"

SlashCmdList["TRANS"] = function(msg, editBox) Translator_Input(msg, editBox) end

function Translator_OnEvent(event, eventType, arg1, arg2, arg3, arg4)
    if (eventType == "PLAYER_LOGIN") then
		DEFAULT_LANGUAGE = GetDefaultLanguage("player")
		KNOWN_LANGUAGES = ""
		
		local count = GetNumLanguages()
		for x = 1, count do
  			KNOWN_LANGUAGES = KNOWN_LANGUAGES..GetLanguageByIndex(x)
		end
		
		if (LEXICON[DEFAULT_LANGUAGE..DEFAULT_LANGUAGE] == nil) then
			Translator_ChatMsg(DEFAULT_LANGUAGE.." is not supported by this version of translator.")
		else
			local version = GetAddOnMetadata("Translator", "Version");
			Translator_ChatMsg("Translator v"..version.." loaded. Type /trans for usage.")
		end
    end
end

function Translator_Check(self, eventType, msg, speaker, language, ...)
	local decoded = nil
	
	if (string.find(msg, "[^%s][^%s]") == nil) then
		if (string.find(KNOWN_LANGUAGES, language) ~= nil) then
			decoder = LEXICON[language..language]
		else
			decoder = LEXICON[language..DEFAULT_LANGUAGE]
		end
		
		if (decoder ~= nil) then
			decoded = Translator_Decode(msg, decoder)
		end
	end
	
	if (decoded ~= nil) then
		return false, decoded, speaker, "|cFFFFAA11"..language.."|r", ...;
	else
		return false;
	end
end

function Translator_Encode(message, encoder)
	message = string.upper(message)
	
	local temp
	local index = 1
	local length = string.len(message)
	local newStr = ""
	
	while (index <= length) do
		temp = string.byte(message, index) - 32
		if (temp > -1 and temp < 64) then
			newStr = newStr.." "..string.sub(encoder , math.floor(temp / 16) + 1, math.floor(temp / 16) + 1)
			temp = temp % 16
			newStr = newStr.." "..string.sub(encoder , math.floor(temp / 4) + 1, math.floor(temp / 4) + 1)
			temp = temp % 4
			newStr = newStr.." "..string.sub(encoder , temp + 1, temp + 1)
		end
		index = index + 1
	end
	
	return string.sub(newStr, 1)
end

function Translator_Decode(message, decoder)
	message = string.gsub(strtrim(message), " ", "")
	message = string.upper(message)
	local length = string.len(message)
	if (length % 3 == 0) then
		local temp
		local index = 1
		local newStr = ""
		while (index <= length) do
			temp = Translator_DecodeSub(message, decoder, index)
			if (temp < 0 or temp > 63) then
				return nil
			end
			newStr = newStr..string.sub(ASCII, temp + 1, temp + 1)
			index = index + 3
		end
		return string.lower(newStr)
	else
		return nil
	end
end

function Translator_DecodeSub(message, decoder, index)
	local a = string.find(decoder, string.sub(message, index + 0, index + 0))
	local b = string.find(decoder, string.sub(message, index + 1, index + 1))
	local c = string.find(decoder, string.sub(message, index + 2, index + 2))
	
	if (a == nil or b == nil or c == nil) then
		return -1
	else
		return ((a - 1) * 16) + ((b - 1) * 4) + (c - 1)
	end
end

function Translator_ChatMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFAA11"..msg.."|r")
end

function Translator_Init()
	local this = CreateFrame("Frame", "Translator", UIParent);
	this:SetScript("OnEvent", Translator_OnEvent);
	this:RegisterEvent("PLAYER_LOGIN");
end

function Translator_Input(msg, editBox)
	if (not msg or msg == "") then
		Translator_ChatMsg("    Cross-language communication add-on. Use at your own risk!")
		Translator_ChatMsg("    The maximum message length is 42 characters. Usage...")
		Translator_ChatMsg("        /trans (the message you want to translate)")
	else
		if (string.len(msg) < 43) then
			local encoder = LEXICON[editBox.language..editBox.language]
			if (encoder ~= nil) then
				SendChatMessage(Translator_Encode(msg, encoder), "SAY", editBox.languageID)
			else
				Translator_ChatMsg(editBox.language.." language is not supported.")
			end
		else
			Translator_ChatMsg("Message too long to encode. Type /trans for usage.")
		end
	end
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", Translator_Check);
Translator_Init()