-- Each scrollframe comes with its own parent frame.  frame is f; scrollframe is f.scrollframe
-- BE SURE TO MANUALLY CALL SETSCROLLCHILD AFTER CALLING GETFRAME(),
-- EVEN IF IT LOOKS LIKE WE'RE CALLING SETSCROLLCHILD DURING THAT VERY FUNCTION.
-- We call SetScrollChild during getFrame, but it tends to break if we make any adjustments afterwards.

-- Important: 3D modelframes, such as DressUpModel, must each have a unique SetFrameLevel in order to respect scrollframe boundaries.
		-- Apprently, modelframe.texture must also be visible (but colortexture can be 0,0,0,0)

_TRAININGGROUNDS_ReusableScrollFrames = TRAININGGROUNDS_inheritsFrom(_TRAININGGROUNDS_ReusableFrames)

TRAININGGROUNDS_ReusableScrollFrames=_TRAININGGROUNDS_ReusableScrollFrames.new()
TRAININGGROUNDS_ReusableScrollFrames.inactiveframes={}
TRAININGGROUNDS_ReusableScrollFrames.activeframes={}
TRAININGGROUNDS_ReusableScrollFrames.nextframeid=0

function _TRAININGGROUNDS_ReusableScrollFrames:NextFrameName()	
	return "TRAININGGROUNDS_ReusableScrollFrame"..tostring(self.nextframeid);
end

function _TRAININGGROUNDS_ReusableScrollFrames:ReturnCreateFrameDetails(framename)
	local f = CreateFrame("Frame",framename.."_scrollchild",UIParent)
	f.scrollframe=CreateFrame("ScrollFrame",framename.."_scrollframe",UIParent)
	-- REMEMBER, DON'T TRUST THIS LINE.  CALL SETSCROLLCHILD YOURSELF AFTER ADJUSTING FRAME APPEARANCE.
	f.scrollframe:SetScrollChild(f)
	
	return f
end

function _TRAININGGROUNDS_ReusableScrollFrames:ResetProperties(f)	
	TRAININGGROUNDS_ReusableFrames.ResetProperties(self,f)
	--f:SetScrollChild(nil)
	f.scrollframe:SetScrollChild(nil)
	f.scrollframe:SetHorizontalScroll(0)
	f.scrollframe:SetVerticalScroll(0)
	f.scrollframe:SetParent(f)
	f:SetScale(1)	
end