-- these are more or less identical to ModelFrames
-- except we reserve these for "particle" effects
-- (models which don't support customcamera)
-- because "particle" frames malfunction if we try to recycle them for customcamera models.

_TRAININGGROUNDS_ReusableParticleFrames = TRAININGGROUNDS_inheritsFrom(_TRAININGGROUNDS_ReusableFrames)

TRAININGGROUNDS_ReusableParticleFrames=_TRAININGGROUNDS_ReusableParticleFrames.new()
TRAININGGROUNDS_ReusableParticleFrames.inactiveframes={}
TRAININGGROUNDS_ReusableParticleFrames.activeframes={}
TRAININGGROUNDS_ReusableParticleFrames.nextframeid=0

function _TRAININGGROUNDS_ReusableParticleFrames:NextFrameName()	
	return "TRAININGGROUNDS_ReusableParticleFrame"..tostring(self.nextframeid);
end



function _TRAININGGROUNDS_ReusableParticleFrames:ReturnCreateFrameDetails(framename)
	--return CreateFrame("DressUpModel",framename,UIParent)
	return CreateFrame("PlayerModel",framename,UIParent)
end

function _TRAININGGROUNDS_ReusableParticleFrames:ResetProperties(f)	
--TODO: resetproperties for DressUpModel version too

	TRAININGGROUNDS_ReusableFrames.ResetProperties(self,f)
	
	f:Show()	
	f:SetModel(0)
	--for "particle" models, it is apparently vital to set ModelScale before Position
	--	(both here and during draw event)
	-- otherwise modelscale won't reset properly.
	-- (we would guess matrix multiplication is involved somehow, but Rotation order doesn't appear to make a difference)
	-- TODO: verify
	f:SetModelScale(1)
	f:SetPosition(0,0,0)	
	f:SetRotation(0)
	f:Hide()
end