-- The ReusableFrames family doesn't behave like the other classes in this game.
-- Treat these as global, static functions.


--TODO: NOTE: changing defaultparent doesn't prevent frame flash after game restart

--_TRAININGGROUNDS_ReusableFrames_DefaultParent=UIParent
_TRAININGGROUNDS_ReusableFrames_DefaultParent=nil

_TRAININGGROUNDS_ReusableFrames = {}
_TRAININGGROUNDS_ReusableFrames.__index = _TRAININGGROUNDS_ReusableFrames

function _TRAININGGROUNDS_ReusableFrames.new()
	local self=setmetatable({}, _TRAININGGROUNDS_ReusableFrames)	
	return self
end

--TODO LATER: inactiveframes/activeframes/nextframeid are apparently part of THIS instance only
-- and not part of "base" ReusableFrames (which is intended to act as a singleton).
-- is this a problem?  should we care if this is a problem?
TRAININGGROUNDS_ReusableFrames=_TRAININGGROUNDS_ReusableFrames.new()
TRAININGGROUNDS_ReusableFrames.inactiveframes={}
TRAININGGROUNDS_ReusableFrames.activeframes={}
TRAININGGROUNDS_ReusableFrames.nextframeid=0

----TODO: restore this function if it's unrelated to the particleframe issue

function _TRAININGGROUNDS_ReusableFrames:GetFrame()
	local f=tremove(self.inactiveframes)
	if not f then
		local framename=self:NextFrameName()
		f=self:CreateNewFrame(framename)
		--print("Created a new frame",f.name)
		-- if(framename=="TRAININGGROUNDS_ReusableFrame62")then
			-- error("breakpoint: frame 62")
		-- end

		-- most gameobjects expect to have a "self.frame", but they aren't required to keep track of what type of frame that is
		-- (could be normal frame, buttonframe, modelframe, scrollframe, etc)
		-- so we'll store a reference to the cleanup function in the frame itself
		f.framefamily=self
		f.Cleanup=function(self)f.framefamily:RemoveFrame(f)end
		-- we can now call f:Cleanup()
		
		
		self.nextframeid=self.nextframeid+1
	else
		--print("Recycled an existing frame",f.name)
		--
		if(f:GetParent()~=_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
			print("WARNING: frame "..tostring(f:GetName()).."'s parent is not defaultparent but "..tostring(f:GetParent():GetName()).." instead")
		end
	end
	--print("ReusableFrames getting a frame ",f.name)
	tinsert(self.activeframes,f)

	return f
end

----!!!
-- this following commented-out version attempts to force recycle frames immediately after creating them
-- in order to fix the issue with particleframe camera scale.
-- (it didn't fix it.)

-- function _TRAININGGROUNDS_ReusableFrames:GetFrame()
	
	-- local f=tremove(self.inactiveframes)
	-- if not f then
		-- local framename=self:NextFrameName()
		-- f=self:CreateNewFrame(framename)
		-- --print("Created a new frame",f.name)
		-- -- if(framename=="TRAININGGROUNDS_ReusableFrame62")then
			-- -- error("breakpoint: frame 62")
		-- -- end

		-- -- most gameobjects expect to have a "self.frame", but they aren't required to keep track of what type of frame that is
		-- -- (could be normal frame, buttonframe, modelframe, scrollframe, etc)
		-- -- so we'll store a reference to the cleanup function in the frame itself
		-- -- reminder: "self" is an instance of a framefamily, such as TRAININGGROUNDS_ReusableFrames
		-- f.framefamily=self
		-- f.Cleanup=function(self)f.framefamily:RemoveFrame(f)end
		-- -- we can now call f:Cleanup()
		
		
		-- self.nextframeid=self.nextframeid+1
		-- tinsert(self.activeframes,f)
		-- --print("!!! Cleaning up the frame we just created...")
		-- f:Cleanup()
		-- f=tremove(self.inactiveframes)
	-- end

	
	-- --print("Recycled an existing frame",f.name)
	-- --
	-- if(f:GetParent()~=_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
		-- print("WARNING: frame "..tostring(f:GetName()).."'s parent is not defaultparent but "..tostring(f:GetParent():GetName()).." instead")
	-- end

	-- --print("ReusableFrames getting a frame ",f.name)
	-- tinsert(self.activeframes,f)

	-- return f
-- end


function _TRAININGGROUNDS_ReusableFrames:NextFrameName()
	return "TRAININGGROUNDS_ReusableFrame"..tostring(self.nextframeid);
end

-------------------------PRIVATE FUNCTION-------------------------
function _TRAININGGROUNDS_ReusableFrames:CreateNewFrame(framename)
	local f=self:ReturnCreateFrameDetails(framename)
	f.id=self.nextframeid
	f.name=framename
	f.tag="(no tag)"		
	--TODO: maybe move texture to its own function too, maybe
	f.texture = f:CreateTexture()
	f.fontstring=f:CreateFontString(nil, "ARTWORK")
	self:ResetProperties(f)
	return f
end

function _TRAININGGROUNDS_ReusableFrames:ReturnCreateFrameDetails(framename)
	return CreateFrame("Frame",framename,_TRAININGGROUNDS_ReusableFrames_DefaultParent)
end

function _TRAININGGROUNDS_ReusableFrames:ResetProperties(f)
	-- override as necessary
	
	
	f.framelevel=0	
	f:SetParent(_TRAININGGROUNDS_ReusableFrames_DefaultParent)	
	f:SetFrameLevel(f.framelevel)	
	
	
	f:Hide()		
	if(f.SetCustomCamera)then f:SetCustomCamera(0) end
	
	--f:SetAlpha(1)	--original line.  caused screen flash.  TODO: remove line as soon as we're sure we fixed anything that broke
	f:SetAlpha(0) 	-- does not cause screen flash, as far as we know
	
	--f:Show()		-- note: commenting f:Hide() above and uncommenting this line causes a client crash upon game shutdown
						-- commenting f:Hide() and NOT uncommenting this line also causes a client crash upon game shutdown!
	
	----TODO LATER: vague memory that explicitly disabling mouse here causes problems; keep an eye on
	f:EnableMouse(false)
	f:EnableMouseWheel(false)
	-- Event handlers are not included here; must remove those manually.  (TODO LATER: are we unable to do that automatically?)	
	
	--TODO LATER: is it necessary to clearallpoints before setallpoints?
	f:ClearAllPoints()	
	
	--TODO: NOTE: calling setsize(1,1) doesn't prevent frame flash after game restart
	f:SetSize(1,1)
		
	-- polyframe textures don't use SetAllPoints, so we need to reset that property here
	-- TODO: *maybe* move poly frames to their own class?
	f.texture:Show()
	f.texture:ClearAllPoints()
	
	f.texture:SetAllPoints(f)
	f.texture:SetTexture(nil)
	f.texture:SetColorTexture(0,1,1,0.5)		
	--f.texture:SetTexCoord(0,1,0,1)	--TODO: why did we comment this out instead of removing it
	f.texture:SetTexCoord(0,0, 0,1, 1,0, 1,1)
	
										--  R G B A R G B A
	f.texture:SetGradientAlpha("HORIZONTAL",1,1,1,1,1,1,1,1);
	f.texture:Hide()

	
	f.fontstring:SetAllPoints(f)
	f.fontstring:Hide()
	f.fontstring:SetFont("Fonts\\FRIZQT__.TTF",14,"OUTLINE")
	f.fontstring:SetTextHeight(14)	
	if(f.animgroup~=nil) then
		f.animgroup:Stop()
		f.animgroup=nil
	end
	if(f.texture.animgroup~=nil)then
		f.texture.animgroup:Stop()
		f.texture.animgroup=nil
	end	
	f.animgroup=nil
	
	-- Frame might also be given an "owner" property by the owning drawable.
	-- Don't reset that in case we need to track it and/or debug it later.


end

function _TRAININGGROUNDS_ReusableFrames:RemoveFrame(f)
	
	self:ResetProperties(f)

	f:SetParent(_TRAININGGROUNDS_ReusableFrames_DefaultParent)	
	if(f:GetParent()~=_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
		print("WARNING: after cleanup, frame "..tostring(f:GetName()).."'s parent is not defaultparent but "..tostring(f:GetParent():GetName()).." instead")
	end
	if(f.texture:GetTexture()~="Color-0ffff80-CSimpleTexture")then
		print("WARNING: after cleanup, frame "..tostring(f:GetName()).."'s texture is not FFFF80 but "..tostring(f.texture:GetTexture()).." instead")
	end
	
	local activecount=#self.activeframes
	TRAININGGROUNDS_tremovebyval(self.activeframes,f)	
	if(#self.activeframes==activecount)then
		print("WARNING: failed to remove a frame from TRAININGGROUNDS_ReusableFrames.activeframes")
	end
	if(TRAININGGROUNDS_tcontains(self.inactiveframes,f))then		
		local errorstring="TRAININGGROUNDS_ReusableFrames.inactiveframes already contains "..tostring(f).." "..f.name.." "..f.tag
		print("WARNING: "..errorstring)
		--error(errorstring)
	else
		tinsert(self.inactiveframes,f)
	end	
end

function _TRAININGGROUNDS_ReusableFrames:ResetAllActiveFrames()
	local looping=true
	if(#self.activeframes>0)then
		TRAININGGROUNDS_debugprint("WARNING: after cleanup on reusable frames, "..#self.activeframes.." frames remaining")
	end				
	while looping do
		looping=false
		local f
		f=nil		
		if(#self.activeframes>0) then			
			f=self.activeframes[1]
		end
		if not f then
			-- do nothing
		else
			--self.RemoveFrame(f)
			self:RemoveFrame(f)
			if(f:GetParent()~=_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
				--TRAININGGROUNDS_debugprint("WARNING: during force cleanup, frame "..tostring(f:GetName()).."'s parent is not defaultparent but "..tostring(f:GetParent():GetName()).." instead")
			end
			--print("Force cleanup on ReusableFrames: "..f:GetName().." cleaned up, "..#self.activeframes.." frames remaining")

			looping=true
		end
	end
	-- --DO NOT SET NEXTFRAMEID TO ZERO DURING A STANDARD RESET.
	-- --NEXTFRAMEID IS USED TO SET THE INDEX OF A NEWLY-CREATED FRAME IN THE FRAME LIST.
	-- --IF NEXTFRAMEID IS SET TO ZERO, THE EXISTING RECYCLED FRAMES WILL BE OVERWRITTEN BY THE NEWLY-CREATED FRAMES
	-- --self.nextframeid=0   <-- DON'T DO THIS.
	-- --There's no way to force the frame names to appear in the same order every time the program is run
		-- --...not without sorting the entire inactive frame table by name after a reset.
	-- --Inactive frames are placed in their table in order they're cleaned up.
end

function _TRAININGGROUNDS_ReusableFrames.ResetAndReport()
	local oktotal=#TRAININGGROUNDS_ReusableFrames.inactiveframes
				+#TRAININGGROUNDS_ReusableModelFrames.inactiveframes
				+#TRAININGGROUNDS_ReusableParticleFrames.inactiveframes
				+#TRAININGGROUNDS_ReusableButtonFrames.inactiveframes				
				+#TRAININGGROUNDS_ReusableScrollFrames.inactiveframes
	local leftovertotal=#TRAININGGROUNDS_ReusableFrames.activeframes
				+#TRAININGGROUNDS_ReusableModelFrames.activeframes
				+#TRAININGGROUNDS_ReusableParticleFrames.activeframes
				+#TRAININGGROUNDS_ReusableButtonFrames.activeframes
				+#TRAININGGROUNDS_ReusableScrollFrames.activeframes
	--TRAININGGROUNDS_debugprint("Properly cleaned up "..tostring(oktotal).." frames.  Running force cleanup on "..tostring(leftovertotal).." frames.")
	if(leftovertotal==0)then
		--print("TrainingGrounds: successfully cleaned up all active frames.")
	else
		-- don't show warning if we think game crashed (if game crashes, leftover frames are to be expected)
		if(TRAININGGROUNDS and not TRAININGGROUNDS.alreadyattemptederrorshutdown)then
			print("WARNING: "..leftovertotal.." out of "..tostring(oktotal+leftovertotal).." frames remaining after cleanup.")
			print("Please /reload before running TrainingGrounds again.")
		end
	end
	
	TRAININGGROUNDS_ReusableFrames:ResetAllActiveFrames()
	TRAININGGROUNDS_ReusableModelFrames:ResetAllActiveFrames()
	TRAININGGROUNDS_ReusableParticleFrames:ResetAllActiveFrames()
	TRAININGGROUNDS_ReusableButtonFrames:ResetAllActiveFrames()
	TRAININGGROUNDS_ReusableScrollFrames:ResetAllActiveFrames()
	TRAININGGROUNDS_ReusableLeftalignedTextFrames:ResetAllActiveFrames()
	
end

function _TRAININGGROUNDS_ReusableFrames:Report()
	TRAININGGROUNDS_debugprint("Checking ReusableFrames only...")
	TRAININGGROUNDS_debugprint(tonumber(#self.activeframes).." active frames")
	TRAININGGROUNDS_debugprint(tonumber(#self.inactiveframes).." inactive frames")
	for i=1,#self.inactiveframes,1 do
		local f=self.inactiveframes[i]
		if(f:GetParent()~=_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
			TRAININGGROUNDS_debugprint("Frame "..tostring(f:GetName()).."'s parent is not defaultparent but "..tostring(f:GetParent():GetName()).." instead")
		end
		TRAININGGROUNDS_debugprint("Frame "..tostring(f:GetName()).."'s parent is "..tostring(f:GetParent():GetName()))
	end
end

function _TRAININGGROUNDS_ReusableFrames:ForceReset()
	self.inactiveframes={}
	self.activeframes={}
	self.nextframeid=0
end

-- TODO: prohibit using this unless debug option is enabled
function _TRAININGGROUNDS_ReusableFrames:ForceFullReset()
	TRAININGGROUNDS_ReusableFrames:ForceReset()
	TRAININGGROUNDS_ReusableModelFrames:ForceReset()
	TRAININGGROUNDS_ReusableParticleFrames:ForceReset()
	TRAININGGROUNDS_ReusableButtonFrames:ForceReset()
	TRAININGGROUNDS_ReusableScrollFrames:ForceReset()
	TRAININGGROUNDS_ReusableLeftalignedTextFrames:ForceReset()
end

--/run TRAININGGROUNDS_ReusableFrames:Audit()
--/run print(TRAININGGROUNDS_ReusableFrame0.texture:GetTexture())
--/run print(TRAININGGROUNDS_ReusableFrame0.owner.owner.visible)
--/run print(TRAININGGROUNDS_ReusableFrame0:IsShown())
function _TRAININGGROUNDS_ReusableFrames:Audit()
	local uiparentcounter=0
	for i=1,#self.activeframes do
		local f=self.activeframes[i]	
		if(f:GetParent()==_TRAININGGROUNDS_ReusableFrames_DefaultParent)then
			uiparentcounter=uiparentcounter+1
			--print("Frame "..tostring(f:GetName()).."'s parent is defaultparent")
		end
	end	
	print(#TRAININGGROUNDS_ReusableFrames.activeframes,"active frames,",#TRAININGGROUNDS_ReusableFrames.inactiveframes,"inactive frames")
	--print(uiparentcounter,"active frames with parent UIParent")
	print(uiparentcounter,"active frames with defaultparent")
	print("Nextframeid",self.nextframeid)
	
end