TRAININGGROUNDS_DraggableGameWindow = {}
TRAININGGROUNDS_DraggableGameWindow.__index = TRAININGGROUNDS_DraggableGameWindow

function TRAININGGROUNDS_DraggableGameWindow.new()
	local self=setmetatable({}, TRAININGGROUNDS_DraggableGameWindow)	
		
	return self
end

--TODO: resizable

--TODO: rename function parameters for wIDE...
function TRAININGGROUNDS_DraggableGameWindow:Setup(game,traininggrounds,width,height,titletext,titleheight,closebutton,onclose)		

	--TODO: figure out how we want to handle window framelevels

	if(not titleheight)then titleheight=20 end

	self.game=game	
	self.traininggrounds=traininggrounds
	self.environments={}
			
	self.background=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.background.parent=UIParent
	self.background:SetParent(self.background.parent)
	self.background:SetWidth(width)
	self.background:SetHeight(height+(titleheight+2))
	self.background:SetPoint("CENTER",self.background.parent,"CENTER",0,(titleheight/2))
	self.background.texture:SetColorTexture(0,0,0,0.5)
	self.background:Show()
	self.background.texture:Show()		
	self.background:SetAlpha(1)
	
			
--/run _TRAININGGROUNDS.game.window.background:Hide()
--/run SetupFullscreenScale(_TRAININGGROUNDS.game.window.background)
	self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.frame.parent=self.background; self.frame:SetParent(self.frame.parent)
	self.frame:SetPoint("BOTTOM",self.frame.parent,"BOTTOM",0,0)
	self.frame:SetWidth(width);self.frame:SetHeight(height)
	self.frame:Show()	
	self.frame:SetAlpha(1)
	
	self.frame:EnableMouse(true)
	--TODO: EnableMouseWheel not locking mouse wheel controls -- do we need to set an event before it locks?
	--TODO: state in future comments whether setting an event is necessary
	self.frame:EnableMouseWheel(true)	
	-- SetScript calls functions from the perspective of the frame, not the DraggableGameWindow itself
	-- so we must remind frame who it's supposed to be
	self.frame.parentwindow=self
	self.frame:SetScript("OnMouseDown", self.OnMouseDown)
	self.frame:SetScript("OnMouseUp", self.OnMouseUp)		
	self.frame:SetScript("OnMouseWheel", self.OnMouseWheel)
	
	self.frame:SetScript("OnKeyDown", self.OnKeyDown)
	self.frame:SetScript("OnKeyUp", self.OnKeyUp)		
	
	
		
	
	
	
	self.bordergraphic=TRAININGGROUNDS_BorderGraphicWithTitle.new()
	self.bordergraphic:Setup(self.background,titletext,titleheight)	
	

	
	----Background texture is now handled by BorderGraphicWithTitle
	--TODO: rename BorderGraphicWithTitle to bordergraphicWithTitle
	--self.frame.texture:SetColorTexture(0,0,0,0.5)
	--self.frame.texture:Show()
	
	--TRAININGGROUNDS_FrameVisibilityCheck(self.frame)
	
	--TitleRegion removed in 7.1!
	--use RegisterForDrag instead
	--self.titleregion=self.frame:CreateTitleRegion()	
	--self.titleregion:SetPoint("TOPLEFT",self.frame,"TOPLEFT",0,0)		-- remember, this is the draggable title bar we're setting,
	--self.titleregion:SetPoint("TOPRIGHT",self.frame,"TOPRIGHT",0,0)	-- so use TOPLEFT/TOPRIGHT instead of BOTTOMLEFT/BOTTOMRIGHT
	--self.titleregion:SetHeight(titleheight)

	--SOURCE: wowinterface.com/forums/showthread.php?t=54577
	self.titleregion=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.titleregion.parent=self.background; self.titleregion:SetParent(self.titleregion.parent)
	self.titleregion:SetPoint("TOPLEFT",self.titleregion.parent,"TOPLEFT")
	self.titleregion:SetPoint("TOPRIGHT",self.titleregion.parent,"TOPRIGHT")
	self.titleregion:SetWidth(width)
	self.titleregion:SetHeight(titleheight)	
	self.titleregion:Show()
	self.titleregion:RegisterForDrag("LeftButton")	
	self.titleregion:SetAlpha(1)
	self.background:SetMovable(true)
	-- previously "StartMovingOrSizing" and "StopMoving"
	self.titleregion:SetScript("OnDragStart", function()
		self.background:StartMoving()
	end)
	self.titleregion:SetScript("OnDragStop", function()
		self.background:StopMovingOrSizing()
	end)	
	--mouse must be enabled to drag window
	self.titleregion:EnableMouse(true)
	

	
	if(closebutton)then
		self.closebutton=TRAININGGROUNDS_ReusableButtonFrames:GetFrame()
		self.closebutton:SetParent(self.titleregion)
		self.closebutton:SetWidth(16)
		self.closebutton:SetHeight(16)
		self.closebutton:SetPoint("TOPRIGHT",-3,-2)
		--self.closebutton:SetFrameLevel(255)
		self.closebutton.texture=self.closebutton:CreateTexture()
		self.closebutton.texture:SetAllPoints(self.closebutton)		
		self.closebutton.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\closebutton.tga")			
		self.closebutton:SetHighlightTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\square.tga")	
		
		self.closebutton.texture:Show()		
		self.closebutton:Show()	
		self.closebutton:SetAlpha(1)		
		
		self.closebutton:SetScript("OnClick",function(self,button,down)
				onclose()
			end)
	end
	

end

-- reminder: these events are called from the perspective of self.frame
function TRAININGGROUNDS_DraggableGameWindow:OnMouseDown(button)
	self.parentwindow.game:OnMouseChange(self,button,true)			
end

function TRAININGGROUNDS_DraggableGameWindow:OnMouseUp(button)
	self.parentwindow.game:OnMouseChange(self,button,false)		
end

function TRAININGGROUNDS_DraggableGameWindow:OnMouseWheel(delta)
	self.parentwindow.game:OnMouseWheel(self,delta)
end
function TRAININGGROUNDS_DraggableGameWindow:OnKeyDown(keycode,binding)
	if(keycode=="ENTER" or keycode=="/" or keycode==TRAININGGROUNDS_DEBUG.extrapassthrukeycode) then
		-- ENTER and / keys pass through so the player can still access chat
		self:SetPropagateKeyboardInput(true)
	else
		-- (we still can't believe this works.  would not be surprised if it breaks in a future patch)
		self:SetPropagateKeyboardInput(false)
	end
	
	if(keycode=="ESCAPE") then
		if(TRAININGGROUNDS_DEBUG.instantquit==true) then
			if(_TRAININGGROUNDS)then
				print("TRAININGGROUNDS_DEBUG.instantquit")
				_TRAININGGROUNDS:Shutdown()
			end
			return
		end
		-- if(TRAININGGROUNDS_DEBUG.instantshiftquit==true)then
			-- if(TRAININGGROUNDS.game.keys.shift.current==true)then
				-- TRAININGGROUNDS:Shutdown()
				-- return
			-- end
		-- end
		-- if(TRAININGGROUNDS.forceshutdowntimer==nil)then
			-- TRAININGGROUNDS.forceshutdowntimer=TRAININGGROUNDS.FORCESHUTDOWNDURATION --TODO: const
		-- end
	end

	self.parentwindow.game:OnKeyChange(self,keycode,binding,true)
end
function TRAININGGROUNDS_DraggableGameWindow:OnKeyUp(keycode,binding)
	self.parentwindow.game:OnKeyChange(self,keycode,binding,false)
end


function TRAININGGROUNDS_DraggableGameWindow:Cleanup(game,traininggrounds)	
	self.environments={}
	self.frame.parentwindow=nil
	self.frame:SetScript("OnMouseDown", nil)
	self.frame:SetScript("OnMouseUp", nil)		
	self.frame:SetScript("OnMouseWheel", nil)
	self.frame:SetScript("OnKeyDown", nil)
	self.frame:SetScript("OnKeyUp", nil)
	self.frame:Cleanup()
	self.titleregion:Cleanup()
	-- we did some extra things with titleregion that ReusableFrames isn't expecting; clean that up here
	self.titleregion:SetScript("OnDragStart", nil);self.titleregion:SetScript("OnDragStop", nil)	
	self.titleregion:RegisterForDrag();
	self.frame:SetMovable(false)
	self.bordergraphic:Cleanup()
	self.background:Cleanup()
	if(self.closebutton)then
		self.closebutton:Cleanup()
	end
	self.game=nil
	self.traininggrounds=nil
end

	
