--
-- TrainingGrounds is still undergoing construction.
-- Please don't redistribute this addon until official release.
--

--TODO: math.randomseed





--TODO LATER: modelframes still occasionally size incorrectly on startup
-- 		it's possible that this is unavoidable and will solve itself after intro sequence is implemented


--TODO LATER: print debugstack on certain OOP problems such as (but not limited to) inheritance errors

TRAININGGROUNDS_Scrollframes_Broken=false


-- the main TRAININGGROUNDS object
local TRAININGGROUNDS={}
TRAININGGROUNDS.LOADED=false

if(TRAININGGROUNDS_DEBUG.global)then
	_TRAININGGROUNDS=TRAININGGROUNDS
end

-- note that xpcall doesn't accept function arguments,
-- so fn() should be an anonymous function with its arguments baked in
-- At the moment, this is only used for game:MainGameLoop 
-- to prevent bad things from happening if an error occurs every frame.
--TODO LATER: maybe use for more than maingameloop
--TODO: not used for SpellButtons -- maybe should be
		-- (though spellbuttons are not likely to crash via error-every-frame)
		-- (maybe just tidy up the prevent-crash-shutdown error message instead?)
function TRAININGGROUNDS_xpcall(fn)
	xpcall(fn,function(msg)TRAININGGROUNDS_ErrorHandler(msg)end)
end

-- SOURCE: codea.io/talk/discussion/2118/split-a-string-by-return-newline
function split_lines(str)
  local t = {}
  local function helper(line) table.insert(t, line) return "" end
  helper((string.gsub(str,"(.-)\r?\n", helper)))
  return t
end

function TRAININGGROUNDS_ErrorHandler(msg)	
	print(msg)
	-- local ds=debugstack()
	-- local split_debugstack=split_lines(ds)
	-- for i,v in ipairs(split_debugstack) do
		-- print(v)	
	-- end
	TRAININGGROUNDS_StackTrace()
	print("|cFFFF0000A Lua error was detected.  Shutting down TrainingGrounds to avoid a potential client crash.")
	
	-- it turns out this function still counts as within xpcall, so any further errors will cause a recursive loop	
	if(TRAININGGROUNDS and not TRAININGGROUNDS.alreadyattemptederrorshutdown)then
		TRAININGGROUNDS.alreadyattemptederrorshutdown=true
		TRAININGGROUNDS:Shutdown()
	end	
	-- we also attempt to display the error in the default lua error window.
	-- we need to break out of xpcall to do so
	-- (note that the stacktrace won't be useful as we're using error())
	C_Timer.After(0.5,function()error(msg)end)
	--TODO: open dialog box somewhere with copyable text, using existing library even
end


-- the event handler
TRAININGGROUNDS.EventHandlerFrame = CreateFrame("Frame")
-- local variables are not visible from event handlers unless we store it on the frame...
TRAININGGROUNDS.EventHandlerFrame.TRAININGGROUNDS=TRAININGGROUNDS

function TRAININGGROUNDS.EventHandlerFrame:OnEvent(event, ...)
	if(event=="ADDON_LOADED") then
		TRAININGGROUNDS.EventHandlerFrame:OnLoad(...)
	end
end


function TRAININGGROUNDS.EventHandlerFrame:OnLoad(AddOn)		
	-- run init code only once
	if(AddOn=="TrainingGrounds" and self.TRAININGGROUNDS.LOADED==false) then				
		self.TRAININGGROUNDS.LOADED=true
		self:UnregisterEvent("ADDON_LOADED")		
		-- savedata has been loaded by now, if it exists.
		-- if it's still nil, then there was no data to load.
		if(TRAININGGROUNDS_SAVEDATA==nil) then TRAININGGROUNDS_SAVEDATA={} end				
			
		print("TrainingGrounds is enabled.  Type /tg to play.")
	end 
end

TRAININGGROUNDS.EventHandlerFrame:RegisterEvent("ADDON_LOADED")
TRAININGGROUNDS.EventHandlerFrame:SetScript("OnEvent", TRAININGGROUNDS.EventHandlerFrame.OnEvent)

TRAININGGROUNDS.EventHandlerFrame.OnUpdate=function(self,elapsed)
	if(TRAININGGROUNDS.game)then
		--TODO: if esc is held, draw forceshutdowntimer in UI environment
		if(TRAININGGROUNDS.forceshutdowntimer~=nil) then	
			TRAININGGROUNDS.forceshutdowntimer=TRAININGGROUNDS.forceshutdowntimer-elapsed*1000
			if(TRAININGGROUNDS.forceshutdowntimer<=0)then
				TRAININGGROUNDS:Shutdown()
				return
			end
		end

		if(TRAININGGROUNDS.dead==true)then
			TRAININGGROUNDS:Shutdown()
			return
		end
		
		--TRAININGGROUNDS.game:MainGameLoop(elapsed)	-- old line -- probably not going to use this ever
		--print("call ",TRAININGGROUNDS.game.MainGameLoop,TRAININGGROUNDS.game,elapsed)		
		TRAININGGROUNDS_xpcall(function()TRAININGGROUNDS.game.MainGameLoop(TRAININGGROUNDS.game,elapsed)end)

	end
end


SLASH_TRAININGGROUNDS1 = "/tg"
SLASH_TRAININGGROUNDS_DEBUG1="/tgx"

function SlashCmdList.TRAININGGROUNDS(msg,editbox)
	if(TRAININGGROUNDS.LOADED==false)then return end

	local args={}
	local i=0
	for arg in string.gmatch(msg, "%S+") do	
		args[i]=arg
		i=i+1
		--print(arg)
	end	
	
	if(#args==0 and args[0]==nil)then
		if(TRAININGGROUNDS.game==nil)then
			print("Starting up TrainingGrounds...")
			TRAININGGROUNDS.alreadyattemptederrorshutdown=false
			TRAININGGROUNDS:StartGame()
		else
			if(TRAININGGROUNDS_DEBUG.autoshutdownrestart)then
				print("Restarting TrainingGrounds...")
				TRAININGGROUNDS:Shutdown()
				TRAININGGROUNDS.alreadyattemptederrorshutdown=false
				TRAININGGROUNDS:StartGame()				
			else
				print("TrainingGrounds appears to be running already.  If something broke, type /tg shutdown.")
			end
		end
	end
	
	if(args[0]=="shutdown")then
		TRAININGGROUNDS:Shutdown()
	end
	
	if(TRAININGGROUNDS_DEBUG.extraslashcommands)then
		if(args[0]=="reset") then		
			if(args[1]~="confirm") then
				print("To delete all TrainingGrounds saved data, type /tg reset confirm")
			else			
				TRAININGGROUNDS:Shutdown()			
				TRAININGGROUNDS_SAVEDATA={}
				print("TrainingGrounds data has been reset.")			
			end
		end 
	end
end

function SlashCmdList.TRAININGGROUNDS_DEBUG(msg,editbox)
	if(TRAININGGROUNDS.game~=nil)then
		TRAININGGROUNDS:Shutdown()
	end
	TRAININGGROUNDS_ReusableFrames:ForceFullReset()
	TRAININGGROUNDS.alreadyattemptederrorshutdown=false
	TRAININGGROUNDS:StartGame()				
end

function TRAININGGROUNDS:StartGame()	
	--if(TRAININGGROUNDS_DEBUG.donthookerrorhandler~=true)then
		--seterrorhandler(TRAININGGROUNDS_ErrorHandler)	
	--end	
	self.game=TRAININGGROUNDS_Game.new()
	self.game:Setup(self)
	TRAININGGROUNDS.EventHandlerFrame:SetScript("OnUpdate", TRAININGGROUNDS.EventHandlerFrame.OnUpdate)
end


function TRAININGGROUNDS:Shutdown()
	TRAININGGROUNDS.EventHandlerFrame:SetScript("OnUpdate", nil)
	self:Cleanup()
end

function TRAININGGROUNDS:Cleanup()
	if(self.game)then
		self.game:Cleanup()	
		self.game=nil
	end
	
	--!!!
	--TODO: cancelcountdown properly
	TRAININGGROUNDS_FakeDBM_CancelCountdown(DBM)
	
	
	TRAININGGROUNDS_ReusableFrames:ResetAndReport()
	print("TrainingGrounds was shut down.  Type /tg to restart.")
end

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

--SOURCE: lua-users.org/wiki/InheritanceTutorial
function TRAININGGROUNDS_inheritsFrom(baseClass)
	local new_class={}
	local class_mt={__index=new_class}
	function new_class:new()
		local newinst={}
		setmetatable(newinst,class_mt)
		return newinst
	end
	if baseClass~=nil then
		setmetatable(new_class,{__index=baseClass})		
	else
		--print("WARNING: TRAININGGROUNDS_inheritsFrom was given nil as its base class.  (we can't tell which class should be the parent from here)")
		TRAININGGROUNDS_StackTrace()
		error("Assertion failed: inheritsFrom base class must not be nil")		
	end
    function new_class:Class()
        return new_class
    end
	-- WARNING: do not use superClass to access parent functions.
	-- 		doing so will result in 1 of 2 problems:
	-- 		"self" will change to refer to the superclass metatable instead of the child instance,
	--		or "self" will still refer to the child instance and cause an infinite loop if you call superClass again from the parent function (because superclass is still the child instance's superclass and not the parent class's superclass).
	-- to access parent functions, call the parent function directly:
	-- PARENTCLASSNAME.function(self, args)
	-- do not use colon operator -- doing so will cause self to change from child instance to parent class table!
    function new_class:SuperClass()		
        return baseClass
    end
    function new_class:Isa( theClass )
        local b_isa = false
        local cur_class = new_class
        while ( nil ~= cur_class ) and ( false == b_isa ) do
            if cur_class == theClass then
                b_isa = true
            else
				if(cur_class.superClass~=nil)then
					cur_class = cur_class:SuperClass()
				else
					cur_class=nil
				end
            end
        end
        return b_isa
    end	
	
	return new_class
end

function TRAININGGROUNDS_debugprint(str)
	if(TRAININGGROUNDS_DEBUG.debugprint)then
		print(str)
	end
end


--TODO: move some of this to utils.tables and utils.math

-- SOURCE: wowwiki.wikia.com/wiki/USERAPI_tinsertbeforeval
function TRAININGGROUNDS_tremovebyval(tab, val)
   for k,v in pairs(tab) do
     if(v==val) then
       table.remove(tab, k)
       return true
     end
   end
   return false
end
 
function TRAININGGROUNDS_tcontains(tab,val)
    for k,v in pairs(tab) do
     if(v==val) then
       return true
     end
   end
   return false
end

function TRAININGGROUNDS_signum(x)
	if x<0 then
		return -1
	elseif x>0 then
		return 1
	else
		return 0
	end
end

--SOURCE: stackoverflow.com/questions/1073336/circle-line-segment-collision-detection-algorithm#
function TRAININGGROUNDS_LineCircleCollision(x1,y1,x2,y2,cx,cy,r)

	local dot=function(v1,v2)		
			return v1[1]*v2[1]+v1[2]*v2[2]
		end
	local d={(x2-x1),(y2-y1)}
	local f={(x1-cx),(y1-cy)}
	
	
	local a=dot(d,d)
	local b=2*dot(f,d)
	local c=dot(f,f)-r*r
	
	local discriminant=b*b-4*a*c
	if(discriminant<0)then
		return false
	else
		discriminant=math.sqrt(discriminant)
		local t1=(-b - discriminant)/(2*a)
		local t2=(-b + discriminant)/(2*a)
		if(t1>=0 and t1<=1) then
			return true
		end
		if(t2>=0 and t2<=1) then
			return true
		end
		return false
	end
	
end


--old version
-- function TRAININGGROUNDS_FrameVisibilityCheck(frame)
	-- TRAININGGROUNDS_debug_print("Checking frame "..tostring(frame))
	-- TRAININGGROUNDS_debug_print("Parent: "..tostring(frame:GetParent()))
	-- TRAININGGROUNDS_debug_print("Width: "..frame:GetWidth())
	-- TRAININGGROUNDS_debug_print("Height: "..frame:GetHeight())	
	-- TRAININGGROUNDS_debug_print("Framelevel: "..frame:GetFrameLevel())	
-- end


function TRAININGGROUNDS_FrameVisibilityCheck(frame)
	if(not TRAININGGROUNDS)then local TRAININGGROUNDS=self.TRAININGGROUNDS end
	print("Checking frame",tostring(frame))
	print("Name:",tostring(frame.name))
	print("Parent:",tostring(frame:GetParent()))
	print("Width:",frame:GetWidth())
	print("Height:",frame:GetHeight())	
	print("Framelevel:",frame:GetFrameLevel())	
	print("Shown:",frame:IsShown())
	print("Alpha:",frame:GetAlpha())	-- Does not actually grant alpha access.  I've tried.
end

-- SOURCE: stackoverflow.com/questions/1283388/lua-merge-tables
function TRAININGGROUNDS_MergeTables(first_table,second_table)
	for k,v in pairs(second_table) do first_table[k] = v end
end


-- SOURCE: stackoverflow.com/questions/20066835/lua-remove-duplicate-elements
function TRAININGGROUNDS_RemoveDuplicates(inputtable)
	local hash = {}
	local result = {}

	for _,v in ipairs(inputtable) do
	   if (not hash[v]) then
		   result[#result+1] = v
		   hash[v] = true
	   end
	end
	return result
end


--TODO: move the triangle test somewhere else
	-- local frame=CreateFrame("Frame")
	-- frame:SetParent(UIParent)
	-- frame:SetAllPoints(UIParent)
	-- frame:Show()	
	-- frame.texture=frame:CreateTexture()
	-- --frame.texture:SetAllPoints(frame)
	-- --frame.texture:SetTexture("Interface\\AddOns\\ScreenTest\\line.tga")
	-- --frame.texture:Show()
	-- --local sx,sy,ex,ey,w,relPoint=0,0,100,100,2,"BOTTOMLEFT"	
	-- --DrawRouteLine(frame.texture, frame, sx, sy, ex, ey, w, relPoint)
	-- --local Layer,R,G,B,Ax,Ay,Bx,By,Cx,Cy=100,1,1,1,   0,0.5, 1,1, 0.5,0
	-- local Layer,R,G,B,Ax,Ay,Bx,By,Cx,Cy=100,1,1,1,   0,0.5, 2,1, 0.5,0
	-- --local Layer,R,G,B,Ax,Ay,Bx,By,Cx,Cy=100,1,1,1,   0,0.5, 0.5,0, 1,1
	-- TAXIFRAME_TextureAdd( frame, Layer, R, G, B, Ax, Ay, Bx, By, Cx, Cy )
	-- print("triangle test...")
	
function TRAININGGROUNDS_StackTrace()
	local ds=debugstack()
	local split_debugstack=split_lines(ds)
	for i,v in ipairs(split_debugstack) do
		print(v)	
	end
end