TRAININGGROUNDS_Raid = {}
TRAININGGROUNDS_Raid.__index = TRAININGGROUNDS_Raid

function TRAININGGROUNDS_Raid.new()
	local self=setmetatable({}, TRAININGGROUNDS_Raid)
	return self
end

function TRAININGGROUNDS_Raid:Setup()
	self.players={}	
	self.allranged={}
	self.allmelee={}
	self.tanks={}
	self.healers={}	
	self.mdps={}
	self.rdps={}
	
	
end

function TRAININGGROUNDS_Raid:Populate(environment)
	--self:CreatePlayers(environment,2,5,7,6)
	local player=self:CreatePlayers(environment,1,5,7,7)
	--local player=self:CreatePlayers(environment,0,0,0,1)
	self:MakeAllPlayersIrrelevant()
	
		
	return player
end



function TRAININGGROUNDS_Raid:CreatePlayers(environment,num_tanks,num_healers,num_mdps,num_rdps)
	--Returns the LAST player to be created.
		--TODO: return the first player instead?

	local obj
	local y=1
	for i=1,num_tanks do
		obj=TRAININGGROUNDS_PlayerCharacter.new()
		obj:Setup(environment)
		if(not TRAININGGROUNDS_DEBUG.nonrandomraiderappearance)then obj:SetRandomAppearance() end
		obj.combat=TRAININGGROUNDS_CombatModule_SampleClass_MTank.new()
		obj.combat:Setup(obj)
		
		local half=math.floor(num_tanks/2)
		if(i<=half)then
			obj.x=(i-1)*100
		else
			obj.x=-(i-half)*100
		end
		obj.y=y*-100
		tinsert(self.players,obj)
		tinsert(self.tanks,obj)
	end
	y=y+1
	for i=1,num_mdps do
		obj=TRAININGGROUNDS_PlayerCharacter.new()
		obj:Setup(environment)
		if(not TRAININGGROUNDS_DEBUG.nonrandomraiderappearance)then obj:SetRandomAppearance() end
		obj.combat=TRAININGGROUNDS_CombatModule_SampleClass_MDPS.new()
		obj.combat:Setup(obj)
		--print("Obj's combatmodule is now",obj.combat)
		local half=math.floor(num_mdps/2)
		if(i<=half)then
			obj.x=(i-1)*100
		else
			obj.x=-(i-half)*100
		end
		obj.y=y*-100
		tinsert(self.players,obj)
		tinsert(self.mdps,obj)
	end		
	y=y+1
	for i=1,num_healers do
		obj=TRAININGGROUNDS_PlayerCharacter.new()
		obj:Setup(environment)
		if(not TRAININGGROUNDS_DEBUG.nonrandomraiderappearance)then obj:SetRandomAppearance() end
		obj.combat=TRAININGGROUNDS_CombatModule_SampleClass_RHealer.new()
		obj.combat:Setup(obj)
		local half=math.floor(num_healers/2)
		if(i<=half)then
			obj.x=(i-1)*100
		else
			obj.x=-(i-half)*100
		end
		obj.y=y*-100
		tinsert(self.players,obj)
		tinsert(self.healers,obj)
	end	
	y=y+1
	for i=1,num_rdps do
		obj=TRAININGGROUNDS_PlayerCharacter.new()
		obj:Setup(environment)
				
		if(i~=1)then --TODO: better player character detection
			if(not TRAININGGROUNDS_DEBUG.nonrandomraiderappearance)then obj:SetRandomAppearance() end
		end
		obj.combat=TRAININGGROUNDS_CombatModule_SampleClass_RDPS.new()
		obj.combat:Setup(obj)
		--print("RDPS combat:",obj.combat)
		--print("RDPS combat roll:",obj.combat.roll)
		local half=math.floor(num_rdps/2)
		if(i<=half)then
			obj.x=(i-1)*100
		else
			obj.x=-(i-half)*100
		end
		obj.y=y*-100
		tinsert(self.players,obj)
		tinsert(self.rdps,obj)
	end		
	
	self:SortRaidRolesIntoList()
	
	return obj
end

function TRAININGGROUNDS_Raid:MakeAllPlayersIrrelevant()
	for i=1,#self.players do
		local player=self.players[i]
		local irrelevant=TRAININGGROUNDS_Aura_Irrelevant.new()
		--TODO: player.combat's localtime
		irrelevant:Setup(player.combat,player.combat,player:GetLocalTime())
	end
end

function TRAININGGROUNDS_Raid:SortRaidRolesIntoList()
	--TODO:
end

function TRAININGGROUNDS_Raid:GetAllRangedTargets()
	--TODO:
	return self:GetAllTargets()
end

function TRAININGGROUNDS_Raid:GetAllTargets()
	return TRAININGGROUNDS_table_clone(self.players)
end

--SOURCE: lua-users.org/wiki/CopyTable
--TODO: move to Utils
function TRAININGGROUNDS_table_clone(org)
  return {unpack(org)}
end
