-- A "gamepad" style key intended for arcade gameplay.
-- For spells, use Game\Spells\SpellButton instead.

TRAININGGROUNDS_Key = {}
TRAININGGROUNDS_Key.__index = TRAININGGROUNDS_Key

function TRAININGGROUNDS_Key:new()
	local self={}
	setmetatable(self, TRAININGGROUNDS_Key)	
	
	self.map=nil	-- used by rawinput to point to another key
	
	self.current=false		-- whether key is currently down
	self.pressed=false		-- true when OnKeyDown
	self.released=false		-- true when OnKeyUp
		-- (WoW is nice enough not to trigger repeat events when the key is held down)

	
	return self
end

function TRAININGGROUNDS_Key:Setup(keys,keycode)
	tinsert(keys.keys,self)
	keys.keycodes[keycode]=self
	
	return self
end

function TRAININGGROUNDS_Key:SetKey(state)
	self.current=state
	if(state==true)then
		self.pressed=true
	else
		self.released=true
	end	
	
	if(self.map)then		
		self.map:SetKey(state)
	end
end

--special case for wmouse
function TRAININGGROUNDS_Key:SetMouseWheel(delta)
	self.pressed=delta
	if(self.map)then
		self.map:SetMouseWheel(delta)
	end
end