do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_VoidZone = TRAININGGROUNDS_inheritsFrom(super)
	
	function TRAININGGROUNDS_VoidZone:Setup(environment,castercombat)
		super.Setup(self,environment,castercombat)
		self.castercombat=castercombat
		self.affectedmobile_auras={}
		self.spawntime=environment.localtime
	end
	
	function TRAININGGROUNDS_VoidZone:SetCustomInfo()
		super.SetCustomInfo(self)
		--TODO: TRAININGGROUNDS_Auras_VoidZoneDefaultAura
		self.aura=nil
		self.graceperiod=0
	end
		
	function TRAININGGROUNDS_VoidZone:SetupEnvironmentObjectListIndexStorage(environment)
		super.SetupEnvironmentObjectListIndexStorage(self,environment)
		tinsert(self.environmentobjectlists,self.environment.voidzones)
	end
	

	function TRAININGGROUNDS_VoidZone:CollisionCheck(mobile)
		--TODO: default voidzone
		--override
		return false
	end
	

	--TODO: maybe rename this to InsideVoidZoneStep,
		-- or maybe not, since we'll eventually check only when mobile or voidzone changes position
	function TRAININGGROUNDS_VoidZone:OnEnterVoidZone(mobile)
		--override
		if(self.aura)then
			-- if aura exists, but is dead, remove it from list
			if(self.affectedmobile_auras[mobile.id] and self.affectedmobile_auras[mobile.id].dead)then
				self.affectedmobile_auras[mobile.id]=nil
			end
			--TODO: self.affectdmobile_auras hasn't been tested to make sure it actually works as expected
			if(not self.affectedmobile_auras[mobile.id])then
				local aurainstance=mobile.combat:ApplyAuraByClass(self.aura,self.castercombat)				
				self.affectedmobile_auras[mobile.id]=aurainstance
			else
				self.affectedmobile_auras[mobile.id].inrangeofvoidzone=true
			end
		end
	end
	
	--TODO: decide whether this should be "leave" or "exit"
	function TRAININGGROUNDS_VoidZone:OnLeaveVoidZone(mobile)	
		--override
		
		--TODO: maybe check for dead aura here too
		if(self.affectedmobile_auras[mobile.id])then
			self.affectedmobile_auras[mobile.id].inrangeofvoidzone=false
		end
		--self.affectedmobile_auras[mobile.id]=nil
	end
	
	
end