 do
	local super=TRAININGGROUNDS_Telegraph
	TRAININGGROUNDS_Telegraph_Cone=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_Telegraph_Cone
	
	local TOTAL_POLYS=5
	
	function class:Setup(environment)
		super.Setup(self,environment)
		self.x=0
		self.y=0
		self.radius=nil
		self.angle=nil
		self.duration=nil
		self.fadeduration=nil
		self.alpha=1
		
		
		--TODO: standardize redraw
		self.redraw=false
		
		
		--TODO: flash+color options
	end
	
	function class:CreateAssociatedObjects()
		--print("CreateAssociatedObjects")
		self.polys={}
		for i=1,TOTAL_POLYS do
			self.polys[i]=TRAININGGROUNDS_Telegraph_Polygon.new()
			self.polys[i]:Setup(self.environment)
		end
	

	end
	
	function class:PositionCone(x,y,directionangle,widthangle,radius)
		local x1=x
		local y1=y
		local overlap=0.01
		for i=1,TOTAL_POLYS do
			local widthmultiplier=widthangle/5.0
			-- -2.5
			-- -1.5
			-- -0.5
			-- 0.5
			-- 1.5
			-- 2.5
			--TODO: angle calculation depends on exactly 5 TOTAL_POLYS
			local leftmost=-3.5+overlap
			x2=x1+math.cos(directionangle+(leftmost+i*1.0)*widthmultiplier)*radius
			y2=y1+math.sin(directionangle+(leftmost+i*1.0)*widthmultiplier)*radius
			x3=x1+math.cos(directionangle+(leftmost+1+overlap+i*1.0)*widthmultiplier)*radius
			y3=y1+math.sin(directionangle+(leftmost+1+overlap+i*1.0)*widthmultiplier)*radius
			-- if(i==5)then 
				-- print("cone i5:",x,y,directionangle,widthangle,radius)
				-- print("cone i5:",x1,y1,x2,y2,x3,y3) 
			-- end
			self.polys[i]:SetVertices(x1,y1,x2,y2,x3,y3)						
		end
	end
	
	function class:SetColor(R,G,B,A)
	
		self.basecolorR=R
		self.basecolorG=G
		self.basecolorB=B
		self.basecolorA=A
		self.finalcolorR=R
		self.finalcolorG=G
		self.finalcolorB=B
		self.finalcolorA=A
		
		
		self.redraw=true
		
		-- for i=1,TOTAL_POLYS do
			-- self.polys[i]:SetColor(R,G,B,A)
			-- self.polys[i].alpha=1.0
			-- self.polys[i].drawable.alpha=1.0
			-- self.polys[i].drawable:SetAlpha(1.0)
			-- self.polys[i].drawable.frame:SetAlpha(1.0)
		-- end

		--TRAININGGROUNDS_FrameVisibilityCheck(self.polys[5].drawable.frame)
	end
	
	function class:PreDraw()
		super.PreDraw(self)
		if(self.redraw)then
			self.redraw=false
			for i=1,TOTAL_POLYS do
				self.polys[i]:SetColor(self.finalcolorR,self.finalcolorG,self.finalcolorB,self.finalcolorA)
				self.polys[i].drawable.frame:SetAlpha(1.0)
			end
		end
	end
	
	function class:Cleanup()
		--print("Telegraph_Cone:cleanup")
		super.Cleanup(self)
		for i=1,TOTAL_POLYS do
			self.polys[i]:Die()
		end
	end
	
	
	-- local cone=TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath.new()
	-- cone:Setup(self.castercombat.owner.environment,self)

	-- local x1,y1=self.castercombat.owner.x,self.castercombat.owner.y
	-- local CONE_LENGTH=2000
	-- local x2,y2=x1+CONE_LENGTH*math.cos(self.targetangle-math.pi/8.0),y1+CONE_LENGTH*math.sin(self.targetangle-math.pi/8.0)
	-- local x3,y3=x1+CONE_LENGTH*math.cos(self.targetangle+math.pi/8.0),y1+CONE_LENGTH*math.sin(self.targetangle+math.pi/8.0)	
		
	-- cone:SetVertices(x1,y1,x2,y2,x3,y3)
	-- --TRAININGGROUNDS_FrameVisibilityCheck(cone.drawable.frame)
end