--TODO: move to Miscellaneous?
--TODO: since SelectionRectangle expects a ScenarioPlayerControls, enforce it during setup

--TODO: this is a mess, especially:
	-- 1. environment_gameplay/environment_hud storage
	-- 2. converting coordinates between the two

TRAININGGROUNDS_SelectionRectangle = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)

function TRAININGGROUNDS_SelectionRectangle:Setup(environment_hud,environment_gameplay)
	self.environment_hud=environment_hud
	self.environment_gameplay=environment_gameplay	
	
	TRAININGGROUNDS_GameObject.Setup(self,environment_hud)	
	--print("Selection setup",environment_hud.frame,self.drawable.parentframe)
end

function TRAININGGROUNDS_SelectionRectangle:SetCustomInfo()
	TRAININGGROUNDS_GameObject.SetCustomInfo(self)
	self.x1=0
	self.y1=0
	self.x2=0	
	self.y2=0
	self.visible=false
end

function TRAININGGROUNDS_SelectionRectangle:SetDrawable()
	self.drawable=TRAININGGROUNDS_Drawable_SelectionRectangle.new()
	self.drawable:Setup(self,self.environment)
	--print("SelectionRectangle:SetDrawable",self.environment.frame,UIParent)
end

-- function TRAININGGROUNDS_SelectionRectangle:SetDrawable()
	-- --TRAININGGROUNDS_GameObject.SetFrame(self)
	-- self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
	-- self.left=TRAININGGROUNDS_ReusableFrames:GetFrame()
	-- self.left:SetParent(self.frame);self.left:Show();self.left.texture:Show();self.left.texture:SetColorTexture(1,1,1,1)
	-- self.left:SetPoint("TOPLEFT",self.frame,"TOPLEFT",0,0);self.left:SetPoint("BOTTOMLEFT",self.frame,"BOTTOMLEFT",0,0)
	-- self.left:SetWidth(3)
	-- self.right=TRAININGGROUNDS_ReusableFrames:GetFrame()	
	-- self.right:SetParent(self.frame);self.right:Show();self.right.texture:Show();self.right.texture:SetColorTexture(1,1,1,1)
	-- self.right:SetPoint("TOPRIGHT",self.frame,"TOPRIGHT",0,0);self.right:SetPoint("BOTTOMRIGHT",self.frame,"BOTTOMRIGHT",0,0)
	-- self.right:SetWidth(3)	
	-- self.top=TRAININGGROUNDS_ReusableFrames:GetFrame()
	-- self.top:SetParent(self.frame);self.top:Show();self.top.texture:Show();self.top.texture:SetColorTexture(1,1,1,1)
	-- self.top:SetPoint("TOPLEFT",self.frame,"TOPLEFT",0,0);self.top:SetPoint("TOPRIGHT",self.frame,"TOPRIGHT",0,0)
	-- self.top:SetHeight(3)
	-- self.bottom=TRAININGGROUNDS_ReusableFrames:GetFrame()
	-- self.bottom:SetParent(self.frame);self.bottom:Show();self.bottom.texture:Show();self.bottom.texture:SetColorTexture(1,1,1,1)
	-- self.bottom:SetPoint("BOTTOMLEFT",self.frame,"BOTTOMLEFT",0,0);self.bottom:SetPoint("BOTTOMRIGHT",self.frame,"BOTTOMRIGHT",0,0)
	-- self.bottom:SetHeight(3)
	
	
	-- self.visible=false
-- end

function TRAININGGROUNDS_SelectionRectangle:Step(elapsed)
	TRAININGGROUNDS_GameObject.Step(self,elapsed)
end

--TODO: move SelectionRectangle draw function to its own Drawable class
	-- and move the actual selection code to playerinput
function TRAININGGROUNDS_SelectionRectangle:PreDraw()
	
	-- wait to call PreDraw until end of function, after we sort out where x/y should be
	
	if(self.environment.game.keys.lmouse.current)then
		self.visible=true
		--TODO: once camera_hud is fixed, we shouldn't need to show frame here (setting visible true should be enough)
		self.drawable.frame:Show()
		--self.frame:SetParent(self.environment.frame)		
		
		--local globalx,globaly=GetCursorPosition()
		--localx,localy=self.environment:MouseCoordinatesToWindowCoordinates(globalx,globaly)
		
		local environment_gameplay=self.environment.game.environment_gameplay
		local environment_hud=self.environment.game.environment_hud
		
		local globalx,globaly=GetCursorPosition()
		--TODO: rename vars
		--cursorx,cursory store mouse/window coordinates
		local cursorx,cursory=environment_gameplay:MouseCoordinatesToWindowCoordinates(globalx,globaly)
		
		local hudcursorx,hudcursory=environment_hud:MouseCoordinatesToWindowCoordinates(globalx,globaly)
		
		
		local localx,localy
		localx,localy=environment_gameplay:WindowCoordinatesToCursorPosition(cursorx,cursory)		
		--print("SelectionRectangle coordinates:",localx,localy)
		
		if(self.environment.game.keys.lmouse.pressed)then		
			self.gamex1=localx
			self.gamey1=localy
			self.hudx1=hudcursorx
			self.hudy1=hudcursory
		end	

		--TODO: there are a lot of search results for "self.frame:SetParent(self.parentframe)"
			-- -- can we set up code reuse somewhere?
		--print("Parentframe:",self.drawable.parentframe,self.drawable.frame:GetParent(),UIParent)		
		
		self.gamex2=localx
		self.gamey2=localy
		self.hudx2=hudcursorx
		self.hudy2=hudcursory
		
		self.gamex=min(self.gamex1,self.gamex2)
		self.gamey=min(self.gamey1,self.gamey2)			
		self.gamewidth=abs(self.gamex2-self.gamex1)
		self.gameheight=abs(self.gamey2-self.gamey1)
		
		self.hudx=min(self.hudx1,self.hudx2)
		self.hudy=min(self.hudy1,self.hudy2)	
		self.hudwidth=abs(self.hudx2-self.hudx1)
		self.hudheight=abs(self.hudy2-self.hudy1)
	
		-- if width or height is 0, SetSize will break and frame will remain at its previous size
		if(self.hudwidth==0)then self.hudwidth=1 end
		if(self.hudheight==0)then self.hudheight=1 end
		-- it's probably not necessary to clamp gamesize, but we're doing it anyway.
		-- TODO: determine if it's necessary or not
		if(self.gamewidth==0)then self.gamewidth=1 end
		if(self.gameheight==0)then self.gameheight=1 end		
		
		--TODO: some/most/all of this should be controlled by camera_hud and drawable_selectionrectangle
		--self.drawable.frame:SetPoint("BOTTOMLEFT",self.parentframe,"BOTTOMLEFT",self.hudx,self.hudy)
		--self.drawable.frame:SetSize(self.hudwidth,self.hudheight)
		self.x=self.hudx
		self.y=self.hudy
		--print("Y:",self.hudy,self.hudy1,self.hudy2)
		self.drawable.width=self.hudwidth
		self.drawable.height=self.hudheight
		
		
		
		
		--print(localx,localy,self.x1,self.y1,self.x2,self.y2,self.width,self.height)
		
		--print(self.x1)
		
		
		--self.frame:SetAllPoints(UIParent)
		
	elseif(self.environment.game.keys.lmouse.released)then
	
		--TODO: single-frame click can cause released to be called before pressed,
			-- at which point we crash because gamex,gamey, etc don't exist yet.
			-- initialize them in setup
		
		--TODO: move selection code to separate function in scenarioplayercontrols.lua
			-- and just send the list of highlighted objects to that function instead
		local env=self.environment.game.environment_gameplay
		local camera=env.camera	
		local frame=self.environment.game.window.frame		

		
		--local x3,y3=camera:WindowCoordsToCameraCoords(self.x,self.y)
		--local x4,y4=camera:WindowCoordsToCameraCoords(self.x+self.width,self.y+self.height)
		
		--TODO: camera position (screen scroll) not accounted for 
		--	(maybe don't need to?)
		local x3,y3=self.gamex,self.gamey
		local x4,y4=x3+self.gamewidth,y3+self.gameheight
		local w3=x4-x3
		local h3=y4-y3	
		
		local totalselected=0
		--TODO: rename mouseovercoords to windowcoords?
		
		--print("SelectionRectangle coordinates/size:",x3,y3,w3,h3,#env.mobiles)
		
		--TODO: maybe env.players instead of env.mobiles?
		local objs=self.environment:GetObjectsAtRectangleWindowCoordinates(env.mobiles,x3,y3,w3,h3)
		for i=1,#env.mobiles,1 do
			env.mobiles[i].TEMP_SelectedByCursor=false
		end
		for i=1,#objs,1 do
			objs[i].TEMP_SelectedByCursor=true
		end
		for i=1,#env.mobiles,1 do
			env.mobiles[i]:Select(env.mobiles[i].TEMP_SelectedByCursor)	
		end
		
		--self.environment.game.scenario.controls:CreateSpellButtonsFromSelectedUnits()
				
		
		
		
		--self.frame:SetParent(self.parentframe)
		--print("Select:",self.hudx,self.hudy,self.hudwidth,self.hudheight)
		
		--TODO: once camera_hud is fixed, we shouldn't need to hide frame here (setting visible false should be enough)
		self.drawable.frame:Hide()
		self.visible=false
		--print(totalselected,"mobiles selected")
		
	end
	
	TRAININGGROUNDS_GameObject.PreDraw(self)
	
end







--TODO: move to the same file as the rest of the collision code
--SOURCE: stackoverflow.com/questions/13390333/two-rectangles-intersection
function TRAININGGROUNDS_RectangleRectangleCollision(x1,y1,w1,h1,x2,y2,w2,h2)
	if(x1+w1<x2 or x2+w2<x1 or y1+h1<y2 or y2+h2<y1)then
		return false
	else
		return true
	end
end

--TODO: this shouldn't be in SelectionRectangle
--TODO: hit detection seems off, but this could have as much to do with drawn shadow position as anything else
--SOURCE: stackoverflow.com/questions/2049582/how-to-determine-if-a-point-is-in-a-2d-triangle
do
	local function _TRAININGGROUNDS_PointTriangleCollision(px,py,p0x,p0y,p1x,p1y,p2x,p2y)
		local s = p0y*p2x - p0x*p2y + (p2y-p0y)*px + (p0x-p2x)*py
		local t = p0x*p1y - p0y*p1x + (p0y-p1y)*px + (p1x-p0x)*py
		--print("s<0:",(s<0))
		--print("y<0:",(t<0))
		if((s<0)~=(t<0)) then
			return false
		end
		local A = -p1y*p2x + p0y*(p2x-p1x) + p0x*(p1y-p2y) + p1x*p2y
		if(A<0.0)then
			s=-s
			t=-t
			A=-A
		end
		return ((s>0) and (t>0) and ((s+t)<=A))
	end
	
	function TRAININGGROUNDS_PointTriangleCollision(px,py,x1,y1,x2,y2,x3,y3)
		--print("Calling PointTriangleCollision",px,py,x1,y1,x2,y2,x3,y3)
		return _TRAININGGROUNDS_PointTriangleCollision(px,py,x1,y1,x2,y2,x3,y3)
	end
	
	function TRAININGGROUNDS_GetAllObjectsInTriangle(objectlist,x1,y1,x2,y2,x3,y3)
		local result={}
		for i=1,#objectlist do
			local obj=objectlist[i]
			if(TRAININGGROUNDS_PointTriangleCollision(obj.x,obj.y,x1,y1,x2,y2,x3,y3))then
				tinsert(result,obj)
			end
		end
		return result
	end
	
	function TRAININGGROUNDS_GetAllObjectsInCone(objectlist,x1,y1,directionangle,widthangle,radius)
		local result={}
		for i=1,#objectlist do
			local obj=objectlist[i]
			local distx=obj.x-x1
			local disty=obj.y-y1
			local distsqr=distx*distx+disty*disty
			--TODO: save time by checking for distsqr here
			local angle_to_target=math.atan2(disty,distx)
			local anglediff=TRAININGGROUNDS_DifferenceBetweenAngles(directionangle,angle_to_target)
			if(distsqr<=radius*radius and math.abs(anglediff)<=widthangle/2)then
				--print("got a hit:",obj)
				--print("GetAllObjectsInCone",distsqr,radius*radius)
				--print("also:",anglediff,widthangle)
				tinsert(result,obj)
			end			
		end		
		return result
	end
	
	function TRAININGGROUNDS_GetAllObjectsInCircle(objectlist,x1,y1,radius)
		local result={}
		for i=1,#objectlist do
			local obj=objectlist[i]
			local distx=obj.x-x1
			local disty=obj.y-y1
			local distsqr=distx*distx+disty*disty
			if(distsqr<=radius*radius)then
				tinsert(result,obj)
			end
		end
		return result
	end
	
	
	--SOURCE: stackoverflow.com/questions/1878907/the-smallest-difference-between-2-angles
	local custommod=function(a,n)return a - math.floor(a/n) * n end
	function TRAININGGROUNDS_DifferenceBetweenAngles(angle1,angle2)		
		local a=angle1-angle2
		-- (a+180) % 360 - 180
		a=custommod((a+math.pi),math.pi*2) - math.pi
		return a
		
		-- also from same webpage: return math.atan2(math.sin(angle1-angle2), math.cos(angle1-angle2))
	end
	
	--SOURCE: stackoverflow.com/questions/1878907/the-smallest-difference-between-2-angles
	--TODO: we should figure out whether there are any problems caused by setting facing "out of range"
		-- ideally we only have to call this function when comparing facings, not setting them
	function TRAININGGROUNDS_Atan2Modulo(angle)
		return math.atan2(math.sin(angle),math.cos(angle))
	end
				
end

do
	local function _TRAININGGROUNDS_PointCircleCollision(px,py,cx,cy,radius)
		local distsqr=(px-cx)*(px-cx)+(py-cy)*(py-cy)
		return(distsqr <= radius*radius)
	end
	
	function TRAININGGROUNDS_PointCircleCollision(px,py,cx,cy,radius)
		return _TRAININGGROUNDS_PointCircleCollision(px,py,cx,cy,radius)
	end
end

-- old version
--TODO: move SelectionRectangle draw function to its own Drawable class
	-- and move the actual selection code to playerinput
-- function TRAININGGROUNDS_SelectionRectangle:PreDraw()
	-- TRAININGGROUNDS_GameObject.PreDraw(self)

	-- if(self.environment.game.keys.lmouse.current)then
		-- self.visible=true
		-- self.frame:Show()
		-- --self.frame:SetParent(self.environment.frame)		
		
		-- --local globalx,globaly=GetCursorPosition()
		-- --localx,localy=self.environment:MouseCoordinatesToWindowCoordinates(globalx,globaly)
		
		-- local environment_gameplay=self.environment.game.environment_gameplay
		
		-- local globalx,globaly=GetCursorPosition()
		-- --TODO: rename vars
		-- --cursorx,cursory store mouse/window coordinates
		-- local cursorx,cursory=environment_gameplay:MouseCoordinatesToWindowCoordinates(globalx,globaly)
		-- local localx,localy
		-- localx,localy=environment_gameplay:WindowCoordinatesToCursorPosition(cursorx,cursory)		
		-- --print("SelectionRectangle coordinates:",localx,localy)
		
		-- if(self.environment.game.keys.lmouse.pressed)then		
			-- self.x1=localx
			-- self.y1=localy
		-- end	

		-- self.x2=localx
		-- self.y2=localy
		
		-- self.x=min(self.x1,self.x2)
		-- self.y=min(self.y1,self.y2)		
		-- self.width=abs(self.x2-self.x1)
		-- self.height=abs(self.y2-self.y1)
		
		-- self.frame:SetPoint("TOPLEFT",self.parentframe,"TOPLEFT",self.x,self.y)
		-- self.frame:SetSize(self.width,self.height)
		
		-- -- if width or height is 0, SetWidth/Height will break and frame will remain at its previous size
		-- if(self.width==0)then self.width=1 end
		-- if(self.height==0)then self.height=1 end
		
		-- --print(localx,localy,self.x1,self.y1,self.x2,self.y2,self.width,self.height)
		
		-- --print(self.x1)
		
		
		-- --self.frame:SetAllPoints(UIParent)
		
	-- elseif(self.environment.game.keys.lmouse.released)then
		
		-- --TODO: move selection code to separate function in scenarioplayercontrols.lua
			-- -- and just send the list of highlighted objects to that function instead
		-- local env=self.environment.game.environment_gameplay
		-- local camera=env.camera	
		-- local frame=self.environment.game.window.frame		

		
		-- --local x3,y3=camera:WindowCoordsToCameraCoords(self.x,self.y)
		-- --local x4,y4=camera:WindowCoordsToCameraCoords(self.x+self.width,self.y+self.height)
		
		-- --TODO: camera position (screen scroll) not accounted for 
		-- --	(maybe don't need to?)
		-- local x3,y3=self.x,self.y
		-- local x4,y4=x3+self.width,y3+self.height
		-- local w3=x4-x3
		-- local h3=y4-y3	
		
		-- local totalselected=0
		-- --TODO: rename mouseovercoords to windowcoords?
		
		-- --print("SelectionRectangle coordinates/size:",x3,y3,w3,h3,#env.mobiles)
		
		-- --TODO: maybe env.players instead of env.mobiles?
		-- local objs=self.environment:GetObjectsAtRectangleWindowCoordinates(env.mobiles,x3,y3,w3,h3)
		-- for i=1,#env.mobiles,1 do
			-- env.mobiles[i].TEMP_SelectedByCursor=false
		-- end
		-- for i=1,#objs,1 do
			-- objs[i].TEMP_SelectedByCursor=true
		-- end
		-- for i=1,#env.mobiles,1 do
			-- env.mobiles[i]:Select(env.mobiles[i].TEMP_SelectedByCursor)	
		-- end
		
		-- --self.environment.game.scenario.controls:CreateSpellButtonsFromSelectedUnits()
				
		
		
		
		-- self.frame:SetParent(self.parentframe)
		-- self.frame:Hide()
		-- self.visible=false
		-- --print(totalselected,"mobiles selected")
		
	-- end
-- end

