TRAININGGROUNDS_BossController = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)

function TRAININGGROUNDS_BossController:Setup(environment,scenario)
	TRAININGGROUNDS_GameObject.Setup(self,environment,scenario)
	self.scenario=scenario
	self.raid=self.scenario.raid
end

function TRAININGGROUNDS_BossController:SetCustomInfo()
	TRAININGGROUNDS_GameObject.SetCustomInfo(self)
	
	self.visible=false
	
	self.active=false
	self.boss={}
end


function TRAININGGROUNDS_BossController:CreateBoss()
	-- don't override (override CreateBossDetails instead)
	--print("BossController is object",self)
	--print("BossController:CreateBoss")
	if(not self.active)then
		self:CreateBossDetails()		
		local buttons=self:CreateAndReturnBossOverrideButtons()
		self.groupdancemodule=self:ReturnNewGroupDanceModule()
		--print("self.groupdancemodule is",self.groupdancemodule)
		if(self.groupdancemodule)then 
			--print("Created bosscontroller.groupdancemodule")
			self.groupdancemodule:Setup(self.scenario)
		end
		--TODO: pass finished buttons to SpellButtonController/HotbarController
	else
		print("WARNING: Call to CreateBoss when BossController was already active")
		-- possibly throw a debug warning message here
	end
	self.active=true
end

function TRAININGGROUNDS_BossController:CreateBossDetails()
	-- override
end


function TRAININGGROUNDS_BossController:ReturnNewGroupDanceModule()
	--override
end

function TRAININGGROUNDS_BossController:CreateAndReturnBossOverrideButtons()
	-- override
	return {}
end

function TRAININGGROUNDS_BossController:CreateQuickBossOverrideFromSpell(boss,bossspell)	
	local spellbutton=TRAININGGROUNDS_SpellButton.new()
	--print("Environment_hotbar:",self.environment.game.environment_hotbar)
	spellbutton:Setup(self.environment.game.environment_hotbar)
	spellbutton.drawable.frame:SetScript("OnClick",function()
			if(not boss.deadingame)then
				boss.combat:OverrideCastBossSpell(bossspell)
			end
		end)
	return spellbutton
end

function TRAININGGROUNDS_BossController:GetSpellTarget(spelltemplate)
	local target=nil
	local raid=self.scenario.raid
	local players=self.scenario.raid.players
	if(spelltemplate.bosscastingstyle==TRAININGGROUNDS_SpellBossCastingStyle.SPREADDEBUFF_NONTANK)then
		--TODO: for now we're ignoring the rule and picking randomly
		--TODO: some overlap here with scenario:getrandomrangedtarget
		--TODO: we haven't even decided when it's best to call BossController:GetTarget vs Scenario:GetTarget
		target=players[math.random(1,#self.scenario.raid.players)]		
	end
	return target
end