
do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_WorldMarker_Float=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_WorldMarker_Float
	
	function class:Setup(environment,owner)
		self.wmindex=owner.wmindex
		super.Setup(self,environment)
		self.owner=owner
		--self.alpha=0
		--self.drawable:SetAlpha(self.alpha)
		self.alpha=1
		self.drawable.width=50
		self.drawable.height=50
	end

	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.ysortable=true
		self.t=0
	end
	
	
	function class:SetDrawable()
		self.drawable=TRAININGGROUNDS_Drawable_Sprite_WorldMarker_Float.new()
		self.drawable:Setup(self,self.environment)
		local wmindexstring=tostring(TRAININGGROUNDS_RaidMarkerController_WorldMarkerIndexToRaidMarkerIndex(self.wmindex))
		self.drawable.filename="interface\\targetingframe\\ui-raidtargetingicon_"..wmindexstring..".blp"
		self.drawable:ReloadFile()
	end
	
	function class:SetFrameLayer()
		self.framelayer=self.owner.environment.camera.voidzoneframelayer
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)
		local cyclespeed=2.85
		self.t=self.t+elapsed*cyclespeed
		self.z=90+(30*math.sin(self.t))
		
		if(self.owner.dead)then
			self.alpha=self.alpha-elapsed
			if(self.alpha<=0)then
				self:Die()
			end
		else
			self.x=self.owner.x;self.y=self.owner.y
			-- self.alpha=self.alpha+elapsed
			-- if(self.alpha>1)then
				-- self.alpha=1
			-- end			
		end
		self.drawable:SetAlpha(self.alpha)
		--TODO: float sine wave code
	end
end