
do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_WorldMarker_Base=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_WorldMarker_Base
	
	function class:Setup(environment,owner)
		self.wmindex=owner.wmindex
		super.Setup(self,environment,owner)
		self.owner=owner
		self.alpha=0
		self.drawable:SetAlpha(self.alpha)
		self.drawable.width=100
		self.drawable.height=100
	end
	
	function class:SetDrawable()
		self.drawable=TRAININGGROUNDS_Drawable_Sprite_WorldMarker_Shadow.new()
		self.drawable:Setup(self,self.environment,self.wmindex)
		local rgb=TRAININGGROUNDS_RaidMarkerController_GetRaidMarkerRGB(TRAININGGROUNDS_RaidMarkerController_WorldMarkerIndexToRaidMarkerIndex(self.wmindex))
		rgb[4]=0.75
		self.drawable:SetColor(unpack(rgb))

	end
	
	function class:SetFrameLayer()
		self.framelayer=self.owner.environment.camera.voidzoneframelayer
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)
		self.x=self.owner.x;self.y=self.owner.y
		if(self.owner.dead)then
			self.alpha=self.alpha-elapsed
			if(self.alpha<=0)then
				self:Die()
			end
		else
			self.alpha=self.alpha+elapsed
			if(self.alpha>1)then
				self.alpha=1
			end			
		end
		self.drawable:SetAlpha(self.alpha)
	end	
end
