
do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_RaidMarkerController=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_RaidMarkerController
	
	-- there are 8 default world markers.
	-- there's nothing stopping us from creating additional world markers if we have graphics for them
	TRAININGGROUNDS_RaidMarkerController_MAX_MARKERS=8
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		
		self.visible=false
		
		self.markers={}		
		-- The following loop is only here to communicate intent to the reader.
		-- Functionally, it does nothing whatsoever.		
		for i=1,TRAININGGROUNDS_RaidMarkerController_MAX_MARKERS do
			self.markers[i]=nil
		end	
	end

	function class:GetWorldMarkerPosition(index,x,y)
		if(self.markers[index])then
			return {x=self.markers[index].x,y=self.markers[index].y}
		end
	end
	
	function class:PlaceWorldMarker(index,x,y)
		if(self.markers[index])then
			self.markers[index]:Die()
		end
		local marker=TRAININGGROUNDS_WorldMarker.new()
		marker:Setup(self.environment,index)
		marker.x=x
		marker.y=y		
		--print("Create world marker",index,x,y)
		self.markers[index]=marker
	end

	
	-- static function
	function TRAININGGROUNDS_RaidMarkerController_WorldMarkerIndexToRaidMarkerIndex(wmindex)
		--TODO: convert to array
		if(wmindex==1)then
			return 6
		elseif(wmindex==2)then
			return 4
		elseif(wmindex==3)then
			return 3
		elseif(wmindex==4)then
			return 7
		elseif(wmindex==5)then
			return 1
		elseif(wmindex==6)then
			return 2
		elseif(wmindex==7)then
			return 5
		elseif(wmindex==8)then
			return 8
		end
	end

	-- static function
	function TRAININGGROUNDS_RaidMarkerController_GetRaidMarkerRGB(rmindex)
		--TODO: convert to array
		if(rmindex==6)then	-- BLUE SQUARE
			return {0,0.625,1}
		elseif(rmindex==4)then	-- GREEN TRIANGLE
			return {0,1,0}
		elseif(rmindex==3)then	-- PURPLE DIAMOND
			return {1,0,1}
		elseif(rmindex==7)then -- RED X
			return {1,0,0}
		elseif(rmindex==1)then -- YELLOW STAR
			return {1,1,0}
		elseif(rmindex==2)then -- ORANGE CIRCLE
			return {1,0.5,0}
		elseif(rmindex==5)then -- SILVER MOON
			return {0.8,1.0,1.0}
		elseif(rmindex==8)then -- GRAY SKULL
			return {0.75,0.75,0.75}
		end
		return {0,0.625,1}
	end
	
	
end

