
TRAININGGROUNDS_Projectile = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)

function TRAININGGROUNDS_Projectile:Setup(environment,spellinstance)
	TRAININGGROUNDS_GameObject.Setup(self,environment)
	if(not spellinstance.instance)then
		error("Non-instanced spell was assigned to projectile")
	end
	self.spell=spellinstance	
	self.targetcombat=self.spell.targetcombat
end

function TRAININGGROUNDS_Projectile:SetCustomInfo()
	TRAININGGROUNDS_GameObject.SetCustomInfo(self)
	self.ysortable=true
end

function TRAININGGROUNDS_Projectile:SetDrawable()
	self.drawable=TRAININGGROUNDS_Drawable_SpellEffect.new()
	self.drawable:Setup(self,self.environment)
end

function TRAININGGROUNDS_Projectile:SetWidthAndHeight()
	self.drawable.width=50
	self.drawable.height=self.drawable.width
end

function TRAININGGROUNDS_Projectile:DeliverSpellEffect()
	self.spell:ExecuteSpellEffect(self)
end