

TRAININGGROUNDS_Drawable_ResourceBarFragment = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable)

function TRAININGGROUNDS_Drawable_ResourceBarFragment:CreateFrame()
	self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
	TRAININGGROUNDS_ResourceBarFragment_CreateFrames(self)
end




function TRAININGGROUNDS_Drawable_ResourceBarFragment:SetFrameAppearance()
	TRAININGGROUNDS_ResourceBarFragment_SetFillAppearance(self)
	self.borderalpha=1
end

function TRAININGGROUNDS_Drawable_ResourceBarFragment:ShowFrames()
	TRAININGGROUNDS_Drawable.ShowFrames(self)
	-- TODO: alpha not necessarily 1
	TRAININGGROUNDS_ResourceBarFragment_SetAlpha(self,1,self.borderalpha)
end

function TRAININGGROUNDS_Drawable_ResourceBarFragment:HideFrames()
	TRAININGGROUNDS_Drawable.HideFrames(self)
	TRAININGGROUNDS_ResourceBarFragment_SetAlpha(self,0,0)
end

function TRAININGGROUNDS_Drawable_ResourceBarFragment:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch)
	self.frame:SetSize(wid,hgt)	
	TRAININGGROUNDS_ResourceBarFragment_SetSize(self,wid,hgt)
end


function TRAININGGROUNDS_Drawable_ResourceBarFragment:SetCustomFrameLevels(preysortlevel,postysortlevel)
	local level=postysortlevel
		--TODO: TRAININGGROUNDS_MAX_FRAMELEVEL const?
	if(not level) then level=255-3 end
	if(level>255-3) then level=255-3 end
	
	--TODO: move to function
	self.topfill:SetFrameLevel(level+3)
	self.midfill:SetFrameLevel(level+3)
	self.bottomfill:SetFrameLevel(level+3)

end



function TRAININGGROUNDS_Drawable_ResourceBarFragment:Cleanup()
	TRAININGGROUNDS_Drawable.Cleanup(self)
	TRAININGGROUNDS_ResourceBarFragment_Cleanup(self)
end

-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------

-- Functions for the inner fill section of resource bars.
-- (Used not only for resource bars but also smaller fragments of resource bars such as incoming heals and spent resources.)
--TODO: rename ResourceBarFill?
--TODO: functions for outer frame too?

function TRAININGGROUNDS_ResourceBarFragment_CreateFrames(self)
	-- Fill; broken into 3 parts to control inner gradient 
	self.topfill=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.midfill=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.bottomfill=TRAININGGROUNDS_ReusableFrames:GetFrame()
	
	
end

function TRAININGGROUNDS_ResourceBarFragment_SetFillAppearance(self)
	--if the bar is too skinny, top and bottomfill vanish entirely and midfill expands to fill their place
	
	--topfill takes up the top 25% of the bar
	self.topfill:SetParent(self.frame)
	self.topfill:SetPoint("TOPLEFT",self.frame,"TOPLEFT",0,0)
	self.topfill.texture:SetColorTexture(1,1,0,1)	
							--orientation,   r,g,b,a,  r,g,b,a
	self.topfill.texture:SetGradientAlpha("VERTICAL", 1,1,1,1.0,.5,.5,.5,1.0)
	self.topfill.texture:Show()
	self.topfill:Show()	

	--midfill takes up the area between the 25% and 50% points
	self.midfill:SetParent(self.frame)
		-- midfill will be moved vertically depending on bar height
	self.midfill:SetPoint("LEFT",self.frame,"LEFT",0,0)
	self.midfill.texture:SetColorTexture(1,1,0,1)
	self.midfill.texture:Show()
	self.midfill:Show()		
	
	--bottomfill takes up the bottom 50% of the bar
	self.bottomfill:SetParent(self.frame)
	self.bottomfill:SetPoint("BOTTOMLEFT",self.frame,"BOTTOMLEFT",0,0)
							--orientation,   r,g,b,a,  r,g,b,a
	self.bottomfill.texture:SetColorTexture(1,1,0,1)	
	self.bottomfill.texture:SetGradientAlpha("VERTICAL", .5,.5,.5,1.0,  1,1,1,1.0)
	self.bottomfill.texture:Show()
	self.bottomfill:Show()	
end

function TRAININGGROUNDS_ResourceBarFragment_SetAlpha(self,value,borderalpha)
	--if the bar is too skinny, top and bottomfill vanish entirely and midfill expands to fill their place
	self.topfill:SetAlpha(value*borderalpha)
	self.midfill:SetAlpha(value)
	self.bottomfill:SetAlpha(value*borderalpha)
end

function TRAININGGROUNDS_ResourceBarFragment_SetSize(self,wid,hgt)
	--TODO: resuable GetThickness() and GetMaxThickness()
	local THICKNESS=1+hgt/10
	if(THICKNESS>3)then THICKNESS=3 end	

	if(THICKNESS>=1.25)then
		self.borderalpha=1		
	else
		self.borderalpha=0
	end
	hgt=1+hgt
	if(hgt>1+1.25)then
		self.topfill:SetSize(wid,hgt/4)
		self.midfill:SetSize(wid,hgt/4)	
		self.midfill:SetPoint("LEFT",self.frame,"LEFT",0,1/8*hgt)
		self.bottomfill:SetSize(wid,hgt/2)
	else
		self.midfill:SetSize(wid,hgt)	
		self.midfill:SetPoint("LEFT",self.frame,"LEFT",0,0)
	end
end

function TRAININGGROUNDS_ResourceBarFragment_Cleanup(self)
	self.topfill:Cleanup()
	self.midfill:Cleanup()
	self.bottomfill:Cleanup()
end