
TRAININGGROUNDS_Drawable_ResourceBar = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable)

function TRAININGGROUNDS_Drawable_ResourceBar:CreateFrame()
	--TODO: border should probably be in its own file...

	-- Background
	self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
	-- Border
	self.top=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.bottom=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.left=TRAININGGROUNDS_ReusableFrames:GetFrame()
	self.right=TRAININGGROUNDS_ReusableFrames:GetFrame()
	
	TRAININGGROUNDS_ResourceBarFragment_CreateFrames(self)

end


function TRAININGGROUNDS_Drawable_ResourceBar:SetFrameAppearance()
	self.frame.texture:SetColorTexture(0,0,0,0.5)
	self.frame.texture:Show()
	self.top:SetParent(self.frame)
	self.top:SetPoint("BOTTOM",self.frame,"TOP",0,0)
	self.top.texture:SetColorTexture(1,1,1,1)
	self.top.texture:Show()	
	self.top:Show()
	self.bottom:SetParent(self.frame)
	self.bottom:SetPoint("TOP",self.frame,"BOTTOM",0,0)
	self.bottom.texture:SetColorTexture(1,1,1,1)	
	self.bottom.texture:Show()
	self.bottom:Show()
	self.left:SetParent(self.frame)
	self.left:SetPoint("RIGHT",self.frame,"LEFT",0,0)
	self.left.texture:SetColorTexture(1,1,1,1)
	self.left.texture:Show()
	self.left:Show()	
	self.right:SetParent(self.frame)
	self.right:SetPoint("LEFT",self.frame,"RIGHT",0,0)
	self.right.texture:SetColorTexture(1,1,1,1)
	self.right.texture:Show()
	self.right:Show()
	
	TRAININGGROUNDS_ResourceBarFragment_SetFillAppearance(self)
	
	--TODO: move to SetCustomInfo, if drawable has setcustominfo
	self.borderalpha=1	
end

function TRAININGGROUNDS_Drawable_ResourceBar:ShowFrames()
	TRAININGGROUNDS_Drawable.ShowFrames(self)
	-- TODO: alpha not necessarily 1
		self.alpha=1	
	self.top:SetAlpha(self.borderalpha*self.alpha)
	self.bottom:SetAlpha(self.borderalpha*self.alpha)
	self.left:SetAlpha(self.borderalpha*self.alpha)
	self.right:SetAlpha(self.borderalpha*self.alpha)
	TRAININGGROUNDS_ResourceBarFragment_SetAlpha(self,self.alpha,self.borderalpha)
end

function TRAININGGROUNDS_Drawable_ResourceBar:HideFrames()
	TRAININGGROUNDS_Drawable.HideFrames(self)
	self.top:SetAlpha(0)
	self.bottom:SetAlpha(0)
	self.left:SetAlpha(0)
	self.right:SetAlpha(0)
	TRAININGGROUNDS_ResourceBarFragment_SetAlpha(self,0,0)
end


function TRAININGGROUNDS_Drawable_ResourceBar:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch)
	
	
	--TODO: resuable GetThickness() and GetMaxThickness()
	local THICKNESS=1+hgt/10
	if(THICKNESS>3)then THICKNESS=3 end	

	
	self.frame:SetSize(wid,hgt)

	self.top:SetSize(wid+THICKNESS*2,THICKNESS)
	self.bottom:SetSize(wid+THICKNESS*2,THICKNESS)
	self.left:SetSize(THICKNESS,hgt)	
	self.right:SetSize(THICKNESS,hgt)		



	--if(THICKNESS>=2)then
		--TODO: not necessarily alpha(1)
--		self.top:SetAlpha(1);self.bottom:SetAlpha(1);self.left:SetAlpha(1);self.right:SetAlpha(1)

	--else
--		self.top:SetAlpha(0);self.bottom:SetAlpha(0);self.left:SetAlpha(0);self.right:SetAlpha(0)
--	end
	
	--TODO: check self.fillratio, if it exists
	-- (fragments would already have fillratio defined)
	local ratio=1
	if(self.owner.resource)then
		ratio=self.owner.resource.current/self.owner.resource.max
	end	
	local fillwid=wid*ratio
		
	TRAININGGROUNDS_ResourceBarFragment_SetSize(self,fillwid,hgt)

end


function TRAININGGROUNDS_Drawable_ResourceBar:SetCustomFrameLevels(preysortlevel,postysortlevel)
	local level=postysortlevel
		--TODO: TRAININGGROUNDS_MAX_FRAMELEVEL const?
	if(not level) then level=255-3 end
	if(level>255-3) then level=255-3 end
	
	self.frame:SetFrameLevel(level)
	self.topfill:SetFrameLevel(level+1)
	self.midfill:SetFrameLevel(level+1)
	self.bottomfill:SetFrameLevel(level+1)
	self.top:SetFrameLevel(level+2)
	self.bottom:SetFrameLevel(level+2)
	self.left:SetFrameLevel(level+2)
	self.right:SetFrameLevel(level+2)
end



function TRAININGGROUNDS_Drawable_ResourceBar:Cleanup()
	TRAININGGROUNDS_Drawable.Cleanup(self)
	self.top:Cleanup()
	self.bottom:Cleanup()
	self.left:Cleanup()
	self.right:Cleanup()
	TRAININGGROUNDS_ResourceBarFragment_Cleanup(self)
end
