

TRAININGGROUNDS_PlayerCharacter = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Mobile)


function TRAININGGROUNDS_PlayerCharacter:SetCustomInfo()
	TRAININGGROUNDS_Mobile.SetCustomInfo(self)
	self.equipment=nil
	self.faction=TRAININGGROUNDS_Factions.PLAYER
end

function TRAININGGROUNDS_PlayerCharacter:SetModelInfo()
	self.modelinfo=TRAININGGROUNDS_ModelInfos.PlayerCharacter
end

function TRAININGGROUNDS_PlayerCharacter:SetDrawable()				  
	self.drawable=TRAININGGROUNDS_Drawable_CharacterModel_Equipped.new()
	self.drawable:Setup(self,self.environment)
end

function TRAININGGROUNDS_PlayerCharacter:SetupEnvironmentObjectListIndexStorage(environment)
	TRAININGGROUNDS_Mobile.SetupEnvironmentObjectListIndexStorage(self,environment)
	tinsert(self.environmentobjectlists,self.environment.raiders)
end

function TRAININGGROUNDS_PlayerCharacter:SetPlayerAppearance()	
	--TODO: GetPlayerEquipment, self.drawable:SetEquipment
	--TODO: offhand items aren't replaced properly
	--TODO: ideally we don't call SetRandomAppearance earlier and try to overwrite it later
	self.drawable.frame:SetUnit("player")
end

function TRAININGGROUNDS_PlayerCharacter:SetRandomAppearance()	
	--TODO:
	--for now, just pick a random race...
	local r=math.floor(math.random()*#TRAININGGROUNDS_PlayerCharacterRaceInfo.simplelistofraceids+1)
	r=TRAININGGROUNDS_PlayerCharacterRaceInfo.simplelistofraceids[r]
	local s=math.floor(math.random()*2)
	self.drawable.frame:SetCustomRace(r,s)
	
	--for now, just pick a random class...
	local i=math.floor(math.random()*#TRAININGGROUNDS_Classes+1)
					--TODO: rename Classes to WoWClasses, a subset of Classes?  (and then maybe use Classes here anyway)
	self.drawable:SetEquipment(TRAININGGROUNDS_Classes[i].equipments[1])
end

--call once, after WoW finishes loading (probably game.setup)
function TRAININGGROUNDS_PlayerCharacter.SetupCanPlayerDW()
	-- TODO: specs are subject to change in 7.0
	local localspecid=GetSpecialization()
	if(localspecid==nil)then 
		-- Player hasn't loaded yet!  Try again later
		-- (or panic; we should only get here if we autostart during loading screen)
		return false 
	end	
	local globalspecid=GetSpecializationInfo(GetSpecialization())
	local localname,classname,classid=UnitClass("player")
	if(	   globalspecid==251	-- Frost DK
		or globalspecid==253	-- Beast Mastery Hunter
		or globalspecid==254	-- Marksmanship Hunter
		or globalspecid==255	-- Survival Hunter
		--or globalspecid==268	-- Brewmaster Monk	--TODO: verify BrM can't dual-wield
		or globalspecid==269	-- Windwalker Monk
		or globalspecid==72 	-- Fury Warrior
		or globalspecid==263	-- Enhancement Shaman
		or classid==4			-- All Rogues
		or classid==12			-- All DHs
		----TODO: these classes can certainly DW.  why are they commented out
		--or globalspecid==259	-- Assassination Rogue
		--or globalspecid==260	-- Combat Rogue
		--or globalspecid==261	-- Subtlety Rogue

		--or globalspecid==577	-- Havoc DH
		--or globalspecid==581	-- Vengeance DH		
		)then
		_TRAININGGROUNDS_PlayerCharacter_CanPlayerDW=true
	end
	
	_TRAININGGROUNDS_PlayerCharacter_CanPlayerDW=false	
	
end

--global static
function TRAININGGROUNDS_PlayerCharacter.CanPlayerDW()
	return _TRAININGGROUNDS_PlayerCharacter_CanPlayerDW
end

--------------------------------------
--------------------------------------
--------------------------------------
--------------------------------------
--------------------------------------

