TRAININGGROUNDS_Equipment = {}
TRAININGGROUNDS_Equipment.__index = TRAININGGROUNDS_Equipment

TRAININGGROUNDS_Equipment.invtype={}
TRAININGGROUNDS_Equipment.invtype["INVTYPE_CHEST"]="ChestSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_FEET"]="FeetSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_HANDS"]="HandsSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_HEAD"]="HeadSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_LEGS"]="LegsSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_CHEST"]="ChestSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_SHOULDER"]="ShoulderSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_WAIST"]="WaistSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_WRIST"]="WristSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_MAINHAND"]="MainHandSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_OFFHAND"]="SecondaryHandSlot"
TRAININGGROUNDS_Equipment.invtype["INVTYPE_OFFHAND_BACKUP"]="SecondaryHandSlot"


function TRAININGGROUNDS_Equipment.new()
	local self=setmetatable({}, TRAININGGROUNDS_Equipment)	
	
	-- set equipment slot to -1 to remove item
	-- set equipment slot to nil to ignore slot
	self.items={}
		
	return self
end

function TRAININGGROUNDS_Equipment:RemoveAllSlots()
	for i=1,20,1 do
		self.items[i]=-1
	end
end

function TRAININGGROUNDS_Equipment:EquipItemToKnownSlot(itemid, slotstring)
	local slotid=TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID[slotstring]
	if(slotid==nil)then
		print("TRAININGGROUNDS_Equipment:EquipItemToKnownSlot warning: "..slotstring.." isn't a known equipment slot")
	end
	self.items[slotid]=itemid
end

function TRAININGGROUNDS_Equipment:TryItem(itemid)
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture, itemSellPrice = GetItemInfo(itemid)
	if(itemName==nil)then
		-- Item hasn't been cached yet!
		-- Character will have to try calling again later.
		return false
	end
	
	--print("Item "..itemid.." equippable in "..tostring(itemEquipLoc))
	if(itemEquipLoc=="") then 
		print("Equipment.lua: Itemid can't be equipped: "..itemid); 
		return false
	end
	local slotname=TRAININGGROUNDS_Equipment.invtype[itemEquipLoc]
	if(slotname==nil)then
		print("Equipment.lua: Unknown equipment slot name "..tostring(slotname).." for itemEquipLoc "..tostring(itemEquipLoc).." for item "..itemid)
		return false
	end
	local slotid=TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID[slotname]
	if(slotid==nil)then
		--print("Equipment.lua: Unknown slot id: "..tostring(slotid).." ("..slotname..")")
		return false
	end
	--print("Equipment.lua: Equipping "..itemid.." to slot "..slotid)
	self.items[slotid]=itemid
	
	return true
end

function TRAININGGROUNDS_Equipment:EquipToModelframe(modelframe)	
	for i=1,20,1 do
		if(self.items[i])then			
			if(self.items[i]==-1)then
				--TODO: write a warning and/or assert() somewhere that BackupSecondaryHandSlot shouldn't be -1 if SecondaryHandSlot isn't also -1, and vice versa
				modelframe:UndressSlot(i)
			elseif(self.items[i]==nil)then
				--if item is nil, ignore this slot
			else
				--else item is neither -1 nor nil, so equip the item.
				--First, check special case for offhand slot.
				if((i==TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID["SecondaryHandSlot"]
				and TRAININGGROUNDS_PlayerCharacter.CanPlayerDW())
				or(i==TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID["BackupSecondaryHandSlot"]
				and not TRAININGGROUNDS_PlayerCharacter.CanPlayerDW())
				)then
					-- This undocumented feature of TryOn is the only way to persuade Hunters to equip weapons to offhand.
					-- It can be used to equip weapons to offhand for non-DW classes, but doing so removes their mainhand item.					
					local tooltip=self:GetItemTooltip(self.items[i])
					modelframe:TryOn(tooltip,"offhand")
				elseif((i==TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID["SecondaryHandSlot"]
				and not TRAININGGROUNDS_PlayerCharacter.CanPlayerDW())
				or(i==TRAININGGROUNDS_PlayerCharacterRaceInfo.EQUIPMENTSLOTID["BackupSecondaryHandSlot"]
				and TRAININGGROUNDS_PlayerCharacter.CanPlayerDW())
				)then
					-- do nothing; of the pair of Secondary/BackupSecondary, this is the unused slot
				else
					-- if we're here, this isn't an offhand slot, so proceed as usual
					local tooltip=self:GetItemTooltip(self.items[i])
					modelframe:TryOn(tooltip)
				end				
			end
		end
	end
end

--TODO: rename "itemtooltip" to "itemlink"
-- at some point, modelframe:TryOn stopped accepting itemids, so we have to create our own tooltips.
function TRAININGGROUNDS_Equipment:GetItemTooltip(itemid)
	return "\124cff9d9d9d\124Hitem:"..itemid.."::::::::110:::::\124h[TrainingGrounds Item]\124h\124r"
end
