TRAININGGROUNDS_Mobile = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)

function TRAININGGROUNDS_Mobile:Setup(environment)
	TRAININGGROUNDS_GameObject.Setup(self,environment)
	-- create combatmodule first
	self:CreateCombatModule()
	-- AI may reference some of combatmodule's spells
	self:CreateAI()
	
	self:CreatePersonalDanceModule()	
	
	--some abilities depend on the direction the player is trying to move,
	-- not the direction the player is actually moving
	self.attemptedmovementunitvectorx=0
	self.attemptedmovementunitvectory=0
	
	self.targetfacing_movement=nil
	self.targetfacing_spellcast=nil
	
	self.movementvectorx=0
	self.movementvectory=0
	
	self.turnspeed=0
	-- used for non-player-controlled facing
	self.projectedmovementfacing=nil
end

function TRAININGGROUNDS_Mobile:SetCustomInfo()
	TRAININGGROUNDS_GameObject.SetCustomInfo(self)
	
	self.selected=false
	self.ysortable=true
	self.currentfacing=-math.pi/2
	
	self.gravity=-300*4
	self.basemovespeed=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(7.0)
	
	self.faction=TRAININGGROUNDS_Factions.NULL
	
	--player hitbox radius for RANGED SPELLS is apparently 1.5 yards.
		-- Ranged spells (attacks and heals) are measured from caster's CENTER to target's EDGE.
	-- (TODO: override for other mobiles)
	-- SOURCE: us.battle.net/forums/wow/topic/20743504316?page=23#460
	-- "You're not accounting for player hitbox sizes. A 10yd aura can apply to a player that is 11.5yd away (center-to-center)."
	--self.hitboxradius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1.5)
	-- other sources say hitbox radius for MELEE ATTACKS is effectively 0
	--   (5 yards from caster's CENTER to target's CENTER)
	-- However:
	-- SOURCE: us.battle.net/forums/wow/topic/20743504316?page=24#465
	-- "No, they're not. Fireball, Healing Touch, etc... All ranged spells targeted at a unit are based on center-to-edge range. 
	--  Melee spells are based on edge-to-edge, but we don't show melee range in tooltips so that difference doesn't really get noticed."
	
	-- so, to put it all together:
	-- 2 player hitboxes 1.5yd each
	-- + melee range TWO YARDS
	-- = 5 yards melee range in PvP (?)	
	
	-- however, Balance Affinity talent reveals that "melee range" attacks are still considered to be 5 yards by tooltips.
	-- This is probably a case of the tooltip lying to us.
	--TODO: get some UnitPosition measurements using an in-game duel
	
	self.hitboxradius=TRAININGGROUNDS_Mobile_StandardHitboxRadius	
	
	--TODO LATER:
	-- with respect to haste and dynamic GCDs (for classes where GCDs are affected by haste):
	-- SOURCE: us.battle.net/forums/wow/topic/20743504316?page=25#492
	--"Not quite. After 1 sec, you have 0.078s left on your GCD. You gain a stack of VF. Only the remaining 0.078s is adjusted, reducing that part to 0.077s. Could that make your following ability clip the MF tick? Ehhhh... I'm not in the game right now to try that specifically, but I doubt it. I don't think it's quite that precise when it comes to gaining and losing buffs/debuffs."
	
	
	
	--self.modelloaded=false

	self.animation=nil	
end

function TRAININGGROUNDS_Mobile:IsPlayerControlled()
	--TODO: scenario.currentplayer apparently no longer used
	--TODO:	this will need to be changed eventually
	local currentplayer=self.environment.game.scenario.controls.player
	--print("IsPlayerControlled",currentplayer)
	return(self==currentplayer)
end

function TRAININGGROUNDS_Mobile:CreateAI()
	self.ai=TRAININGGROUNDS_AI.new()
	self.ai:Setup(self,environment)
end

function TRAININGGROUNDS_Mobile:CreatePersonalDanceModule()
	self.dancemodule=TRAININGGROUNDS_PersonalDanceModule.new()
	self.dancemodule:Setup(self)
end

--TODO: isolate setup from function?
function TRAININGGROUNDS_Mobile:CreateCombatModule()
	self.combat=TRAININGGROUNDS_CombatModule.new()
	self.combat:Setup(self)
end


function TRAININGGROUNDS_Mobile:SetDrawable()
	self.drawable=TRAININGGROUNDS_Drawable_CharacterModel.new()
	self.drawable:Setup(self,self.environment)
end

function TRAININGGROUNDS_Mobile:CreateAssociatedObjects()
	--TODO: move shadow to CreateShadow function so we can have debugclickboxes on objects without shadows
	self.shadow=TRAININGGROUNDS_Shadow:new()
	self.shadow:Setup(self.environment,self)
	
	if(TRAININGGROUNDS_DEBUG.showclickboxes)then
		self.clickbox=TRAININGGROUNDS_DebugClickbox:new()
		self.clickbox:Setup(self.environment,self)
	end
end


function TRAININGGROUNDS_Mobile:SetupEnvironmentObjectListIndexStorage(environment)
	TRAININGGROUNDS_GameObject.SetupEnvironmentObjectListIndexStorage(self,environment)
	tinsert(self.environmentobjectlists,self.environment.mobiles)
end

function TRAININGGROUNDS_Mobile:IncrementTime(elapsed)
	TRAININGGROUNDS_GameObject.IncrementTime(self,elapsed)
	self.combat:IncrementTime(elapsed)
end



function TRAININGGROUNDS_Mobile:AI(elapsed)	
	if(self.ai)then
		self.ai:Step(elapsed)
	end
	-- at the moment, self.ai is not optional -- we reference it in PreMove
end


--TODO: rename PreMove to ResolveInputs
function TRAININGGROUNDS_Mobile:PreMove(elapsed)
	--TODO: since this is AI behavior, should it go in Step instead of PreMove?
	TRAININGGROUNDS_GameObject.PreMove(self,elapsed)
	
	local grips=self.combat.auramodule.grip
	if(#grips>0)then
		--TODO: one grip only.  if more than one grip is ever applied, kill the existing grips
		local grip=grips[1]
		grip:MoveMobile(elapsed)
	end
	
	
	local vx=self.ai.moveinputvector.x
	local vy=self.ai.moveinputvector.y
	
	local unitvectorx=0
	local unitvectory=0
	local movespeed
	--setting movespeed now, but can be overridden later during specialmovement check
	movespeed=self:GetFinalMoveSpeed()
	
	
	-- if(self:IsPlayerControlled())then
		-- print("Player movespeed:",movespeed)
	-- end
	
	--TODO: "for i=..., ..., 1 do" can be replaced with "for i=..., ... do"
	
	--TODO: handle this better
	--(ideally the player should never have more than 1 specialmovement aura at a time)
	local forcedmovementauras=self.combat.auramodule.forcedmovement
	if(#forcedmovementauras>0)then
		local vectorx,vectory=0,0
		local forcedspeed=0		
		for i=1,#forcedmovementauras do
			local vectorx2,vectory2=forcedmovementauras[i]:GetForcedMovementVector()
			local fs=forcedmovementauras[i]:GetForcedMovementSpeed()
			if(fs>forcedspeed)then forcedspeed=fs end
			vectorx=vectorx+vectorx2
			vectory=vectory+vectory2
			--print("Forced movement:",vectorx2,vectory2)
		end
		movespeed=forcedspeed
		vx=vectorx
		vy=vectory
	end
	
	if(vx~=0 or vy~=0)then
		local dist=math.sqrt(vx*vx+vy*vy)
		unitvectorx=vx/dist
		unitvectory=vy/dist
	end
		
	-- local DEBUG=0
	-- if(self:Class()==TRAININGGROUNDS_VARIMATHRAS_Mobile_Varimathras)then DEBUG=1 end		
	-- if(DEBUG==1)then print("Unitvector:",unitvectorx,unitvectory) end
		
	--TODO: in addition to checking if self.z<=0, check self.zspeed<=0
	if(unitvectorx==0 and unitvectory==0 and self.z<=0)then
		self.xspeed=0
		self.yspeed=0
		self.targetfacing_movement=nil
		--TODO: with aura system, no longer necessary to zero turnspeed every frame -- but rename to movement_turnspeed or something
		self:SetTurnspeed(5)
	elseif(unitvectorx~=0 or unitvectory~=0)then		
		if(self.z<=0)then
			self.xspeed=unitvectorx*movespeed
			self.yspeed=unitvectory*movespeed		
		end
		
		local targetfacing=math.atan2(unitvectory,unitvectorx)
		--TODO: with aura system, no longer necessary to zero turnspeed every frame -- but rename to movement_turnspeed or something
		self:SetTurnspeed(5)
		

		self.targetfacing_movement=targetfacing
		
		--self:TurnAtSpeed(targetfacing,elapsed,turnspeed)		
	end
	
	
	self:PickTargetFacingThenTurn(elapsed)
end

function TRAININGGROUNDS_Mobile:Move(elapsed)
	TRAININGGROUNDS_GameObject.Move(self,elapsed)
	local vacuums=self.combat.auramodule.vacuum
	for i=1,#vacuums do		
		local vacuum=vacuums[i]
		--print("Vacuum",vacuum)
		vacuum:MoveMobiles(elapsed)
	end
end

function TRAININGGROUNDS_Mobile:SetTurnspeed(speed)
	if(speed>self.turnspeed)then self.turnspeed=speed end
end

function TRAININGGROUNDS_Mobile:PickTargetFacingThenTurn(elapsed)
	--TODO: special movement techniques should have higher priority than combat
	--TODO: when attacking, snap targetfacing to target and keep it there for awhile after the attack ends.
			-- do we want to do that in mobile, combat, spell, or aura?
	--TODO: this function isn't so good as written either
	
	--TODO NEXT: write more comments before we forget what all this does
	
	--local DEBUG=0
	--if(self:Class()==TRAININGGROUNDS_VARIMATHRAS_Mobile_Varimathras)then DEBUG=1 end
	
	local newfacing=self.currentfacing
	local facing_telegraphs=self.combat.auramodule.facing_telegraph
	if(#facing_telegraphs>0)then
		-- use only the most recently applied telegraph
		local aura=facing_telegraphs[#facing_telegraphs]
		local targetfacing=aura:GetTargetFacing()
		local turnspeed=aura:GetTurnSpeed()
		newfacing=self:GetNewFacingTurnAtSpeed(targetfacing,elapsed,self.turnspeed)
		--if(DEBUG==1)then print("Facing telegraph:",newfacing)end
		-- if there was a telegraph, use that and skip the other auras
	else	
		-- if we're here, then there wasn't a telegraph
		local targetfacing_movement=self.targetfacing_movement
		local newfacing_movement=nil
		if(targetfacing_movement)then
			--TODO: option for player to turn on followthrough movement facing for their own character?
			if(not self:IsPlayerControlled())then
				self.projectedmovementfacing=targetfacing_movement
				--if(DEBUG==1)then print("Projected movement facing:",self.projectedmovementfacing) end
				--but if targetfacing_movement is nil, projectedmovementfacing remains unchanged
			end
		end
		
		
		----TODO: handle spellcasting facing differently?
		--if(self.targetfacing_spellcast)then targetfacing=self.targetfacing_spellcast end
		if(targetfacing_movement or self.projectedmovementfacing)then						
			--TODO: does the "X = X OR Y" pattern work in Lua?
			local todo_rename_this=targetfacing_movement
			if(not todo_rename_this)then todo_rename_this=self.projectedmovementfacing end
			--if(DEBUG==1)then print("todo_rename_this:",todo_rename_this) end
			newfacing_movement = self:GetNewFacingTurnAtSpeed(todo_rename_this,elapsed,self.turnspeed)
			--if(DEBUG==1)then print("newfacing_movement:",newfacing_movement) end
			--newfacing_movement = self:GetNewFacingTurnAtSpeed(targetfacing_movement,elapsed,5)
		end
	
		local maxdiff=0
		local diff=0
		if(newfacing_movement)then
			diff=math.abs(self.currentfacing-newfacing_movement)
			if(diff>math.pi)then diff=diff-math.pi*2 end
			diff=math.abs(diff)
		end
		maxdiff=diff
	
		local facings=self.combat.auramodule.facing
		local maxtargetfacing=newfacing_movement
		local maxtargetturnspeed=nil
		----we're giving up on pick-most-influential-facing-from-all-facings for now because it makes the character flip back and forth
		--for i=1,#facings do
		if(#facings>0)then
			local aura=facings[#facings]		-- instead just use the most recent facing
			local targetfacing_aura=aura:GetTargetFacing()
			--TODO: if GetTargetFacing returns nil, skip to next aura
			
			--if(DEBUG==1)then print("targetfacing_aura:",targetfacing_aura)end 
			local turnspeed=aura:GetTurnSpeed()	
			
			--REDO: rename turnstrength to turnweight
			local weight2=aura:GetTurnStrength()	
			newfacing_aura=self:GetNewFacingTurnAtSpeed(targetfacing_aura,elapsed,turnspeed)			
			
			if(newfacing_movement)then				
				newfacing_aura=self:GetCombinedAngles(newfacing_movement,newfacing_aura,weight2)			
			end
			diff=math.abs(self.currentfacing-newfacing_aura)
			if(diff>math.pi)then diff=diff-math.pi*2 end
			diff=math.abs(diff)
			--if(diff>maxdiff)then
			if(true)then
				maxdiff=diff
				maxtargetfacing=newfacing_aura
				maxtargetturnspeed=turnspeed
			end	
		end
		
		if(maxtargetfacing)then
			newfacing=maxtargetfacing			
		end
		
		--TODO: this is PROBABLY safe to do as we're copying one floating point directly onto another.  but maybe verify that
		if(self.projectedmovementfacing==newfacing)then
			self.projectedmovementfacing=nil
		end
	
	end
	
	
	
	--if(DEBUG==1)then print("Newfacing:",newfacing)end 
	
	self:SetAdjustedFacing(newfacing)	
	
	--then reset turnspeed for the next frame
		--TODO: does this do anything?
	self.turnspeed=0
end


-- function TRAININGGROUNDS_Mobile:PostMove(elapsed)
	-- if(self.shadow)then
		-- self.shadow.x=self.x
		-- self.shadow.y=self.y
	-- end
-- end

function TRAININGGROUNDS_Mobile:GetCombinedAngles(angle1,angle2,weight2)
	--Weighted circular mean
	--SOURCE: stackoverflow.com/questions/491738/how-do-you-calculate-the-average-of-a-set-of-circular-data
	local x=0
	local y=0
	x=(1-weight2)*math.cos(angle1) + (weight2)*math.cos(angle2)
	y=(1-weight2)*math.sin(angle1) + (weight2)*math.sin(angle2)
	return math.atan2(y,x)
end

function TRAININGGROUNDS_Mobile:CombatPhase_CollisionCheck_VoidZone(elapsed)
	--TODO: compare mobile+voidzone factions
	--TODO: only check if mobile or voidzone changed position
	
	for i=1,#self.environment.voidzones,1 do
		self.environment.voidzones[i]:CollisionCheck(self)
	end
	
	-- --TODO: move somewhere else (must take place after collisioncheck)
	-- self.xprev=self.x
	-- self.yprev=self.y
end

function TRAININGGROUNDS_Mobile:CombatPhase(elapsed)
	--TODO: split combat into multiple phases
	if(self.combat)then				
		self.combat:Step(elapsed)
		self.combat.auramodule:Step(elapsed)
		self.combat.auramodule:CheckAuraExpiry()
		self.combat.auramodule:RemoveDyingAuras()
	end
end

function TRAININGGROUNDS_Mobile:PreDraw(elapsed)
	-- don't call super.PreDraw until we check movement
	
	--TODO: handle this better
	local visual_modellighting=self.combat.auramodule.visual_modellighting
	if(#visual_modellighting>0)then
		--TODO: handle more than one effect present at a time
		-- need to store AA+AR+AB+AG somewhere before passing to setlighting
		-- also, lighting doesn't quite work how we remembered anyway		

		-- dubious: we automatically use [1] instead of combining them properly
		self.drawable:SetLighting(visual_modellighting[1]:GetLighting())
	end
	
	local alpha=1.0
	
	local irrelevants=self.combat.auramodule.irrelevant
	local relevants=self.combat.auramodule.relevant
	local relevant=true
	if(#irrelevants>0 and #relevants==0)then
		relevant=false
	end	
	if(not relevant)then
		--TODO: fade in gradually
		--TODO: don't set alpha directly; set an alpha multiplier instead		
		--TODO: const instead of magic number
		--alpha=0.125
		alpha=0.25
		--alpha=0.5		--0.5 not recommended; characters are still very noticeable
		--! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
		-- BUGGY SHADOWS
		if(self.shadow)then
			self.shadow.visible=false
		end
	else
		--TODO: don't set alpha directly; set an alpha multiplier instead
		
		-- self.drawable:SetAlpha(1)
		--alpha=1.0
		--! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
		-- BUGGY SHADOWS
		if(self.shadow)then
			self.shadow.visible=true
		end		
		
		--TODO: adapt this loop to modellighting somehow
		--TODO: modelalpha auras haven't been tested yet
		alpha=1.0
		local visual_modelalpha=self.combat.auramodule.visual_modelalpha
		if(#visual_modelalpha>0)then
			for i=1,#visual_modelalpha do
				alpha=alpha*visual_modelalpha[i]:GetAlpha()
			end
		end		
	end
	--TODO: make sure SetAlpha works for Sprite as well (here we're calling it on CharacterModel)
	self.drawable:SetAlpha(alpha)
	
	
	-- self.ai.targetlocation may have changed
	--TODO: move to animate event
	if(not self.ai.targetlocation)then
		--TODO: due to the way our current priority system works, we don't need to reassign Stand every frame
			-- (but we very well might want to assign Run_Followthrough every frame as stutter-step prevention)
		self.drawable:SetAnimation(TRAININGGROUNDS_ANIMATION_LIST.Stand)
	else
		--TODO: move animation to Animate event
		--TODO LATER: compare obj speed to target's speed when deciding whether to followthrough
		-- also, run/sprint/followthrough logic is kinda messy.  weirdest-case scenario, we'll access this table ["via concatenated strings"]
				--TODO: probably don't use concatenated strings here
		-- if(self:IsPlayerControlled())then
			-- self.drawable:SetAnimation(TRAININGGROUNDS_ANIMATION_LIST.Run)
		-- else 
			-- self.drawable:SetAnimation(TRAININGGROUNDS_ANIMATION_LIST.Run_FollowThrough)
		-- end
		local animname="Run"
		--TODO: cache movespeed
		if(self:GetFinalMoveSpeed()>200*1.4)then
			animname="SPRINT"
		end
		if(not self:IsPlayerControlled())then
			animname=animname.."_FollowThrough"
		end
		self.drawable:SetAnimation(TRAININGGROUNDS_ANIMATION_LIST[animname])
		
		--self.drawable:SetNewAnimation(0)
	end
	
	local animations=self.combat.auramodule.animation
	for i=1,#animations do
		local animationaura=animations[i]
		self.drawable:SetAnimation(animationaura.animation)
		--print("Setting animation ",animationaura.animation)
	end	
	
	
	-- NOW call super.predraw
	TRAININGGROUNDS_GameObject.PreDraw(self,elapsed)
end


-- Function should (eventually) account for all speed modifiers, snares, roots, etc.
function TRAININGGROUNDS_Mobile:GetFinalMoveSpeed()
	--TODO:
	--return 200
	
	local additivepercent=0
	local strongestsnare=1.0
	local speedboosts=self.combat.auramodule.speedboost
	local snares=self.combat.auramodule.snare
	
	-- if(self:IsPlayerControlled())then
		-- print("Speedboost auras:",#speedboosts)
	-- end
	
	for i=1,#speedboosts do
		local speedboost=speedboosts[i]
		local pct=speedboost:GetPercent()
		if(pct>additivepercent)then
			additivepercent=pct
		end
	end
	
	for i=1,#snares do
		local snare=snares[i]
		local pct=snare:GetPercent()
		if(pct<strongestsnare)then
			strongestsnare=pct
		end
	end	
	
	
	local finalspeed=self.basemovespeed*(1+additivepercent)*strongestsnare
	
	return finalspeed
end

--static function
--TODO: move to Environment, probably
-- (also this could probably be a const float multiplier instead of a function)
function TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(yards)
	-- TRAININGGROUNDS run speed is 200 units per second
	-- As of 2018/04/19, run speed is 7 yards per second (you can check this with GetUnitSpeed("player")).
	-- Walk speed is currently 2.5 yards.
	return yards*(200.0 / 7.0)
	-- note that melee range is implemented as only 3.5 yards, not 5 yards
end
function TRAININGGROUNDS_Mobile_ConvertTGUnitsToYards(yards)
	return yards*(7.0 / 200.0)
end


TRAININGGROUNDS_Mobile_StandardHitboxRadius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1.5)

--TODO: merge with PickTargetFacingThenTurn, which is the only function that should call this one
function TRAININGGROUNDS_Mobile:GetNewFacingTurnAtSpeed(targetfacing,elapsed,turnspeed)
	
	local difference=targetfacing-self.currentfacing;
	
	if(difference<-math.pi) then difference=difference+math.pi*2 end
	if(difference>math.pi) then difference=difference-math.pi*2 end
	
	local facingchange=0;
	
	if(difference>0)then facingchange=turnspeed*elapsed end
	if(difference<0)then facingchange=-turnspeed*elapsed end

	if(math.abs(math.abs(difference)-math.pi)<turnspeed*elapsed) then
		if(math.random()>.5)then
			facingchange=-facingchange
		end
	end
	
	local newfacing=self.currentfacing+facingchange
	
	if(math.abs(difference)<turnspeed*elapsed*2) then
		newfacing=targetfacing
	end	
	
	if(newfacing<-math.pi) then newfacing=newfacing+math.pi*2 end
	if(newfacing>math.pi) then newfacing=newfacing-math.pi*2 end	
	
	--self:SetAdjustedFacing(newfacing)	
	return newfacing
end


function TRAININGGROUNDS_Mobile:SetAdjustedFacing(facing)
	self.currentfacing=facing
	local adjustedfacing=facing
	local camera=self.environment.camera
	if(camera~=nil)then
		----TODO: this is no longer used, but we do need to talk to camera at some point
		--local xx=math.cos(facing)
		--local yy=math.sin(facing)		
		
		----multiplying xx by ystretch because we're using WoWradians
		--adjustedfacing=math.atan2(yy,xx*camera.ystretch)	
	end	
	--self.modelframe:SetFacing(adjustedfacing)
end


function TRAININGGROUNDS_Mobile:Select(state)
	-- --TODO: ResuableFrames function to force the creation of a new frame with a specific name
		-- -- (which will hopefully show up in /framestack as that name)

	self.selected=state
	if(self.shadow)then
		local r,g,b=1,1,1 --TODO: proper targetingcircle color
		self.shadow:Select(state,r,g,b)
	end
end


function TRAININGGROUNDS_Mobile:TargetCombatModule(cmb)
	self.combat.targetcombat=cmb
end




function TRAININGGROUNDS_Mobile:GetSpellDistanceToMobile(targetmobile,spell)
	-- Function returns the distance between center of this mobile
	-- and edge of targetmobile's hitbox.

	--TODO: formula for spelldistance and formula for AI:meleetargetlocation should probably be in the same file and/or code reuse
	local xdist=(self.x-targetmobile.x)
	local ydist=(self.y-targetmobile.y)
	
	local dist = math.sqrt(xdist*xdist+ydist*ydist)-targetmobile.hitboxradius
	if(spell.melee)then dist=dist-self.hitboxradius end
	
	return dist
end


function TRAININGGROUNDS_Mobile:Cleanup()
	TRAININGGROUNDS_GameObject.Cleanup(self)
	if(self.shadow)then
		self.shadow:Die()
	end
end