
-- Shadow doubles as targeting circle.
-- TODO LATER: maybe have targeting circle as separate object, if we find a way to make it not look terrible

-- Resize shadow by changing width only; height is ignored and automatically set during SetFrameSizeAndOrientation based on camera

TRAININGGROUNDS_Shadow = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)

function TRAININGGROUNDS_Shadow:Setup(environment,owner)
	self.owner=owner
	TRAININGGROUNDS_GameObject.Setup(self,environment)

end

function TRAININGGROUNDS_Shadow:SetCustomInfo()
	TRAININGGROUNDS_GameObject.SetCustomInfo(self)
	self.visible=true
end

function TRAININGGROUNDS_Shadow:SetDrawable()
	-- Shadow MUST use Drawable_Sprite_Shadow (or any other drawable with the Select function, if one exists)
	self.drawable=TRAININGGROUNDS_Drawable_Sprite_Shadow.new()
	self.drawable:Setup(self,self.environment)
	--self.drawable.visible=true	-- commented; this should already be true by default (and it should be "self.visible" regardless)
	self.width=100
	self.height=100
	if(self.owner.drawable.modelinfo)then
		self.drawable.width=self.owner.drawable.modelinfo.shadowsize
		self.drawable.height=self.owner.drawable.modelinfo.shadowsize
	end	
end

function TRAININGGROUNDS_Shadow:PostMove(elapsed)
	TRAININGGROUNDS_GameObject.PostMove(self,elapsed)
	self.x=self.owner.x;self.y=self.owner.y
	self.currentfacing=self.owner.currentfacing
	--print(self.x,self.y)

end


function TRAININGGROUNDS_Shadow:Select(state,r,g,b)
	self.drawable:Select(state,r,g,b)
end