

TRAININGGROUNDS_GameObject = {}
TRAININGGROUNDS_GameObject.__index = TRAININGGROUNDS_GameObject


function TRAININGGROUNDS_GameObject.new()
	local self=setmetatable({}, TRAININGGROUNDS_GameObject)	
	return self
end

local  _TRAININGGROUNDS_GameObject_NextObjectID=0
local function _TRAININGGROUNDS_GameObject_GetNextObjectIDAndIncrement()
	_TRAININGGROUNDS_GameObject_NextObjectID=_TRAININGGROUNDS_GameObject_NextObjectID+1
	return _TRAININGGROUNDS_GameObject_NextObjectID	
end

function TRAININGGROUNDS_GameObject:Setup(environment)
	
	self.environment=environment
	
	self.id=_TRAININGGROUNDS_GameObject_GetNextObjectIDAndIncrement()
	
	-- self.visible (set in SetCustomInfo) determines whether the frame SHOULD BE visible
	-- self.frameisvisible tracks whether the frame IS visible
	-- it is not guaranteed that frame exists
	--TODO: is this used?
	self.frameisvisible=false
	
	self:SetCustomInfo()	
	self:SetDrawable()
	
	
	self:SetWidthAndHeight()
	
	--print("GameObject:Setup")
	-- default gameobject has no appearance, but we set it up so it'll be visible as soon as a frame is added
	
	--TODO: we recently changed parentframe so only drawable has that property; probably broke something
	
	-- self:SetFrame()
	-- self:SetAppearance()
	-- self:SetFrameSize()
	
	
	self.ismouseovered=false
	
	self.localtime=0
	
	self.dying=false	-- will be removed at the end of the frame
	self.dead=false		-- removed from gameplay; any object still referencing this one should clear the reference
	
	self.deadingame=false	-- actually "dead"; 0 HP and corpse
	

	-- if(self.frame~=nil) then
		-- --TODO: set frame level
		-- self.frame:SetParent(self.parentframe)
		-- self:SetDefaultFrameLevel()
		-- --print("GameObject:setup "..tostring(self.parentframe))
		-- if(self.clickable==true)then
			-- self.clickframe=TRAININGGROUNDS_ReusableFrames:GetFrame()
			-- self.clickframe:SetParent(self.frame)
			-- self:SetDebugVisibleClickareaFrame()
		-- end
	-- end
	
	--if(self.visible==true) then
		--self:PreDraw()
		--self:Draw()
	--end
	
	
	self:SetupEnvironmentObjectListIndexStorage(environmnet)
	
	-- create shadows, lifebars, etc here
	self:CreateAssociatedObjects()
	self:CreateDebugClickboxes()
	
	tinsert(environment.newgameobjects,self)
end

function TRAININGGROUNDS_GameObject:GetName()
	--override, don't call super
	return "GameObject "..tostring(self.id)
end

function TRAININGGROUNDS_GameObject:SetWidthAndHeight()
	if(self.drawable)then
		if(self.drawable.modelinfo)then
			self.drawable.width=self.drawable.modelinfo.size
			self.drawable.height=self.drawable.modelinfo.size
		end
	end
end

function TRAININGGROUNDS_GameObject:SetupEnvironmentObjectListIndexStorage(environment)
	--override, call super when overriding
	
	-- List of environment objectlists relevant to this object (gameobjects, wowobjects, particles, etc)
	self.environmentobjectlists={}
	tinsert(self.environmentobjectlists,self.environment.gameobjects)
	
	-- Objects are transferred from newgameobject list to currentobject lists by Environment at end of frame
	-- 			(next function)	
	-- Objects are removed from currentobject lists by Environment at end of frame
end


function TRAININGGROUNDS_GameObject:TransferFromEnvironmentNewobjectLists(environment)
	for i=1,#self.environmentobjectlists,1 do
		tinsert(self.environmentobjectlists[i],self)
	end
end 




function TRAININGGROUNDS_GameObject:SetCustomInfo()
	-- override as necessary
	-- call super when overriding
	self.visible=true
		
	--print("TRAININGGROUNDS_GameObject:SetCustomInfo()")
	
	self.x=0
	self.y=0
	self.z=0
	-- used for displaying clickboxes and stacked resource bars, screenyoffset is affected by camera zoom but not camera angle.
	-- (TODO: but should clickarea.y be affected by camera angle?)
	-- TODO: rename clickarea to clickbox everywhere?
	-- TODO: move to drawable?
	self.screenyoffset=0
	
	-- Default width and height are set here but may be overridden after setting drawable
	self.width=100
	self.height=100
	self.xspeed=0
	self.yspeed=0
	self.zspeed=0
	self.gravity=0
	self.xaccel=0
	self.yaccel=0
	self.expirytime=nil
	
	-- self.clickarea={}
	-- self.clickarea.x=0
	-- self.clickarea.y=0
	-- self.clickarea.width=self.width
	-- self.clickarea.height=self.height
	
	-- -- some of these can be overridden via SetAppearance
	-- -- we initialize them here so they don't have to be explicitly mentioned in SetAppearance
	-- -- (which usually doesn't call child function when overridden)
	-- self.alignment="CENTER"
	
	-- TODO: visible is not yet implemented anywhere except during setup
	self.visible=true
	
	self.ysortable=false
	
	self.defaulthp=nil
	
end



-- function TRAININGGROUNDS_GameObject:SetDebugVisibleClickareaFrame()
	-- -- This controls the visible clickframe only
	-- -- ...the actual dimensions are controlled by SetClickarea/SetClickability
	-- if(self.clickable and self.clickframe and TRAININGGROUNDS_DEBUG.showclickboxes) then
		-- local camera=self.environment.camera
		-- --don't apply resolutioncorrection to clickframe size
			-- --TODO LATER: old comment; verify
		-- --local resolutioncorrection=((GetScreenWidth()/GetScreenHeight())/(800.0/600.0))   --/self.parentframe:GetScale()

		-- self.clickframe:SetParent(self.frame)
		
		-- self.clickframe:Show()
		-- self.clickframe.texture:SetColorTexture(1,1,1,.5)			
		-- self.clickframe.texture:Show()
		
		-- -- TODO LATER: adjustedzoom originally had more vars than camera.zoom; remove if no longer needed
		-- local adjustedzoom=camera.zoom
		-- self.clickframe:SetPoint("BOTTOM",self.frame,"BOTTOM",(self.clickarea.x)*adjustedzoom,(self.clickarea.y)*adjustedzoom)
		
		-- local width=self.clickarea.width*adjustedzoom
		-- local height=self.clickarea.height*adjustedzoom
		
		-- self.clickframe:SetWidth(width)
		-- self.clickframe:SetHeight(height)	
		-- self.clickframe:SetFrameLevel(255)
	-- end
-- end



-- -- if a GameObject uses a frame (and not all of them do), create it here
-- function TRAININGGROUNDS_GameObject:SetFrame()
	-- -- override as necessary
	-- -- beware when calling child functions; frames don't like being set twice
	
	-- self.frame=nil	
-- end

-- -- Adjust the frame's appearance here
-- function TRAININGGROUNDS_GameObject:SetAppearance()
	-- -- override as necessary
	-- -- beware when calling child functions; modelframes don't like being set twice
	
	-- self.appearance=nil
-- end

-- function TRAININGGROUNDS_GameObject:SetFrameSize()
	-- -- override as necessary
	-- -- beware when calling child functions; frames don't like being set twice
	
-- end

-- function TRAININGGROUNDS_GameObject:SetDefaultFrameLevel()
	-- if(self.frame)then
		-- self.frame:SetFrameLevel(1)
	-- end
-- end

function TRAININGGROUNDS_GameObject:SetTurnspeed(speed)
	--override
		--(mobile uses this)
end

function TRAININGGROUNDS_GameObject:PickTargetFacingThenTurn()
	--override
		--(mobile uses this)
end

function TRAININGGROUNDS_GameObject:SetDrawable()
	--override; don't call super while overriding
	self.drawable=TRAININGGROUNDS_Drawable_Sprite.new()
	self.drawable:Setup(self,self.environment)
end

-- Any other objects to be closely associated with this object, such as shadows and health bars, go here.
-- One exception is DebugClickbox, which is setup during the CreateDebugClickboxes function instead.
function TRAININGGROUNDS_GameObject:CreateAssociatedObjects()
	--override; don't call super while overriding
end

function TRAININGGROUNDS_GameObject:CreateDebugClickboxes()
	if(self.clickable and self.clickarea and TRAININGGROUNDS_DEBUG.showclickboxes) then		
		local clickbox=TRAININGGROUNDS_DebugClickbox.new()
		clickbox:Setup(self.environment,self)	
	end
end

function TRAININGGROUNDS_GameObject:GetPlayerInput(elapsed)
	-- override
end

function TRAININGGROUNDS_GameObject:AI(elapsed)
	-- override
end


function TRAININGGROUNDS_GameObject:IncrementTime(elapsed)
	--override, call super
	self.localtime=self.localtime+elapsed	
end

function TRAININGGROUNDS_GameObject:Step(elapsed)
	-- override, call super
	--TODO: check all the gameobjects to make sure we didn't forget to call super
	
	
	if(self.drawable)then
		self.drawable:Step(elapsed)
	end
	
	if(self.expirytime)then
		--print("expiry",self.expirytime,self.environment.localtime)
		if(self.environment.localtime>=self.expirytime)then
			--TODO: probably more complicated than this
			self:OnExpiry(self.expirytime)
			self:Die()
		end
	end
end

function TRAININGGROUNDS_GameObject:PreMove(elapsed)
	
end

function TRAININGGROUNDS_GameObject:Move(elapsed)	
	self.x=self.x+self.xspeed*elapsed
	self.y=self.y+self.yspeed*elapsed
	self.z=self.z+self.zspeed*elapsed
	-- if(self.zspeed~=0)then
		-- print("zspeed:",self.zspeed,"z:",self.z)
	-- end
	
	--TODO: gravity is nondeterministic
	self.zspeed=self.zspeed+self.gravity*elapsed
	if(self.z<=0)then
		--TODO: ringout
		self.zspeed=0
		self.z=0
	end
end

function TRAININGGROUNDS_GameObject:PostMove(elapsed)
	
end

function TRAININGGROUNDS_GameObject:CombatPhase(elapsed)
	
end


function TRAININGGROUNDS_GameObject:PreDraw(elapsed)
	if(self.drawable)then
		self.drawable:PreDraw(elapsed)
		self.drawable.visible=self.visible
		-- if(self.drawable.frame.name=="TRAININGGROUNDS_ReusableFrame62")then
			-- print("frame62 visibility is",self.drawable.visible)
		-- end
		self.drawable.x=self.x
		self.drawable.y=self.y
		self.drawable.z=self.z
	end


	-- if(self.frame)then
		-- if(self.visible)then			
			-- self.frame:Show()
			-- local point=self.environment.cameraobjectanchor
			-- local origin=self.environment.cameraorigin
			-- --self.frame:SetPoint(point,self.parentframe,origin,self.x,self.y)
			-- --print(point,self.parentframe,origin,self.x,self.y)			
		-- else
			-- self.frame:Hide()
		-- end
	-- end
	-- if(self.frame~=nil)then
		-- if(self.visible==false and self.frameisvisible==true)then
			-- self.frame:Hide()
			-- self.frameisvisible=false
		-- elseif(self.visible==true and self.frameisvisible==false)then
			-- self.frame:Show()
			-- self.frameisvisible=true
		-- end
	-- end
end

function TRAININGGROUNDS_GameObject:Draw()
	
	-- if(self.frame~=nil)then
		-- local x,y=self.environment.camera:SetGameObjectFrameLocation(self)
	
		-- local x,y = self.environment.camera:GetGameObjectCoordinates(self)
		
		-- local x,y,width,height=self.environment.camera:ConvertRectangleCoordinates(self.x,self.y,self.width,self.height)
		-- --print(x,y)
	-- end
end  

--TODO: properly initialize this so we don't have to resort to location[1], [2], [3] etc
--TODO: undecided whether this is properly called Location or Position
function TRAININGGROUNDS_GameObject:GetLocation()	
	return {self.x,self.y,self.z}
end

--TODO: sync gameobject.localtime with combat.localtime
function TRAININGGROUNDS_GameObject:GetLocalTime()
	return self.localtime
end

function TRAININGGROUNDS_GameObject:ResetModelAfterGraphicsChange()
	-- override
end

function TRAININGGROUNDS_GameObject:FatalErrorObjectNotDeadAfterCleanup()
	print("WARNING: object",self,"not labeled dead after cleanup")
	error("Object not labeled dead after cleanup")
end

function TRAININGGROUNDS_GameObject:OnExpiry(expirytime)
	-- override
end

function TRAININGGROUNDS_GameObject:Die()
	self.dying=true
end

function TRAININGGROUNDS_GameObject:Cleanup()
	self.dead=true	
	
	if(self.drawable)then
		self.drawable:Cleanup()
	end
	
	if(self.clickframe)then
		self.clickframe:Cleanup()
	end
end

function TRAININGGROUNDS_GameObject:FatalErrorObjNotDeadAfterCleanup()
	error("ERROR: object not properly flagged as dead after calling Cleanup")
end


------------------------------------------------------------------
------------------------------------------------------------------
------------------------------------------------------------------
------------------------------------------------------------------
------------------------------------------------------------------


TRAININGGROUNDS_GameObject_BlueSquare = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_GameObject)
function TRAININGGROUNDS_GameObject_BlueSquare:SetFrame()
	TRAININGGROUNDS_GameObject.SetFrame(self)
	self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
end

function TRAININGGROUNDS_GameObject_BlueSquare:SetAppearance()
	TRAININGGROUNDS_GameObject.SetAppearance(self)
	
	--self.frame.texture:SetColorTexture(0,1,1,1)
	
	self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\targetingcircle.tga")
	--self.frame.texture:SetGradientAlpha("HORIZONTAL",1,0,0,1.0,1,0,0,1.0);	--red
	self.frame.texture:SetGradientAlpha("HORIZONTAL",0,0,1,1.0,0,0,1,1.0);		--blue
	self.frame.texture:Show()
end









