--TODO LATER: work out how to handle character model scaling with screen dimensions -- 
--			-- breaks whenever screen is resized while game is running
			-- cvar windowResizeLock works, but doesn't prevent maximizing screen
			-- monitoring framerate might work
			-- note that vanilla dress preview window doesn't have problems with resizing the window


--TODO: modelframes are not respecting scrollframe; make sure parent heirarchy is correct
		-- "environment_modeleditor" 1st of several models respects visibility, others break.  related?
		-- check if FrameLevel is the culprit
--TODO: frame+modelframe must be visible in order to set appearance, but that could cause problems on first frame if object is supposed to be invisible.  use alpha=0 for invisibility instead?

--TODO: standardize all uses of "parent" vs "parentframe"
--TODO: decide whether we want GameObject to have a frame by default

SetScreenResolution_old = SetScreenResolution
SetScreenResolution=function(index)
	--TODO LATER: do something when we detect screen resolution was changed
	SetScreenResolution_old(index)
end



TRAININGGROUNDS_Game = {}
TRAININGGROUNDS_Game.__index = TRAININGGROUNDS_Game

function TRAININGGROUNDS_Game.new()
	local self=setmetatable({}, TRAININGGROUNDS_Game)	
	return self
end

function TRAININGGROUNDS_Game:Setup(traininggrounds)
	local TITLEHEIGHT=20
	
	local titletext="TrainingGrounds 2018-05-07: Mythic Aggramar Phase 3"
	
	self.traininggrounds=traininggrounds
	
	TRAININGGROUNDS_PlayerCharacter.SetupCanPlayerDW()
	TRAININGGROUNDS_Class.SetupClasses()
	
	self.window=TRAININGGROUNDS_DraggableGameWindow.new()
	--self.window:Setup(self,traininggrounds,640,480,titletext,nil,true,function()traininggrounds:Shutdown() end)
	--self.window:Setup(self,traininggrounds,512,512,titletext,nil,true,function()traininggrounds:Shutdown() end)
	--self.window:Setup(self,traininggrounds,1200,480,titletext,nil,true,function()traininggrounds:Shutdown() end)
	--self.window:Setup(self,traininggrounds,640,480,titletext,nil,true,function()traininggrounds:Shutdown() end)
	--self.window:Setup(self,traininggrounds,1024,576,titletext,nil,true,function()traininggrounds:Shutdown() end)
	self.window:Setup(self,traininggrounds,1024,576,titletext,nil,true,function()traininggrounds:Shutdown() end)
	
	
	
	self.hotbarwindow=TRAININGGROUNDS_DraggableGameWindow.new()
	self.hotbarwindow:Setup(self,traininggrounds,1200,100,"",nil,false)
	self.hotbarwindow.background:ClearAllPoints()
	--self.hotbarwindow.background:SetPoint("TOP",self.hotbarwindow.background.parent,"TOP",0,-480-100)
	self.hotbarwindow.background:SetPoint("TOP",UIParent,"CENTER",0,-240)
	
	
	self.rawinput=TRAININGGROUNDS_RawInput.new()
	self.keys=TRAININGGROUNDS_Keys.new()
	self.keys:Setup(self.rawinput)
	
	
	self.environments={}
	
	
	


	
	
	-- realtime is only used for non-gameplay functions such as mouse highlight scanning
	-- reminder: GetTime is measured in SECONDS, not milliseconds
	self.realtime=GetTime()
	-- currenttime is the sum of all elapsed time each frame.  this is probably very close to realtime minus starting time.
	-- note that each environment tracks its own currenttime separately.  (TODO LATER: track environment.currenttime)
	self.currenttime=0
	
	self.nextmousehighlighttargetscantime=GetTime()			-- mouseover detection doesn't run every frame
	self.nextmousehighlighttargetscaninterval=0.100
	self.nextysorttime=0			-- ysort doesn't necessarily run every frame
	self.nextysortinterval=0.032		-- but it runs more often than highlight target scan
	
	

	
	-- --local scenario=TRAININGGROUNDS_Scenario_Animation.new()
	-- local scenario=TRAININGGROUNDS_AGGRAMAR_Scenario_Aggramar_Phase3All.new()	
	-- --local scenario=TRAININGGROUNDS_AGGRAMAR_Scenario_Aggramar.new()		
	-- -- local scenario=TRAININGGROUNDS_VARIMATHRAS_Scenario_Varimathras.new()		
	-- --local scenario=TRAININGGROUNDS_ARGUS_Scenario_Argus.new()
	-- scenario:Setup(environment_scenario)
	
	--local raid=scenario:CreatePremadeRaid()
	
	--self.scenario=scenario
	

	self:LoadScenarioByClass(TRAININGGROUNDS_Scenario_Menu)

	
end


function TRAININGGROUNDS_Game:LoadScenarioByClass(scenarioclass)
	--if(self.scenario)then
		--self.scenario:Cleanup()
	--end
	for i=1,#self.environments do
		--TODO: if environments ever become unusable after cleanup, this will break things
		self.environments[i]:Cleanup()
	end
	
	self:RecreateEnvironments()
	
	local scenario=scenarioclass.new()
	scenario:Setup(self.environment_scenario)
	self.scenario=scenario
end

function TRAININGGROUNDS_Game:RecreateEnvironments()
	--WARNING: call cleanup on existing environments first
	--TODO: do this automatically somehow
	
	self.environments={}

	local environment_gameplay=TRAININGGROUNDS_Environment.new()	
	self.environment_gameplay=environment_gameplay
	environment_gameplay:Setup(self,self.window.frame)
	self.window.background:SetFrameLevel(1)	
	environment_gameplay.frame:SetFrameLevel(2)
	tinsert(self.window.environments,environment_gameplay)
	
	local environment_scenario=TRAININGGROUNDS_Environment.new()
	self.environment_scenario=environment_scenario
	environment_scenario:Setup(self,self.window.frame)
	tinsert(self.window.environments,environment_scenario)	
	
	local environment_hud=TRAININGGROUNDS_Environment_HUD.new()
	self.environment_hud=environment_hud
	environment_hud:Setup(self,self.window.frame)
	environment_hud.frame:SetFrameLevel(255)
	tinsert(self.window.environments,environment_hud)
	
	
	local environment_hotbar=TRAININGGROUNDS_Environment_HUD.new()	--TRAININGGROUNDS_Environment_Menu.new()	
	self.environment_hotbar=environment_hotbar
	environment_hotbar:Setup(self,self.hotbarwindow.frame)
	environment_hotbar.camera.objectanchor="BOTTOMLEFT"
	--!!!
	self.hotbarwindow.background:Hide()
	tinsert(self.window.environments,environment_hotbar)	
	
	--TODO: move to environment_hotbar (which does not exist yet)
	--TODO: rename to hotbar_controller / environment_hotbar?
	local spellbuttoncontroller=TRAININGGROUNDS_SpellButtonController.new()
	spellbuttoncontroller:Setup(environment_hotbar)
	self.spellbuttoncontroller=spellbuttoncontroller
end


function TRAININGGROUNDS_Game:OnMouseChange(window,button,state)
	--TODO: window
	if(button=="LeftButton")then
		self.rawinput:SetKey("LMOUSE",state)
	elseif(button=="RightButton")then
		self.rawinput:SetKey("RMOUSE",state)		
	elseif(button=="MiddleButton")then
		self.rawinput:SetKey("MMOUSE",state)
	end
	
end
function TRAININGGROUNDS_Game:OnMouseWheel(window,delta)
	--TODO: window
	self.rawinput.keys["WMOUSE"]:SetMouseWheel(delta)
end
function TRAININGGROUNDS_Game:OnKeyChange(window,keycode,binding,state)

	--print("OnKeyDown",keycode,binding,state)
	--print(keycode,self.rawinput.keys[keycode])
	if(self.rawinput.keys[keycode])then
		self.rawinput.keys[keycode]:SetKey(state)
	end
	
	if(keycode=="ESCAPE" and state==true)then
		if(self.traininggrounds)then
			self.traininggrounds.game.scenario:OnEscapeKey()
			--self.traininggrounds:Shutdown()
		end
	end
end

function TRAININGGROUNDS_Game:MainGameLoop(elapsed)
	--if(true)then return end 		-- we probably don't need to mark this one as dubious
	
	self.realtime=GetTime()
	self.currenttime=self.currenttime+elapsed

	
	--TODO: environment:StartOfFrame -- increment environment.currenttime there
	
	--TODO: preferably loop through playercontrol objects only
	for i=1,#self.environments,1 do
		self.environments[i]:GetPlayerInput(elapsed)
	end		
	--TODO: rename to AIStep or AIPhase?
	for i=1,#self.environments,1 do
		self.environments[i]:AI(elapsed)
	end		
	for i=1,#self.environments,1 do
		self.environments[i]:Step(elapsed)
	end	
	for i=1,#self.environments,1 do
		self.environments[i]:PreMove(elapsed)
	end
	for i=1,#self.environments,1 do
		self.environments[i]:Move(elapsed)
	end	
	for i=1,#self.environments,1 do
		self.environments[i]:PostMove(elapsed)
	end
	for i=1,#self.environments,1 do
		self.environments[i]:IncrementTime(elapsed)
	end		
	for i=1,#self.environments,1 do
		self.environments[i]:CombatPhase_CollisionCheck_VoidZone(elapsed)
	end	
	for i=1,#self.environments,1 do
		self.environments[i]:CombatPhase(elapsed)
	end			
	for i=1,#self.environments,1 do	
		--TODO LATER: rename to Animate, or write separate Animate function
		self.environments[i]:PreDraw(elapsed)
	end			
	for i=1,#self.environments,1 do
		self.environments[i]:Draw(elapsed)
	end		
	for i=1,#self.environments,1 do
		self.environments[i]:EndOfFrame(elapsed)
	end
	
	self.rawinput:EndStep()
	self.keys:EndStep()
	
	if(self.realtime>self.nextmousehighlighttargetscantime)then
		self.nextmousehighlighttargetscantime=self.nextmousehighlighttargetscantime+self.nextmousehighlighttargetscaninterval
		if(self.nextmousehighlighttargetscantime<self.realtime)then self.nextmousehighlighttargetscantime=self.realtime end
		for i=1,#self.environments,1 do
			self.environments[i]:MouseoverHighlightScan(self.realtime,self.nextmousehighlighttargetscantime)
		end			
	end
end

function TRAININGGROUNDS_Game:ResetModelsAfterScreenRatioChange()
	for i=1,#self.environments,1 do
		self.environments[i]:ResetModelsAfterScreenRatioChange()
	end


end


function TRAININGGROUNDS_Game:Cleanup()
	--TODO: maintain list of windows
	self.window:Cleanup()
	self.hotbarwindow:Cleanup()
	self.keys:Cleanup()
	self.rawinput:Cleanup()
	
	for i=1,#self.environments,1 do
		local environment=self.environments[i]
		environment:Cleanup()
		--<s>TODO: environment.frame:cleanup was moved here from environment:cleanup so as not to break loadscenario.  however, it's not a great system by any stretch of the imagination		</s>
		--environment.frame:Cleanup()
	end
	
	--TODO LATER: more cleanup where necessary	
end







