
TRAININGGROUNDS_Environment = {}
TRAININGGROUNDS_Environment.__index = TRAININGGROUNDS_Environment

function TRAININGGROUNDS_Environment.new()
	local self=setmetatable({}, TRAININGGROUNDS_Environment)	
	return self
end

-- every environment needs a parent frame (though not necessarily a visible one) 
-- (TODO LATER: check if parentframe invisibility messes with character modelframe properties)
-- Parent frame object is responsible for adding this environment to its event caller list

function TRAININGGROUNDS_Environment:Setup(game,gameframe)
	self.game=game
	-- Environment has its own ReusableScrollFrame which is anchored to the parent frame.
	-- We don't use scrollframe's built-in scrolling functions.
	--  (TODO LATER: okay, actually we do use scrollframe's built-in scrolling functions.
	--				figure out to what extent we use the built-in scrolling functions.)
	
	self.frame=TRAININGGROUNDS_ReusableScrollFrames:GetFrame()
	--print("Environment frame:",self.frame)
	self.frame:SetWidth(gameframe:GetWidth())
	self.frame:SetHeight(gameframe:GetHeight())
	self.frame.parent=gameframe
	self.frame:SetParent(self.frame.parent)
	self.frame.scrollframe:SetParent(self.frame.parent)
	self.frame.scrollframe:SetWidth(self.frame:GetWidth())
	self.frame.scrollframe:SetHeight(self.frame:GetHeight())
	self.frame:SetAllPoints(gameframe)
	self.frame.scrollframe:SetAllPoints(gameframe)
	self.frame:Show()
	self.frame.scrollframe:Show()
	self.frame.scrollframe:SetScrollChild(self.frame)
	self.frame:SetAlpha(1)
	
	
	-- self.frame=TRAININGGROUNDS_ReusableScrollFrames:GetFrame()
	-- self.frame:SetWidth(gameframe:GetWidth())
	-- self.frame:SetHeight(gameframe:GetHeight())
	-- print("Environment frame: ",gameframe:GetWidth(),"x",gameframe:GetHeight())
	-- self.frame.scrollframe:SetPoint("TOPLEFT",gameframe,"TOPLEFT",0,0)
	-- self.frame.scrollframe:SetWidth(gameframe:GetWidth())
	-- self.frame.scrollframe:SetHeight(gameframe:GetHeight())
	-- self.frame.scrollframe:SetParent(gameframe)
	-- self.frame.scrollframe:Show()	
	-- self.frame.scrollframe:SetScrollChild(self.frame)	-- already handled by ReusableScrollFrames
	-- self.frame:SetPoint("TOPLEFT",gameframe,"TOPLEFT",0,0)
	-- self.frame.parent=self.frame.scrollframe
	-- self.frame:Show()

	
	self.newgameobjects={}
	
	self.objectlists={}
	self.gameobjects={}
	tinsert(self.objectlists,self.gameobjects)
	self.mobiles={}
	tinsert(self.objectlists,self.mobiles)
	self.raiders={}
	tinsert(self.objectlists,self.raiders)
	self.voidzones={}
	tinsert(self.objectlists,self.voidzones)
	
	self.localtime=0
	
	
	self:SetCamera()
	self.camera:Setup(self)
	
	tinsert(game.environments,self)
end


-- Override SetCamera if the environment uses a different camera (such as Camera_HUD).
-- TODO LATER: either leave comment about not calling super in overridden function, or change default camera to nil
-- TODO: maybe move SetCamera to Scenario
function TRAININGGROUNDS_Environment:SetCamera()	
	self.camera=TRAININGGROUNDS_Camera.new()
end

--TODO: preferably loop through playercontrol objects only
function TRAININGGROUNDS_Environment:GetPlayerInput(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:GetPlayerInput(elapsed)
	end
end
function TRAININGGROUNDS_Environment:AI(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:AI(elapsed)
	end
end
function TRAININGGROUNDS_Environment:IncrementTime(elapsed)
	self.localtime=self.localtime+elapsed
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:IncrementTime(elapsed)
	end
end
function TRAININGGROUNDS_Environment:Step(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:Step(elapsed)
	end
end
function TRAININGGROUNDS_Environment:PreMove(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:PreMove(elapsed)
	end
end
function TRAININGGROUNDS_Environment:Move(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:Move(elapsed)
	end
end
function TRAININGGROUNDS_Environment:PostMove(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:PostMove(elapsed)
	end
end
--TODO: split CombatPhase up into multiple steps (even more steps than we have now)
function TRAININGGROUNDS_Environment:CombatPhase_CollisionCheck_VoidZone(elapsed)
	for i=1,#self.mobiles,1 do	
		self.mobiles[i]:CombatPhase_CollisionCheck_VoidZone(elapsed)
	end
end
function TRAININGGROUNDS_Environment:CombatPhase(elapsed)
	for i=1,#self.mobiles,1 do	
		self.mobiles[i]:CombatPhase(elapsed)
	end
end
function TRAININGGROUNDS_Environment:PreDraw(elapsed)
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:PreDraw(elapsed)
	end
end
function TRAININGGROUNDS_Environment:Draw(elapsed)
	--for i=1,#self.gameobjects,1 do
		--self.gameobjects[i]:Draw(elapsed)
	--end
	
	--print("Environment.camera:",self.camera)
	self.camera:ArrangeAllGameObjects(self.gameobjects)	
	

end
function TRAININGGROUNDS_Environment:SetObjectVisibility(elapsed)
	for i=1,#self.gameobjects,1 do
		--TODO: move to camera instead?
	end
end


--TODO: broken; use updated scan in SelectionRectangle instead
function TRAININGGROUNDS_Environment:MouseoverHighlightScan(realtime,nextscantime)

	--TODO: move to camera
	--TODO: use gameobjects list instead of mobiles list?

	local uiscale,globalx,globaly=UIParent:GetEffectiveScale(),GetCursorPosition()	
	local gamescale=self.frame:GetScale()
	-- must divide by uiscale
	-- TODO: do we also need to divide by gamescale?  environment_world divides by gamescale
	-- (for now we are dividing by gamescale)
	globalx=globalx/uiscale/gamescale
	globaly=globaly/uiscale/gamescale
	local left,bottom,width,height=self.frame:GetRect()
	--print("Environment.lua ",left,bottom,width,height)
	--TODO: revise math and logic
		
	local localx=globalx-left
	local localy=globaly-bottom			
	--local offsetx,offsety=self.camera:GetScrollOffset()	
	local offsetx,offsety=0,0
	offsety=offsety*self.camera.ystretch
	offsetx=offsetx*self.camera.zoom
	offsety=offsety*self.camera.zoom
	--offsetx=offsetx+(TRAININGGROUNDS_Game.SCREENWIDTH/2)
	--offsety=offsety+(TRAININGGROUNDS_Game.SCREENHEIGHT/2)
	offsetx=offsetx+(self.frame:GetWidth()/2)
	offsety=offsety+(self.frame:GetHeight()/2)
	
	localx=localx-offsetx
	localy=localy-offsety
	local camerax,cameray=localx,localy
	camerax=camerax*(1/self.camera.zoom)
	cameray=cameray*(1/self.camera.zoom)
	cameray=cameray*(1/self.camera.ystretch)	


	for i=1,#self.mobiles,1 do
		local obj=self.mobiles[i]
		if(obj.clickable and obj.drawable)then				
			obj.ismouseovered=false
			-- since we're operating in camera coordinates, divide by ystretch
			-- TODO: overridable GetClickareaRect
			-- TODO: rename adjustedcamera vars -- slightly misleading, they're not adjusted yet
			--TODO: can adjustedcamera vars go outside the for loop?
			local adjustedcamerax,adjustedcameray=localx,localy
			local adjustedzoom=self.camera.zoom
			adjustedcamerax=adjustedcamerax*(1/adjustedzoom)
			adjustedcameray=adjustedcameray*(1/adjustedzoom)
			adjustedcameray=adjustedcameray*(1/self.camera.ystretch)
			
			local x1=obj.x+(obj.drawable.clickarea.x-obj.drawable.clickarea.width/2)
			local x2=obj.x+(obj.drawable.clickarea.x+obj.drawable.clickarea.width/2)
			local y1=obj.y+(obj.drawable.clickarea.y)/self.camera.ystretch
			local y2=obj.y+(obj.drawable.clickarea.y+obj.drawable.clickarea.height)/self.camera.ystretch
			x1,y1=self.camera:ConvertObjectCoordsToMouseoverCoords(x1,y1,obj)
			x2,y2=self.camera:ConvertObjectCoordsToMouseoverCoords(x2,y2,obj)
			
			if(i==1)then
				--print("Environment.lua "..x1..","..y1.." to "..x2..","..y2)
				--print("Cursor: ",adjustedcamerax,",",adjustedcameray)
			end
			
			if(adjustedcamerax>=x1)then
				if(adjustedcamerax<=x2)then						
					if(adjustedcameray>=y1)then
						if(adjustedcameray<=y2)then	
							--print("Environment.lua mouseover "..tostring(obj))
							obj.ismouseovered=true

							--obj.modelframe:SetAnimation(1)	-- dubious --TODO: apply mild highlight when mouseovered
						end
					end
				end
			end
		end
	end
	
end

function TRAININGGROUNDS_Environment:EndOfFrame(elapsed)
	for i=1,#self.newgameobjects,1 do
		self.newgameobjects[i]:TransferFromEnvironmentNewobjectLists(self)
		--print("New game object:",self.newgameobjects[i])
		--print(self.newgameobjects[i].x,self.newgameobjects[i].y)
	end
	self.newgameobjects={}
	
	for i=#self.gameobjects,1,-1 do
		local obj=self.gameobjects[i]
		if(obj.dying)then
			obj:Cleanup()	-- this SHOULD set dead to true
			if(not obj.dead) then
				-- jump into GameObject file before crashing noisily
				obj:FatalErrorObjNotDeadAfterCleanup()
			end
			--TODO: move tremove to proposed list of object lists below
			tremove(self.gameobjects,i)
		end
	end
	for j=1,#self.objectlists do
		local objectlist=self.objectlists[j]
		for i=#objectlist,1,-1 do
			local obj=objectlist[i]
			if(obj.dead)then
				tremove(objectlist,i)
			end
		end
	end
end


function TRAININGGROUNDS_Environment:ResetModelsAfterScreenRatioChange()
	--print("Resetting models...")
	for i=1,#self.gameobjects,1 do
		self.gameobjects[i]:ResetModelAfterGraphicsChange()
	end
end


function TRAININGGROUNDS_Environment:MouseCoordinatesToWindowCoordinates(x,y)
	local uiscale,globalx,globaly=UIParent:GetEffectiveScale(),x,y
	local gamescale=self.frame:GetScale()
	-- must divide by uiscale
	-- TODO: do we also need to divide by gamescale?  environment_world divides by gamescale
	-- (for now, we are dividing by gamescale)
	globalx=globalx/uiscale/gamescale
	globaly=globaly/uiscale/gamescale
	local left,bottom,width,height=self.frame:GetRect()
	--TODO: revise math and logic			
	local localx=globalx-left
	local localy=globaly-bottom		
	
	return localx,localy
end

--TODO: these are environmentcoordinates now, not windowcoordinates
function TRAININGGROUNDS_Environment:GetObjectsAtRectangleWindowCoordinates(objlist,x3,y3,w3,h3)
	local result={}
	local camera=self.camera
	local frame=self.game.window.frame
	local env=self
	
	for i=1,#objlist,1 do
		obj=objlist[i]
		
		-- --TODO: this changes depending on camera anchor						
		-- local x1=((obj.x-camera.x)+obj.drawable.clickarea.x-obj.drawable.clickarea.width/2)*camera.zoom+(frame:GetWidth()/2)
		-- local x2=((obj.x-camera.x)+obj.drawable.clickarea.x+obj.drawable.clickarea.width/2)*camera.zoom+(frame:GetWidth()/2)
		
		-- --TODO: should clickarea.y be affected by ystretch? (would need to adjust gameobject.screenyoffset too)
		-- local y1=(obj.y*camera.ystretch-camera.y*camera.ystretch+obj.drawable.clickarea.y)*camera.zoom+(frame:GetHeight()/2)
		-- local y2=(obj.y*camera.ystretch-camera.y*camera.ystretch+obj.drawable.clickarea.y+obj.drawable.clickarea.height)*camera.zoom+(frame:GetHeight()/2)
		
		-- --TODO: this changes depending on camera anchor						
		 -- local x1=((obj.x)+obj.drawable.clickarea.x-obj.drawable.clickarea.width/2)+(frame:GetWidth()/2)
		 -- local x2=((obj.x)+obj.drawable.clickarea.x+obj.drawable.clickarea.width/2)+(frame:GetWidth()/2)
		
		 -- --TODO: should clickarea.y be affected by ystretch? (would need to adjust gameobject.screenyoffset too)
		 -- local y1=(obj.y*camera.ystretch+obj.drawable.clickarea.y)+(frame:GetHeight()/2)
		 -- local y2=(obj.y*camera.ystretch+obj.drawable.clickarea.y+obj.drawable.clickarea.height)+(frame:GetHeight()/2)
		
		
		--TODO: this changes depending on camera anchor						
		 local x1=((obj.x)+obj.drawable.clickarea.x-obj.drawable.clickarea.width/2)
		 local x2=((obj.x)+obj.drawable.clickarea.x+obj.drawable.clickarea.width/2)
		
		 --TODO: should clickarea.y be affected by ystretch? (would need to adjust gameobject.screenyoffset too)
		 local y1=(obj.y+obj.drawable.clickarea.y)
		 local y2=(obj.y+obj.drawable.clickarea.y+obj.drawable.clickarea.height/camera.ystretch)
		
		
		local w1=x2-x1
		local h1=y2-y1
		--print("Env",x1,y1,w1,h1)
		
		
				
		if(TRAININGGROUNDS_RectangleRectangleCollision(x1,y1,w1,h1,x3,y3,w3,h3))then
			tinsert(result,obj)
		end
	end
	return result
end


function TRAININGGROUNDS_Environment:GetFirstAttackableTarget(objs)
	local enemies={}
	for i=1,#objs,1 do
		if(objs[i].faction==TRAININGGROUNDS_Factions.ENEMY)then
			tinsert(enemies,objs[i])
		end
	end
	if(#enemies>0)then
		table.sort(enemies, function(a,b) return a.y>b.y end)
		--TODO: make sure [#enemies] is indeed correct and not [1] instead
		return enemies[#enemies]
	else
		return nil
	end
end


function TRAININGGROUNDS_Environment:WindowCoordinatesToCursorPosition(cursorx,cursory)
	local camera=self.camera
	--localx,localy store environment coordinates
	local localx,localy=cursorx,cursory			
	localx=localx-self.frame:GetWidth()/2
	localy=localy-self.frame:GetHeight()/2		


	--apparently don't need to add camera.x/camera.y here
	-- due to poorly-understood scrollframe mechanics...	(TODO: research)
	-- local hscroll,vscroll=camera:GetScrollAmounts()	
	--...but sometimes we have to get them anyway because scrollframe breaks.	
	--TODO: recent changes to camera (i.e. setscale) may have broken TRAININGGROUNDS_Scrollframes_Broken
	if(TRAININGGROUNDS_Scrollframes_Broken)then
		localx=localx+hscroll
		localy=localy+vscroll
	end
	
	--TODO: research (getcursorposition?)
	
	localy=localy/camera.ystretch
	-- don't need to divide by zoom with new setscale camera

	return localx,localy
end


function TRAININGGROUNDS_Environment:Cleanup()
	--TODO: WARNING: make sure cleanup doesn't break game:LoadScenario

	--TODO: separate cleanup-all-objects function from environment:cleanup?
	
	----<s>TODO: environment.frame:cleanup has been moved to game:cleanup, where we're sure we won't be using environment.frame for a different scenario	</s>
	
	self.frame:Cleanup()
	
	--TODO: make sure newgameobjects get cleaned up too
	local i
	for i=#self.gameobjects,1,-1 do
		self.gameobjects[i]:Cleanup()
	end
	self.gameobjects={}
	
	
end

