
-- Shadow doubles as targeting circle.

-- Resize shadow by changing width only; height is ignored and automatically set during SetFrameSizeAndOrientation based on camera

--TODO: should this go in drawables\sprites\miscellaneous folder, since shadow is in gameobjects\miscellaneous?
	--(should shadow go in gameobjects\shadows instead?)

TRAININGGROUNDS_Drawable_Sprite_Shadow = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable_Sprite)

function TRAININGGROUNDS_Drawable_Sprite_Shadow:SetCustomInfo()
	TRAININGGROUNDS_Drawable_Sprite.SetCustomInfo(self)
	self.anchor="CENTER"
	self.selected=false
	
	self.ystretch=true

	
	--shadowsizemultiplier can be adjusted by owner
	-- TODO: store shadowsizemultiplier in owner (self_drawable>shadow_obj>shadow_obj_owner) instead
	--self.shadowsizemultiplier=1
end

function TRAININGGROUNDS_Drawable_Sprite_Shadow:SetFrameAppearance()
	--override; don't call super while overriding
	--self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\targetingcircle.tga")
	self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\shadow.tga")
	--print("Shadow frame:",self.frame)
	
	--self.frame.texture:SetColorTexture(1,1,1,1)	
	--self.frame.texture:SetGradientAlpha("HORIZONTAL",.3,.3,1,1.0,.3,.3,1,1.0);
	--self.frame.texture:SetGradientAlpha("HORIZONTAL",1,1,1,1.0,1,1,1,1.0);
	
	---- this line here is leftover from when we had to debug some invisible shadows.
	--print("Shadow sprite: frame",self.frame:GetName())
	
	--self:SetColor(0,1,0,1.0)
	self:SetColor(0,0,0,1.0)
end

function TRAININGGROUNDS_Drawable_Sprite_Shadow:SetFrameLayer()
	self.framelayer=self.owner.environment.camera.shadowframelayer
end

function TRAININGGROUNDS_Drawable_Sprite_Shadow:Select(state,r,g,b)
	--TODO: use RGB instead of always blue
	self.selected=state
	if(self.selected)then	
		----Nondirectional gradientless targeting circle
		--self.frame.texture:SetTexture("textures/unitselecttexture-full.blp")		
		
		----Replica nondirectional gradiented targeting circle
		--self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\targetingcircle.tga")
		
		-- Directional targeting circle
		self.frame.texture:SetTexture("textures/unitselecttexture.blp")		
		-- TODO: color depends on owner's faction and environment's faction
		--self.frame.texture:SetGradientAlpha("HORIZONTAL",.4,.4,1,1.0,.4,.4,1,1.0);	
		self:SetColor(.4,.4,1,1.0)
		--self.frame.texture:SetGradientAlpha("HORIZONTAL",1,0,0,1.0,1,0,0,1.0);
		
		--self.frame.texture:SetGradientAlpha("HORIZONTAL",1,1,1,1.0,1,1,1,1.0);		
		self.framelayer=self.owner.environment.camera.targetcircleframelayer
		self.updateframelevel=true
		
	else
		self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\shadow.tga")
		--self:SetColor(0,0,0,1.0)
		self:SetColor(0,0,0,1.0)
		--self.frame.texture:SetGradientAlpha("HORIZONTAL",0,0,0,1.0,0,0,0,1.0);	
		self.framelayer=self.owner.environment.camera.shadowframelayer
		self.updateframelevel=true
	end
end



function TRAININGGROUNDS_Drawable_Sprite_Shadow:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch)
	TRAININGGROUNDS_Drawable_Sprite.SetFrameSizeAndOrientation(self,wid,hgt,yaw,pitch)

	-- local ystretch=math.cos(-pitch)
	-- if(ystretch<0.5) then ystretch=0.5 end
	-- local multiplier=1
	-- -- if(self.owner)then		
		-- -- --TODO: store shadowsize outside of modelinfo
		-- -- if(self.owner.owner)then
			-- -- if(self.owner.owner.drawable)then
				-- -- if(self.owner.owner.drawable.modelinfo)then
					-- -- multiplier=self.owner.owner.drawable.modelinfo.shadowscale
				-- -- end
			-- -- end
		-- -- end
	-- -- end
	
	-- -- shadow's height is ignored; use wid instead
	-- local hgt=wid
	-- self.frame:SetSize(wid*multiplier,hgt*multiplier*ystretch)
	
	
	----TODO: why do we have this (now commented-out) line?  it isn't used anywhere
	--local invsqrt2=(1/math.sqrt(2))
	
	--TODO: verify that we're forced to add pi/2 here because unitselecttexture.blp 
		-- (which is built into WoW) faces the wrong way by default
	if(self.selected and yaw)then
		local x1,y1=TRAININGGROUNDS_Transform_Rotate2D(0,0,yaw+math.pi/2,0.5,0.5)
		local x2,y2=TRAININGGROUNDS_Transform_Rotate2D(0,1,yaw+math.pi/2,0.5,0.5)
		local x3,y3=TRAININGGROUNDS_Transform_Rotate2D(1,0,yaw+math.pi/2,0.5,0.5)
		local x4,y4=TRAININGGROUNDS_Transform_Rotate2D(1,1,yaw+math.pi/2,0.5,0.5)
	
		self.frame.texture:SetTexCoord(x1,y1,x2,y2,x3,y3,x4,y4)
	end
end