
do
	--TODO: some overlap here with Circle and Shadow
	local super=TRAININGGROUNDS_Drawable_Sprite
	TRAININGGROUNDS_Drawable_Sprite_BigCircle=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_Drawable_Sprite_BigCircle
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		--self.filename="Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\bigquartercircle.tga"
		self.filename_ex="Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\bigquartercircle.tga"
		--print("SETCUSTOMINFO self",self,"self.filename is",self.filename)
		self.anchor="CENTER"		
		
		self.ystretch=true
	end
	
	--TODO: BigCircle itself shouldn't have background framelayer
	function class:SetFrameLayer()
		--override; don't call super while overriding
		self.framelayer=self.environment.camera.arenaborderframelayer
	end

	function class:SetFrameLevel()
		super.SetFrameLevel(self)
		--TODO: we probably need to manually set corner frames framelevel		
	end

	
	
	local function quicksetup(parentframe,filename,point1,point2,tx1,ty1,tx2,ty2,tx3,ty3,tx4,ty4)
		local frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
		frame:Show()	--TODO: check just in case this early Show has been causing raidmarker texture screen flash on restart
		frame.texture:Show()
		frame.texture:SetTexture(filename)
		frame.texture:SetTexCoord(tx1,ty1,tx2,ty2,tx3,ty3,tx4,ty4)
		frame:SetPoint(point1,parentframe,point1,0,0)
		frame:SetPoint(point2,parentframe,"CENTER",0,0)
		frame:SetParent(parentframe)		
		
		return frame
	end
	
	function class:SetFrameAppearance()
		self.frame:SetSize(100,100)
		
		self.topleft=quicksetup(self.frame,self.filename_ex,"TOPLEFT","BOTTOMRIGHT", 0,0, 0,1, 1,0, 1,1)
		self.topright=quicksetup(self.frame,self.filename_ex,"TOPRIGHT","BOTTOMLEFT", 0,1, 1,1, 0,0, 1,0)
		self.bottomright=quicksetup(self.frame,self.filename_ex,"BOTTOMRIGHT","TOPLEFT", 1,1, 1,0, 0,1, 0,0)
		self.bottomleft=quicksetup(self.frame,self.filename_ex,"BOTTOMLEFT","TOPRIGHT", 1,0, 0,0, 1,1, 0,1)
	end	
	
	function class:ShowFrames()			
		self.frame:SetAlpha(self.alpha)
		self.topleft:SetAlpha(self.alpha)
		self.topright:SetAlpha(self.alpha)
		self.bottomright:SetAlpha(self.alpha)
		self.bottomleft:SetAlpha(self.alpha)
	end

	function class:HideFrames()	
		self.frame:SetAlpha(0)
		self.topleft:SetAlpha(0)
		self.topright:SetAlpha(0)
		self.bottomright:SetAlpha(0)
		self.bottomleft:SetAlpha(0)
	end
	
	function class:SetColor(R,G,B,A)
		self.topleft.texture:SetGradientAlpha("HORIZONTAL",R,G,B,A,R,G,B,A)
		self.topright.texture:SetGradientAlpha("HORIZONTAL",R,G,B,A,R,G,B,A)
		self.bottomright.texture:SetGradientAlpha("HORIZONTAL",R,G,B,A,R,G,B,A)
		self.bottomleft.texture:SetGradientAlpha("HORIZONTAL",R,G,B,A,R,G,B,A)
	end
	
	function class:Cleanup()
		super.Cleanup(self)
		self.topleft:Cleanup()
		self.topright:Cleanup()		
		self.bottomright:Cleanup()
		self.bottomleft:Cleanup()
	end
	
	
end