-- ModelInfos is "sort of" global static.
-- In the hypothetical far-off unlikely situation where multiple authors are writing expansions,
-- each author would create their own unique ModelInfos instance.
-- TODO LATER: determine if we're overthinking this

--TODO: figure out exactly what our standard size metric is based on
-- targeting circle appears to be the same size for player races, might go with that
-- 100px diameter (100x70.7 in 3/4 view)
	-- so targeting circle is 100px, hitboxes are ... probably less than 100px 
	-- and clickboxes vary in size.  tentative plan.


--TODO: CameraIDs never really got implemented; can probably remove it
TRAININGGROUNDS_CameraIDs={}
TRAININGGROUNDS_CameraIDs.DEFAULT=1	
	


_TRAININGGROUNDS_ModelInfos = {}
_TRAININGGROUNDS_ModelInfos.__index = _TRAININGGROUNDS_ModelInfos
function _TRAININGGROUNDS_ModelInfos.new()
	local self=setmetatable({}, _TRAININGGROUNDS_ModelInfos)
	return self
end
TRAININGGROUNDS_ModelInfos = _TRAININGGROUNDS_ModelInfos.new()
TRAININGGROUNDS_ModelInfos.infos={}


function _TRAININGGROUNDS_ModelInfos:Add(id,modelinfo)
	if(self.infos[id])then
		local errormessage="WARNING: TRAININGGROUNDS_ModelInfos "..tostring(self).." already has id "..id
		print(errormessage)
		--error(errormessage)
	end
	self.infos[id]={}
end

function _TRAININGGROUNDS_ModelInfos:Get(id)
	return self.infos[id]
end



TRAININGGROUNDS_CameraSpecificModelInfo = {}
TRAININGGROUNDS_CameraSpecificModelInfo.__index = TRAININGGROUNDS_CameraSpecificModelInfo
function TRAININGGROUNDS_CameraSpecificModelInfo.new()
	local self=setmetatable({}, TRAININGGROUNDS_CameraSpecificModelInfo)	
	return self
end
function TRAININGGROUNDS_CameraSpecificModelInfo:Setup()	
	self:SetCustomInfo()
end
function TRAININGGROUNDS_CameraSpecificModelInfo:SetCustomInfo()	
	self.pointoffsetx=0
	self.pointoffsety=-200
end
local defaultcamerainfo=TRAININGGROUNDS_CameraSpecificModelInfo.new()
defaultcamerainfo:Setup()
TRAININGGROUNDS_CameraInfo_Default=defaultcamerainfo




TRAININGGROUNDS_ModelInfo = {}
TRAININGGROUNDS_ModelInfo.__index = TRAININGGROUNDS_ModelInfo
function TRAININGGROUNDS_ModelInfo.new()
	local self=setmetatable({}, TRAININGGROUNDS_ModelInfo)	
	return self
end
function TRAININGGROUNDS_ModelInfo:Setup()	
	self:SetCustomInfo()
end
function TRAININGGROUNDS_ModelInfo:SetCustomInfo()	

	self.displayid=384	-- Hogger
	
	-- cameradistance is used to keep the entire model within its frame regardless of which animation is playing
	-- (i.e. prevents clipping outside the frame)
	self.cameradistance=15
	-- framescale is used to scale the entire frame up to make up for increased cameradistance
	self.framescale=4.5
	-- pivotadjustment determines the center of the model for rotation purposes.
	self.pivotadjustment=0
	-- cameratargetz is used to reposition very large models in the middle of their targeting circle.
	self.cameratargetz=0	
	-- at this point the model should fit neatly into a 100-width target circle.
	--
	self.clickboxx=0
	self.clickboxy=-10
	self.clickboxwidth=50
	self.clickboxheight=70	
	--
	-- size of the model compared to a human character (100), before buffs, debuffs, or other modifications
	self.size=100
	-- size of the model's shadow (and/or targeting circle)
	self.shadowsize=100	

	-- for particularly large models, treat the model as further south than it really is
	-- so it appears to trample models underneath it.
	-- TODO: this should be handled semi-automatically depending on model size
	self.ysortoffset=0

	
	self.camerainfo={}
	self.camerainfo[TRAININGGROUNDS_CameraIDs.DEFAULT]=TRAININGGROUNDS_CameraInfo_Default
end
function TRAININGGROUNDS_ModelInfo:SetModelframeAppearance(modelframe)
	self:SetModelframeDisplayInfo(modelframe)
end

function TRAININGGROUNDS_ModelInfo:SetModelframeDisplayInfo(modelframe)
	--override for playercharacters
	--don't call super when overriding
	
	
	--modelframe:SetDisplayInfo(self.displayid)
	if(self.displayid)then
		modelframe:SetDisplayInfo(self.displayid)
	else
		--TODO: throw warning here -- modelinfo should always have a displayid unless we're doing something tricky in debug
		if(self.modelfilename)then
			modelframe:SetModel(self.modelfilename)
		end
	end
	
	
	
	
	--modelframe:SetUnit("player")
	--modelframe:SetCustomRace(1,1)
	--modelframe:SetCustomRace(22,1)
	--modelframe:SetCustomRace(24,1)
	
end
function TRAININGGROUNDS_ModelInfo:GetCameraSpecificInfo(cameraid)
	--TODO: cameraid
	return self.camerainfo[TRAININGGROUNDS_CameraIDs.DEFAULT]
end

TRAININGGROUNDS_ModelInfo_Default=TRAININGGROUNDS_ModelInfo.new()
TRAININGGROUNDS_ModelInfo_Default:Setup()
TRAININGGROUNDS_ModelInfos:Add(TRAININGGROUNDS_ModelInfo_Default.displayid,TRAININGGROUNDS_ModelInfo_Default)




-- mi=TRAININGGROUNDS_ModelInfo.new()
-- mi:Setup()
-- mi.displayid=385 -- murloc
-- mi.distance=10;mi.modelscale=1
-- mi.offsetx=0;mi.offsety=-173;mi.pivotx=-20;mi.pivoty=-20;mi.pivotz=-1;
-- TRAININGGROUNDS_ModelInfos:Add(mi.displayid,mi)

-- mi=TRAININGGROUNDS_ModelInfo.new()
-- mi:Setup()
-- mi.displayid=387 -- black whelpling
-- mi.distance=10;mi.modelscale=0.5
-- mi.offsetx=0;mi.offsety=-183;mi.pivotx=5;mi.pivoty=-63;mi.pivotz=-4;
-- TRAININGGROUNDS_ModelInfos:Add(mi.displayid,mi)

-- mi=TRAININGGROUNDS_ModelInfo.new()
-- mi:Setup()
-- mi.race=101 -- human F
-- mi.distance=10;mi.modelscale=1
-- mi.offsetx=0;mi.offsety=-108;mi.pivotx=0;mi.pivoty=0;mi.pivotz=0;
-- TRAININGGROUNDS_ModelInfos:Add(mi.displayid,mi)



TRAININGGROUNDS_ModelInfo_Default.camerainfo[TRAININGGROUNDS_CameraIDs.DEFAULT]=defaultcamerainfo

