do
	local super=TRAININGGROUNDS_Drawable		
	TRAININGGROUNDS_Drawable_Sprite=TRAININGGROUNDS_inheritsFrom(super)	
	local class=TRAININGGROUNDS_Drawable_Sprite
	

	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		--TODO: currently all GameObjects use Drawable_Sprite by default.  do we want to change that?  or maybe not?		
		self.filename=nil
		--self.filename="Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\circle.tga"	
		
		-- if set to ttrue, sprite will appear to be "flat against the ground" like a shadow or targeting circle
		self.ystretch=false
	end
	
	
	function class:SetFrameAppearance()
		--override; don't call super while overriding
		--self.frame.texture:SetTexture("Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\targetingcircle.tga")
		self:ReloadFile()
	end
	
	function class:ReloadFile()
		--print("self",self,"self.filename is",self.filename)
		if(self.filename)then
			self.frame.texture:SetTexture(self.filename)
		end
	end
	
	function class:GetYstretchMultiplier()
		if(self.ystretch)then
			return self.owner.environment.camera.ystretch
		end
		return 1
	end
	
	function class:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch)
		local ystretch=self:GetYstretchMultiplier()
		self.frame:SetSize(wid,hgt*ystretch)
	end
	
	function class:SetColor(R,G,B,A)
		self.frame.texture:SetGradientAlpha("HORIZONTAL",R,G,B,A,R,G,B,A)
	end
end
