
-- Spell effects are drawn differently depending on whether they are tagged as "moving".
-- Stationary spell effects behave very much like character models.
-- Moving spell effects are intended to display particle trails as they move,
--		so they must properly move around within their frame (which takes up the entire window).
-- Important effects, such as telegraphs and void zones, should always be stationary.
-- 		Stationary effects are positioned more accurately than moving effects.



--TODO: stationary projectiles don't respect scrollframe
--TODO: mobile projectiles probably don't respect scrollframe

TRAININGGROUNDS_Drawable_SpellEffect = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable)

function TRAININGGROUNDS_Drawable_SpellEffect:SetCustomInfo()
	TRAININGGROUNDS_Drawable.SetCustomInfo(self)
	self.moving=false
	--self.moving=true
	self.anchor="CENTER"
	
	--solarwrath:
	self.modelfilename="spells/cfx_druid_solarwrath_missile.m2"
	self.defaultanimation=0
	self.yoffset=-1	
	self.offset1=0	--TODO: NYI, maybe
	self.offset2=0	--TODO: NYI, maybe
	self.frameyoffset=0	--TODO: copy comments over from Drawable_WakeOfFlame
	self.cameradistance=3	
	self.framescale=2
	-- moving spelleffect parameters:
	-- This multiplier affects SetCamDistanceScale.  The SMALLER multiplier is, the LARGER the effect will appear.
	self.movingyoffset=-1
	self.multiplierbase=800
	self.mobilexmodifier=.8	
	-- controls how Y varies with latitude
	self.yshearmodifier=.08
	self.mobileymodifier=.96
	-- controls how much the previous modifiers change with camerascale
	self.mobilexmultipliermodifier=0.4
	self.mobileymultipliermodifier=0.4
	--TODO: yoffset for stationary effect too
	
	
	-- --chiorbit:		
	-- self.modelfilename="spells/cfx_monk_chiorbit_missile.m2"	
	-- --self.modelfilename="spells/cfx_mage_pyroblast_missile.m2"	-- same formula
	-- self.yoffset=0	
	-- self.cameradistance=3
	-- self.framescale=6
	-- -- moving spelleffect parameters:
	-- self.multiplierbase=250
	-- self.movingyoffset=0
	-- --
	-- self.mobilexmodifier=1.08	
	-- self.mobileymodifier=1.18	
	-- self.yshearmodifier=.09
	-- self.mobileymultipliermodifier=0.06
	-- self.mobilexmultipliermodifier=0.06
	
	
	-- self.modelfilename="spells/cfx_hunter_aimedshot_missile.m2"
	
end

function TRAININGGROUNDS_Drawable_SpellEffect:CreateFrame()
	--self.frame=TRAININGGROUNDS_ReusableModelFrames:GetFrame()
	self.frame=TRAININGGROUNDS_ReusableParticleFrames:GetFrame()
	self.frame:Show()
end

function TRAININGGROUNDS_Drawable_SpellEffect:SetFrameAppearance()	
	self.modelinfo=TRAININGGROUNDS_ModelInfo.new()
	self.modelinfo:Setup()

	--self.frame:SetModel("spells/cfx_druid_solarwrath_missile.m2")	-- ok
	--self.frame:SetModel("spells/cfx_hunter_aimedshot_missile.m2")	-- no
	--self.frame:SetModel("spells/cfx_mage_frostbolt_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_mage_arcanebarrage_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_mage_arcanemissiles_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_monk_chiorbit_missile.m2")	-- no
	self.frame:SetModel(self.modelfilename)
	
	
	
end

function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrame(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)	
	if(self.moving)then
		self:ArrangeFrameMoving(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	else		
		self:ArrangeFrameStationary(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	end
end

function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameStationary(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	--print(self.parentframe)
	self.frame:SetParent(self.parentframe)
	self.frame:ClearAllPoints()	
	
	--!!!
	--self.frame:SetCamDistanceScale(self.cameradistance)	-- uh oh.  THIS line is now suspected to be a problem.  SetModelScale seems to be working fine in comparison
	self.frame:SetCamDistanceScale(1)			
	
	--dubious
	-- particleframes: must set position AFTER modelscale
	self:SetFrameSizeAndOrientationStationary(wid,hgt,yaw,pitch,zoom)
	--self.frame:SetPosition(0,0,self.yoffset)	
	self.frame:SetPosition(self.offset1,self.offset2,self.yoffset)	
	self.frame:SetPoint(self.anchor,self.parentframe,parentanchor,x,y+self.frameyoffset*self.framescale)	
	
	--print("drawable_spelleffect stationary",self.defaultanimation)
	--TODO: defaultanimation should only be set once, as soon as we're at a point where setting it actually works
	self:SetAnimationByNumber(self.defaultanimation)	
end

-- function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameStationary(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	-- self.frame:SetParent(self.parentframe)
	-- self.frame:ClearAllPoints()		
	-- self.frame:SetSize(wid/zoom,hgt/zoom)
	-- self.frame:SetModelScale(1/zoom)
	-- self.frame:SetPoint(self.anchor,self.parentframe,parentanchor,x,y)		
	-- --print(wid/zoom,hgt/zoom)
-- end

--TODO: merge with charactermodel
function TRAININGGROUNDS_Drawable_SpellEffect:SetFrameSizeAndOrientationStationary(wid,hgt,yaw,pitch,zoom)
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid
	local framescale=self.framescale
	local multiplier=framescale
	self.frame:SetSize(wid*multiplier,hgt*multiplier)
	self.frame:SetModelScale(1/zoom)	--TODO: this line is suspected to be a problem.  (also, is the following very old comment related?)  (or maybe it's SetCamDistanceScale that's the problem)

	--TODO: spelleffect camera zoom doesn't work (again); object scaling is applied twice
end



function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameMoving(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	--TODO: parentanchor currently ignored; always center
	--TODO: zoom not yet implemented for moving (moving is broken anyways)

	self.frame:SetParent(self.parentframe.scrollframe)
	self.frame:ClearAllPoints()
	self.frame:SetPoint("CENTER",self.owner.environment.frame.scrollframe,"CENTER",0,0)
	local size=max(self.owner.environment.frame:GetWidth(),self.owner.environment.frame:GetHeight())
	
	--self.frame:SetWidth(self.owner.environment.frame:GetHeight())
	--self.frame:SetHeight(self.owner.environment.frame:GetHeight())
	size=480	--dubious
	self.frame:SetWidth(size)
	self.frame:SetHeight(size)
	

	
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid

	local xx=x-self.owner.environment.frame.scrollframe:GetHorizontalScroll()
	local yy=y-(-self.owner.environment.frame.scrollframe:GetVerticalScroll())

	local xfrac=(xx/self.parentframe:GetWidth())*2
	local yfrac=(yy/self.parentframe:GetHeight())*2	
	local x,y=xfrac,yfrac

	
	--local multiplier=80
	-- This multiplier affects SetCamDistanceScale.
	-- The SMALLER multiplier is, the LARGER the effect will appear.
	local divwid=wid;if(divwid<1)then divwid=1 end
	local multiplier=(self.multiplierbase/divwid)
	local divmultiplier=multiplier; if(divmultiplier<1)then divmultiplier=1 end

	-- local multiplier2=multiplier*0.8
	-- local xmultiplier=multiplier2*(self.mobilexmodifier+self.mobilexmultipliermodifier/divmultiplier)
	-- local ymultiplier=multiplier2*(self.mobileymodifier+self.mobileymultipliermodifier/multiplier)

	--local multiplier2=multiplier*0.8
	local xmultiplier=multiplier*(self.mobilexmodifier+self.mobilexmultipliermodifier/divmultiplier)
	local ymultiplier=multiplier*(self.mobileymodifier+self.mobileymultipliermodifier/multiplier)

	
	ymultiplier=ymultiplier-(y*self.yshearmodifier*multiplier)
	xmultiplier=xmultiplier-(y*.095*multiplier)
	
	self.frame:SetPosition(z,x*xmultiplier,self.movingyoffset+y*ymultiplier)
	self.frame:SetCamDistanceScale(multiplier)
	
	--print("drawable_spelleffect moving",self.defaultanimation)
	--TODO: defaultanimation should only be set once, as soon as we're at a point where setting it actually works
	self:SetAnimationByNumber(self.defaultanimation)		
end


