TRAININGGROUNDS_Drawable_CharacterModel = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable)

function TRAININGGROUNDS_Drawable_CharacterModel:SetCustomInfo()
	self.anchor="CENTER"
	
	self.lightAA=1.0
	self.lightAR=1.0
	self.lightAG=1.0
	self.lightAB=1.0
	self.lightDA=0.0
	self.lightDR=1.0
	self.lightDG=1.0
	self.lightDB=1.0
	
	self.sequencemode=false
	self.sequenceindex=0
	-- the start time of the sequence.  for example, 1.0 is 1000 milliseconds into the sequence animation.
	self.sequencestarttime=0
	-- the actual in-WoW time that we started playing the sequence.
	self.sequenceplaybackstarttime=0
	self.sequencetimescale=0
end

function TRAININGGROUNDS_Drawable_CharacterModel:CreateFrame()
	self.frame=TRAININGGROUNDS_ReusableModelFrames:GetFrame()
	self.frame:Show()
end

function TRAININGGROUNDS_Drawable_CharacterModel:SetFrameAppearance()	
	self.modelinfo=TRAININGGROUNDS_ModelInfo.new()
	self.modelinfo:Setup()
	
	--self.frame:SetDisplayInfo(384)	
	self.frame:SetUnit("player")
end


function TRAININGGROUNDS_Drawable_CharacterModel:SetLighting(AA,AR,AG,AB,DA,DR,DG,DB)	
	self.lightAA=AA
	self.lightAR=AR
	self.lightAG=AG
	self.lightAB=AB
	self.lightDA=DA
	self.lightDR=DR
	self.lightDG=DG
	self.lightDB=DB
end

--TODO: merge with spelleffect_stationary
function TRAININGGROUNDS_Drawable_CharacterModel:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch,zoom)
	--TODO: this doesn't seem to be the best place to setsequencetime.  feels too much like a side effect

	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid
	
	local framescale=self.modelinfo.framescale
	--print(framescale)
	local shadowscale=self.modelinfo.shadowscale
	--print(shadowscale)
	local cameradistance=self.modelinfo.cameradistance
	local cameratargetz=self.modelinfo.cameratargetz
	
	local multiplier=framescale--*shadowscale
	--multiplier=multiplier*(1/zoom)
	--local multiplier=1
	
	--print("Drawable_CharacterModel wid/hgt/zoom",wid,hgt,zoom)
	--print("Drawable_CharacterModel scale",self.frame:GetScale())
	--print("Drawable_CharacterModel modelscale",self.frame:GetModelScale())
	
	self.frame:SetCustomCamera(1)
	if(self.frame:HasCustomCamera()) then
		self:SetOrientation(cameradistance,0,pitch)		

		local pivot=self.modelinfo.pivotadjustment
		self.frame:SetPosition(math.cos(yaw)*pivot,math.sin(yaw)*pivot,0)
		
		self.frame:SetFacing(yaw+math.pi/2)
		self.frame:SetCameraTarget(0,0,cameratargetz)		
	end	
	
	
	self.frame:SetSize(wid*multiplier,hgt*multiplier)
	self.frame:SetModelScale(1/zoom)
	
	--these numbers are based on the old version of TrainingGrounds
	-- (for a brief time, we were using -0.707,-0.707,0.7 instead)
	
	--TODO: lights still look off -- now they're too bright.  decrease lightAA or raise angle slightly?
	self.frame:SetLight(true,false, -1, 0, 0,
						self.lightAA,self.lightAR,self.lightAG,self.lightAB,
						self.lightDA,self.lightDR,self.lightDG,self.lightDB)

	
						
	if(self.sequencemode)then
		local sequencetime=(self.sequencestarttime+(GetTime()-self.sequenceplaybackstarttime)*self.sequencetimescale)*1000
		--print(sequencetime)
		-- SetSequenceTime runs on milliseconds, even if the rest of the game doesn't
		self.frame:SetSequenceTime(self.sequenceindex,sequencetime)
		--self.frame:SetSequenceTime(self.sequenceindex,0)
	end
						
end



function TRAININGGROUNDS_Drawable_CharacterModel:SetClickability()
	self.clickable=true	
	self.clickarea={}
	
	local scale=(self.modelinfo.size/100)
	self.clickarea.x=self.modelinfo.clickboxx*scale
	self.clickarea.y=self.modelinfo.clickboxy*scale
	self.clickarea.width=self.modelinfo.clickboxwidth*scale
	self.clickarea.height=self.modelinfo.clickboxheight*scale
	
	--; self.clickarea.y=-10*self.modelinfo; self.clickarea.width=50; self.clickarea.height=70	
end

-- SOURCE: (modified) www.wowinterface.com/forums/archive/index.php/t-48394.html
-- DO NOT USE SETORIENTATION TO CHANGE MODELFRAME'S FACING (YAW)
-- (it moves the camera around the model, rather than rotating the model,
--  so the light source will be inconsistent between two models.  use SetFacing instead.)
-- in other words, call SetOrientation followed by SetFacing followed by SetCameraTarget.
function TRAININGGROUNDS_Drawable_CharacterModel:SetOrientation(distance, yaw, pitch)
	--if(true) then return end
	-- reminder: in order to set custom camera, frame must be Show()ing already (and remain shown for the rest of the frame)
    -- if self.modelframe:HasCustomCamera() then
		--self.modelframe.distance, self.modelframe.yaw, self.modelframe.pitch = distance, yaw, pitch
        local x = distance * math.cos(yaw) * math.cos(pitch)
        local y = distance * math.sin(- yaw) * math.cos(pitch)
        local z = (distance * math.sin(- pitch))
        self.frame:SetCameraPosition(x, y, z)
		--self.modelframe:SetCameraPosition(x, 0, z)
		--								  z, x, y
		--self.modelframe:SetCameraPosition(5*math.cos(89), 0, 5*math.sin(89))
    -- else
		-- print("WARNING: SetOrientation called on obj without custom camera")
	-- end
end

function TRAININGGROUNDS_Drawable:SetRawAnimation(index,variation,starttime,timescale)
	-- if(self:Class()==TRAININGGROUNDS_VARIMATHRAS_Drawable_Varimathras)then
		-- print("Vari setrawanim",index,variation)
	-- end
	if(not starttime)then
		self.frame:SetAnimation(index,variation)
		self.sequencemode=false		
	else
		-- SetSequenceTime runs on milliseconds, even if the rest of the game doesn't
		self.frame:SetSequenceTime(index,starttime*1000)
		self.sequencemode=true
		self.sequenceindex=index
		self.sequencestarttime=starttime
		self.sequenceplaybackstarttime=GetTime()
		if(timescale==nil)then timescale=1.0 end
		self.sequencetimescale=timescale
	end

end

function TRAININGGROUNDS_Drawable:SetAnimationByNumber(index,variation,starttime,timescale)
	if(not starttime)then
		self.frame:SetAnimation(index,variation)
		self.sequencemode=false
	else
		-- SetSequenceTime runs on milliseconds, even if the rest of the game doesn't
		self.frame:SetSequenceTime(index,starttime*1000)
		self.sequencemode=true
		self.sequencestarttime=starttime
		self.sequenceplaybackstarttime=GetTime()
		if(timescale==nil)then timescale=1.0 end
		self.sequencetimescale=timescale
	end
end