
-- We currently support 0-1 Drawables per GameObject.
-- 

TRAININGGROUNDS_Drawable = {}
TRAININGGROUNDS_Drawable.__index = TRAININGGROUNDS_Drawable

function TRAININGGROUNDS_Drawable.new()
	local self=setmetatable({}, TRAININGGROUNDS_Drawable)	
	
	return self
end

function TRAININGGROUNDS_Drawable:Setup(owner,environment)
	self.owner=owner
	self.environment=environment
	self:SetCustomInfo()
	self:CreateFrame()
	
	self.parentframe=self.environment.frame
	
	--self.frame:SetParent(environment.frame)	
	--self.frame:SetParent(environment.scrollframe)	
	self.x=0
	self.y=0
	self.z=0
	self.width=100
	self.height=100
	self.alpha=1
	self.frame:Show()
	self.frame.owner=self
	self.frame.texture:Show() --necessary in order to respect scrollframe
	self.frame.texture:SetColorTexture(0,0,0,0)	--SetAlpha apparently doesn't work here, but SetColorTexture does
	self:SetFrameAppearance()
	
	self:SetFrameLayer()
	self:SetFrameLevel()
	self:SetClickability()
	
	self:SetAnimationSystem()

	-- SetFrameLevel doesn't take effect on the frame the object is created
		-- so we attempt to set it on the 2nd frame.
	self.updateframelevel=true
	
	
end



function TRAININGGROUNDS_Drawable:SetCustomInfo()
	self.anchor="BOTTOM"
end

function TRAININGGROUNDS_Drawable:CreateFrame()
	--override; don't call super while overriding
	self.frame=TRAININGGROUNDS_ReusableFrames:GetFrame()
	--self.frame.texture:Show()
end

function TRAININGGROUNDS_Drawable:SetFrameAppearance()
	--override; don't call super while overriding
end

function TRAININGGROUNDS_Drawable:SetFrameLayer()
	--override; don't call super while overriding
	self.framelayer=self.environment.camera.defaultframelayer
	--print("Framelayer",self.framelayer)
end

function TRAININGGROUNDS_Drawable:SetFrameLevel()
	--override; don't call super while overriding
	-- if(self.framelayer.level==255)then
		
	-- end
	-- print("Framelevel ", self, self.framelayer.level)
	
	
	
	
	-- if(self.visible and self.framelayer==self.environment.camera.defaultframelayer)then
		-- --TODO: instead of checking self.visible, it would be better simply not to set a drawable in the first place...
		-- print("Drawable's framelayer was not set.  Attempting to crash trace...")		
		-- local crashobj=self.owner:Class().new()
		-- -- TODO: some objs don't even have a SetCustomInfo.  we may need a "crashtrace=function() error(0) end" addition to the class template
		-- crashobj.SetCustomInfo(nil)
	-- end
	
	self.frame:SetFrameLevel(self.framelayer.level)
	--self.frame:SetFrameLevel(self.framelayer.level)
end


function TRAININGGROUNDS_Drawable:SetClickability()
	-- override. don't call super when overriding
	-- setup function will create a debug-visible clickframe if clickable==true AND frame is visible and not nil.
	-- for various convenience reasons, clickarea is setpoint(bottom, bottom) instead of center/center or bottomleft etc.
	--TODO LATER: maybe option for center+center?
		
	--TODO: clickarea should be defined in drawable and scale up with framescale
	
	-- remember to call SetClickability again if you ever resize an object after setup!
	
	self.clickable=false	
	self.clickarea={}
	self.clickarea.x=0*4; self.clickarea.y=0*4; self.clickarea.width=100; self.clickarea.height=100	
end

function TRAININGGROUNDS_Drawable:SetAnimationSystem()
	--TODO: change to empty virtual function
	-- animation is not used by base drawable class, but can be used by child classes	
	self.animationsystem=TRAININGGROUNDS_AnimationSystem.new()
	self.animationsystem:Setup(self)
end

function TRAININGGROUNDS_Drawable:SetAlpha(alpha)
	self.alpha=alpha
end

function TRAININGGROUNDS_Drawable:ShowFrames()	
	if(self.frame)then
		--print("ShowFrames() alpha",self.alpha)
		--TRAININGGROUNDS_FrameVisibilityCheck(self.frame)
		self.frame:SetAlpha(self.alpha)
	end
end

function TRAININGGROUNDS_Drawable:HideFrames()	
	if(self.frame)then
		self.frame:SetAlpha(0)
	end
end


function TRAININGGROUNDS_Drawable:SetEquipment(equipment)
	--override
	--TODO: maybe throw a warning message if we call SetEquipment on a drawable that doesn't support it
end

-- mostly used for ysort...
function TRAININGGROUNDS_Drawable:SetSortedFrameLevels(level)
	self.frame.framelevel=level
	self.frame:SetFrameLevel(level)
	
	----TODO: modelframe might still be needed, but what was "nameplate" used for?  resources?
	-- if(v.modelframe~=nil)then 
		-- v.modelframe.framelevel=layer
		-- v.modelframe:SetFrameLevel(layer) 					
	-- end	
	-- if(v.nameplate~=nil)then
		-- layer=layer+1
		-- v.nameplate:SetAllFrameLevels(layer)
	-- end
end

-- --TODO: could probably use a rename for contrast with "sortedframelevels"
-- --TODO: use for shadows too (currently just resourcebars)
-- function TRAININGGROUNDS_Drawable:SetCustomFrameLevels(preysortlevel,postysortlevel)
	-- --override
-- end

-- called pretty much exclusively from 2d camera.
-- we must set frame size at the same time as orientation because model frames must use SetCameraPosition to set both.
-- yaw corresponds to model facing
-- pitch corresponds to camera height
function TRAININGGROUNDS_Drawable:ArrangeFrame(parentanchor,x,y,wid,hgt,yaw,pitch,zoom)
	--override; don't call super when overriding
	self.frame:SetParent(self.parentframe)
	--print("Drawing",self.frame.name)
	-- if(self.frame.name=="TRAININGGROUNDS_ReusableFrame62")then
		-- print("Frame62's parent is",self.parentframe,self.frame:GetParent())
	-- end
	if(self.parentframe==UIParent)then		
		print("WARNING:",self.frame.name,"parent is UIParent")
	end
	if(self.frame:GetParent()==UIParent)then
		print("WARNING:",self.frame.name,"parent is UIParent")
	end
	self.frame:ClearAllPoints()
	self.frame:SetPoint(self.anchor,self.parentframe,parentanchor,x,y)	
	self:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch,zoom)
end

function TRAININGGROUNDS_Drawable:SetFrameSizeAndOrientation(wid,hgt,yaw,pitch)
	--override; don't call super when overriding
	self.frame:SetSize(wid,hgt)
end




function TRAININGGROUNDS_Drawable:TryDirectedSpellcast()
	self:SetAnimation(TRAININGGROUNDS_ANIMATION_LIST.SPELLCAST_DIRECTED)
end
--TODO: clean up names -- "complete" vs "finish"
function TRAININGGROUNDS_Drawable:TryCompleteDirectedSpellcast()
	self:StopSpellcast()
	self:SetAnimationAndRestart(TRAININGGROUNDS_ANIMATION_LIST.SPELLCAST_DIRECTED_FINISH)
end

function TRAININGGROUNDS_Drawable:StopSpellcast()
	self.animationsystem:ClearAnimationByCategory(TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING)
end

--TODO: TryAttackMelee function which checks character's equipped weapon

function TRAININGGROUNDS_Drawable:TryAttackUnarmed()
	self:SetAnimationAndRestart(TRAININGGROUNDS_ANIMATION_LIST.Attack2H)
end

function TRAININGGROUNDS_Drawable:TryAttack2H()
	self:SetAnimationAndRestart(TRAININGGROUNDS_ANIMATION_LIST.Attack2H)
end

function TRAININGGROUNDS_Drawable:TryAttack2HL()
	self:SetAnimationAndRestart(TRAININGGROUNDS_ANIMATION_LIST.Attack2HL)
end

function TRAININGGROUNDS_Drawable:TryTaunt()
	self:SetAnimationAndRestart(TRAININGGROUNDS_ANIMATION_LIST.TAUNT)
end

function TRAININGGROUNDS_Drawable:Step(elapsed)
	--TODO: empty virtual function, maybe
end

function TRAININGGROUNDS_Drawable:PreDraw(elapsed)
	if(self.animationsystem)then
		self.animationsystem:PreDraw(elapsed)
	end
end

function TRAININGGROUNDS_Drawable:Cleanup()
	if(self.frame)then
		self.frame:Cleanup()
	end
end

function TRAININGGROUNDS_Drawable:SetAnimation(sequence)
	self.animationsystem:SetAnimation(sequence)
end

function TRAININGGROUNDS_Drawable:SetAnimationAndRestart(sequence)
	self.animationsystem:SetAnimationAndRestart(sequence)
end

function TRAININGGROUNDS_Drawable:SetAnimationByNumber(index,variation,starttime,timescale)
	--override
end

function TRAININGGROUNDS_Drawable:SetRawAnimation(index,variation,starttime,timescale)
	--override
end