
TRAININGGROUNDS_Spell = {}
TRAININGGROUNDS_Spell.__index = TRAININGGROUNDS_Spell
function TRAININGGROUNDS_Spell.new()
	local self=setmetatable({}, TRAININGGROUNDS_Spell)
	return self
end

function TRAININGGROUNDS_Spell:Setup(castercombat, targetcombat, multitargetcombats)
	--print("A spell",self,"is setup with caster",castercombat)
	-- TODO: maybe rename caster to combat? (or just castercombat)
	--TODO: we should probably rename "caster" to "castercombat", etc
	self.castercombat=castercombat
	-- TODO: target could be nil or a coordinate pair/triplet...
	self.targetcombat=targetcombat
	self.targetlocation=nil
	self.multitargetcombats=multitargetcombats
	
	self.offcooldowntime=nil
	self.nextrechargetime=nil
	-- We also track when a spell first went on cooldown, in case the cooldown needs to be adjusted for changes to haste.
	-- Also, whenever a spell gains a charge, oncooldowntime is set to whenever nextrechargetime occurred.
	self.oncooldowntime=nil	
	self.caststarttime=nil
	self.castendtime=nil
	self.channelstarttime=nil
	self.channelendtime=nil
	
	--TODO: replace with overridable function (see CreateProjectile function further down)
	self.projectileclass=nil
	
	-- Certain chain-cast boss spells break when you queue while casting
	--TODO: better system than this
	self.blockqueueingwhilecasting=false
	
	
	self:SetCustomInfo()	
	self:SetRechargeInfo()
	
	-- the following two are for debug, mostly.
	-- "queue" and "instance" don't do anything themselves,
	-- but we mark various instances of each spell to keep track of their intended use
	-- (and check that those spells have indeed been marked as such when it's time to use them)
	self.queue=false
	self.instance=false
end

TRAININGGROUNDS_SpellBossCastingStyle={}
--TODO: TARGETLESS should probably be 0
TRAININGGROUNDS_SpellBossCastingStyle.UNDEFINED=0
TRAININGGROUNDS_SpellBossCastingStyle.CURRENTTARGET=1
TRAININGGROUNDS_SpellBossCastingStyle.RANDOMRANGED=2
TRAININGGROUNDS_SpellBossCastingStyle.TARGETLESS=3
-- Spreads a debuff on as many players as possible, avoiding the tanks unless all other players are debuffed or dead. --TODO LATER: or out of range, maybe?
TRAININGGROUNDS_SpellBossCastingStyle.SPREADDEBUFF_NONTANK=4

function TRAININGGROUNDS_Spell:GetName()
	return "Unnamed spell (you shouldn't see this)"
end

function TRAININGGROUNDS_Spell:SetCustomInfo()
	-- Undecided whether facing will be enforced in TrainingGrounds.
	-- Even if facing isn't enforced,
	-- this attribute determines whether characters automatically turn to face their target.
	self.requiresfacing=true
	
	self.projectileclass=nil
	
	self.basecastduration=2.000
	


	-- A basecooldown of 0 indicates no cooldown.
	-- By default, spells with multiple charges will regain charges at the same rate as basecooldown.
	-- Certain spells have a different recharge rate, which should be set in SetRechargeInfo.	
	self.basecooldown=0
	
	
	self.basegcd=1.500
	self.respectsgcd=true
	
	--self.range=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(40.0)
	self.range=nil
	self.melee=false	-- melee attacks measure edge-to-edge, ranged attacks measure center-toedge
						-- TG "melee range" is 2 yards
	--TODO: maybe this should default to true
	self.requirestarget=false
	
	--TODO: move to TRAININGGROUNDS_Spell_Boss?
	self.bosscastingstyle=TRAININGGROUNDS_SpellBossCastingStyle.CURRENTTARGET
	self.min_ranged=3
	self.num_targets=1
end

function TRAININGGROUNDS_Spell:SetRechargeInfo()
	-- spells which don't use "charges" should have a maxcharges of 1.
	-- If a spell shouldn't regain charges over time, set it to nil instead.
	self.maxcharges=1
	self.charges=self.maxcharges
	self.rechargerate=self.basecooldown
end




--TODO: TurnAtSpeed shouldn't stack if called multiple times per frame.
-- 			Do something with targetfacing (but we're probably using a variable with that name already).



function TRAININGGROUNDS_Spell:GetFinalOffCooldownTime()
	local offcooldowntime=self.offcooldowntime
	if(self.respectsgcd)then
		local offgcdtime=self.castercombat.offgcdtime
		if(offgcdtime and offcooldowntime)then
			offcooldowntime=math.max(offcooldowntime,offgcdtime)
		end
		--print("respectsGCD check")
	end
	
	return offcooldowntime
end

function TRAININGGROUNDS_Spell:ApplyGCD(currenttime)		
	self.castercombat.offgcdtime=currenttime+self.basegcd
	--print("GCD set to",self.castercombat.offgcdtime)
end

function TRAININGGROUNDS_Spell:GetCastDuration()
	return self.basecastduration
end

function TRAININGGROUNDS_Spell:CalculateCastEndTime(caststarttime)
	return caststarttime+self:GetCastDuration()
end

function TRAININGGROUNDS_Spell:GetCastEndTime()
	return self.castendtime
end

function TRAININGGROUNDS_Spell:GetChannelEndTime()
	return self.channelendtime
end



--TODO: behavior set for existing channel, and means by which the two sets interact if they conflict

--This behavior set affects THIS spell which we're trying to cast during another spell's channel.
--New spell will interrupt the channel (unless channel clip is prohibited by combat module).  Standard behavior.
TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_INTERRUPT=1
--New spell will be cast at the same time as the channel.
TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_SIMULTANEOUS=2
--New spells cannot be cast at all during the channel (though they can be queued if channel is about to end).
TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_PROHIBIT=3

function TRAININGGROUNDS_Spell:CastableWhileChannelingBehavior()
	return TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_INTERRUPT
end


-- Returns nil if spell can be cast; otherwise returns error code.
function TRAININGGROUNDS_Spell:CheckSpecialCastConditions(castercombat,targetcombat)
	--override; don't call super when overriding
	if(self.requirestarget and (not targetcombat))then
		--TODO: errorcode should be a class with humanreadable AND machinereadable feedback
		return "There is nothing to attack."
	end
	
	return nil
end

-- Returns nil if spell can be cast; otherwise returns error code.
function TRAININGGROUNDS_Spell:CheckSpellRange(castercombat,targetcombat)
	if(self.range==nil)then return nil end
	
	local currentdist=castercombat.owner:GetSpellDistanceToMobile(targetcombat.owner,self)
	--print("SpellDistanceToMobile:",dist)
	local maxdist=self:GetFinalSpellRange(castercombat)
	--print("SpellRange:",maxdist)
	if(currentdist>maxdist)then 
		return "Out of range."
	end
	
	--override; don't call super when overriding
	return nil
end

function TRAININGGROUNDS_Spell:GetFinalSpellRange(castercombat)
	--TODO: check for auras that affect spell range
	return self.range
end

function TRAININGGROUNDS_Spell:ConfirmQueue()
	-- by getting here without crashing, we've confirmed that self points to a valid Spell
	-- as long as we're here, label this as an instance	
	self.queue=true
end

function TRAININGGROUNDS_Spell:ConfirmInstance()
	-- by getting here without crashing, we've confirmed that self points to a valid Spell
	-- as long as we're here, label this as an instance
	self.instance=true
end

--TODO: potential shenanegans with queueing a spell with one target, but casting it on another target
function TRAININGGROUNDS_Spell:NewQueue()	
	local spellinstance=self:Class().new()
	-- we're copying this spell from the main template, so we won't have a target yet.
	spellinstance:Setup(self.castercombat,nil)
	spellinstance:SetQueuedTarget()
	-- TODO: set queuespell's target somewhere
	spellinstance:ConfirmQueue()
	return spellinstance
end

function TRAININGGROUNDS_Spell:SetQueuedTarget()
	-- some spells are untargeted even if the caster is targeting someone.
		-- in that case, override without calling super.
	if(self.castercombat)then
		self.targetcombat=self.castercombat.targetcombat
	end
end

function TRAININGGROUNDS_Spell:NewCast()
	local spellinstance=self:Class().new()
	spellinstance:Setup(self.castercombat,self.targetcombat)
	spellinstance:ConfirmInstance()	
	return spellinstance
end

---------------- Instance functions ----------------------
function TRAININGGROUNDS_Spell:StartCasting(caststarttime)
	--override; call super when overriding
	self.caststarttime=caststarttime
	self.castendtime=self:CalculateCastEndTime(caststarttime)
	--TODO: GCD
	self:BeginCastingAnimationFunction()
end

function TRAININGGROUNDS_Spell:CompleteCasting(castendtime)	
	self:ApplyAutoAttackIfRelevant(castendtime)
	self:CompleteCastingEffect(castendtime)
	--TODO: cooldown	
	self:CompleteCastingAnimationFunction()
	if(self.requiresfacing)then
		--TODO: check animation's ENDCAST duration instead
		self.castercombat.lockfacingendtime=self.castercombat.localtime+1.000
		if(self.targetlocation)then
			self.castercombat.lockfacinglocation=self.targetlocation
			--TODO: combatmodule ignores lockfacinglocation/endtime if lockfacingendtime is invalid.  should it?
			self.castercombat.lockfacinglocationendtime=self.castercombat.localtime+1.000
		end
	end

end

function TRAININGGROUNDS_Spell:ApplyAutoAttackIfRelevant(castendtime)
	--TODO: check if we should actually apply autoattack
	--TODO: check current target
	--TODO: apply castendtime (may require rewriting autoattackmodule)
	self.castercombat:StartAttacking()
end

function TRAININGGROUNDS_Spell:CompleteCastingEffect(castendtime)
	--TODO: MAYBE pass castendtime to projectile -- but probably not.	
	local projectile=self:CreateProjectile()	
end


function TRAININGGROUNDS_Spell:CompleteChanneling(channelendtime)
	--TODO:	NYI
end

function TRAININGGROUNDS_Spell:StopCasting(caststoptime)
	--TODO:	NYI
end

function TRAININGGROUNDS_Spell:StopChanneling(channelstoptime)
	--TODO:	NYI
end



function TRAININGGROUNDS_Spell:CreateProjectile()
	--TODO: don't use class.new()
	-- 		why were we even using class.new()

	--override if spell uses multiple projectiles or is otherwise nonconventional.
	
	-- not all spells have projectiles.
	if(self.projectileclass)then
		local projectiles={}
		local projectile
		if(self.multitargetcombats==nil)then
			projectile=self.projectileclass.new()
			tinsert(projectiles,projectile)
			--
		else
			for i=1,#self.multitargetcombats do
				projectile=self.projectileclass.new()
				tinsert(projectiles,projectile)
			end
		end
		
		for i=1,#projectiles do
			projectile:Setup(self.castercombat.owner.environment,self)			
			projectile.x=self.castercombat.owner.x
			projectile.y=self.castercombat.owner.y
			--TODO: get x+y+z offsets from caster's modelinfo
			projectile.z=50
		end
		
		

	end
	
end

--TODO: a lot of spells shouldn't have a BeginCastingAnimationFunction
function TRAININGGROUNDS_Spell:BeginCastingAnimationFunction()
	--TODO: not sure whether baseline should have animation or not
	--self.castercombat.owner.drawable:TryDirectedSpellcast()
	
	-- do nothing
end

function TRAININGGROUNDS_Spell:CompleteCastingAnimationFunction()
	--print("TRAININGGROUNDS_Spell: TryCompleteDirectedSpellcast")
	
	self.castercombat.owner.drawable:TryCompleteDirectedSpellcast()
end

function TRAININGGROUNDS_Spell:ExecuteSpellEffect(projectile)
	--override
end

function TRAININGGROUNDS_Spell:GetBossTarget()
	--override
	--TODO: maybe move to TRAININGGROUNDS_BossSpell
	
end