TRAININGGROUNDS_CombatModule = {}
TRAININGGROUNDS_CombatModule.__index = TRAININGGROUNDS_CombatModule
function TRAININGGROUNDS_CombatModule.new()
	local self=setmetatable({}, TRAININGGROUNDS_CombatModule)	
	return self
end

function TRAININGGROUNDS_CombatModule:Setup(owner)

	self.owner=owner	

	self.auramodule=TRAININGGROUNDS_AuraModule.new()
	self.auramodule:Setup(self)
	--print("self.auras",self.auras)
	
	self.combatlog=owner.environment.game.scenario.combatlog
	
	self.spellbook={}		
	
	self.localtime=0
	
	self:SetCustomInfo()
	
	self.queuedspell=nil
	
	self.castedspell=nil
	self.channeledspell=nil
	
	
	
	self.offgcdtime=nil
	--GCD can have multiple charges.  (TODO: NYI)
	self.nextgcdchargetime=nil
	self.ongcdtime=nil
	
	-- Target expects another CombatModule.
	self.targetcombat=nil
	--TODO: maybe move multitarget to CombatModule_Boss
	self.multitarget={}
	--treat targetcoords as a list of coords, not just single coords
	self.targetcoords={}

	self.lockfacingendtime=nil
	self.lockfacinglocation=nil
	self.lockfacinglocationendtime=nil
		
	--TODO: global-ish var?
	self.queuetolerance=(400)/1000.0
end

function TRAININGGROUNDS_CombatModule:SetCustomInfo()
	--TODO: some or most or all of these should go in Setup instead
	
	--override; call super when overriding
	self:CreateRaidRole()
	--print("CombatModule:SetCustomInfo()")
	self:CreateSpells()
	self:CreateAutoSpell()
	self:CreateAutoAttack()
end


function TRAININGGROUNDS_CombatModule:CreateRaidRole()
	--override; don't call super when overriding
	self.raidrole=TRAININGGROUNDS_RaidRole_RDPS.new()
	self.raidrole:Setup(self)
end

function TRAININGGROUNDS_CombatModule:CreateSpells()
	--print("BASE CREATESPELLS; ERROR")
	--override
end

function TRAININGGROUNDS_CombatModule:CreateAutoAttack()
	self.autoattackmodule=TRAININGGROUNDS_AutoAttackModule.new()
	self.autoattackmodule:Setup(self)
end

-- deprecated, maybe
function TRAININGGROUNDS_CombatModule:CreateAutoSpell()
	--TODO: offhand autoattack
	self.autospell=TRAININGGROUNDS_Spell_SampleAutoAttack.new()
	self.autospell:Setup(self,nil)
	self.swingtimer=2.0	--TODO: apparently not used! (set in autoattackmodule instead, currently defaults to 1.5)
	--self.swingtimer=1.0
	--TODO: verify that Class() works as expected -- it was provided with inheritsFrom()
	--TODO: MAYBE rename spellbook to spells -- but also likely we instead keep a separate spells table
	-- 		and use spellbook to store just the base spell class
	tinsert(self.spellbook,self.autospell:Class())
end

-- TODO:
function TRAININGGROUNDS_CombatModule:DontClipChannels()
	--This setting only prevents clipped channels at the very end of the channel.
	return true	
end

-- TODO: do we still need to pass elapsed to classes during Step, if those classes also have IncrementTime?
-- TODO: check whether other important classes are using IncrementTime
function TRAININGGROUNDS_CombatModule:IncrementTime(elapsed)
	self.localtime=self.localtime+elapsed
end


function TRAININGGROUNDS_CombatModule:StartAttacking()
	--print(self,"StartAttacking")
	if(self.autoattackmodule)then
		self.autoattackmodule:StartAttacking()
	end
end

function TRAININGGROUNDS_CombatModule:Step(elapsed)

	if(self.autoattackmodule)then
		if(self.targetcombat==nil)then
			--TODO: this will break certain bosses who temporarily clear target to cast spells
				--(maybe the cleared-target situation is just cosmetic?)
			self.autoattackmodule:StopAttacking()
		else
			self.autoattackmodule:Step(elapsed)
		end
	end

	local castendtime=nil
	local channelendtime=nil
	local queuetime=nil
	if(self.castedspell)then
		castendtime=self.castedspell:GetCastEndTime()
	end
	if(self.channeledspell)then
		channelendtime=self.channeledspell:GetChannelEndTime()
	end
	if(castendtime)then queuetime=castendtime end
	if(channelendtime and channelendtime>queuetime) then queuetime=channelendtime end
	if(not queuetime)then queuetime=self.localtime	end
	
	--Before casting the queued spell, resolve the current casted/channeled spell if it exists
	if(castendtime and self.localtime>=castendtime)then
		self:CompleteCastingCurrentSpell(castendtime)
	
	end
	if(channelendtime and self.localtime>=channelendtime)then
		self:CompleteChannelingCurrentSpell(channelendtime)
	end	
	
	
	if(self.queuedspell)then
		if(self.localtime>=queuetime)then
			--TODO: CastableWhileCasting, CastableWhileChanneling checks
			--TODO: ignore this check somehow if we call from boss override
			local errorcode=self:TryQueue(self.queuedspell)
			if(not errorcode)then	
				--TODO: pass queuedspell to NewCast and transfer spell's target from there.
				local spellinstance=self.queuedspell:NewCast()
				-- so:
				-- we just removed a very similar line from code that called NewQueue.
				-- however, FOR THE MOMENT, it stays here.
				-- otherwise player could queue, switch targets while queueing, and the spell would hit the new target
					-- This isn't the same as start CASTING then switch targets.
					-- We haven't started casting the spell yet.
				spellinstance.targetcombat=self.queuedspell.targetcombat
				
				spellinstance:StartCasting(queuetime)				
				self.castedspell=spellinstance
				--print("Casting spell:",spellinstance,"at time",queuetime,"(local time"..self.localtime..")")
				
				--TODO: for the purposes of this training program, maybe only boss spells need to trigger this event?
				self.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.START_CASTING,
							caster=self,
							subject=spellinstance:Class(),
							target=spellinstance.targetcombat
							})
				
			end
			
			self.queuedspell=nil
		end
	end
	
	
	if(self.castedspell)then
		
	elseif(self.channeledspell)then
	
	end

	local currentspell
	if(self.castedspell and self.castedspell.requiresfacing)then currentspell=self.castedspell end
	if(self.channeledspell and self.channeledspell.requiresfacing)then currentspell=self.channeledspell end
	
	--facing control
	-- there are other facing controls in spell.completecasting
	--TODO: if we ever decide facing is actually honest-to-goodness required for real, this promptly breaks everything
	if(currentspell)then
		self.lockfacingendtime=self.localtime+1
	end
	local coords=nil
	--TODO: combatmodule ignores lockfacinglocation/endtime if lockfacingendtime is invalid.  should it?
	if(currentspell and self.lockfacingendtime and self.localtime<=self.lockfacingendtime)then			
		if(self.lockfacinglocation and self.localtime<=self.lockfacinglocationendtime)then
			coords=self.lockfacinglocation
		elseif(currentspell.targetlocation)then 		
			coords=currentspell.targetlocation 
		elseif(currentspell.targetcombat)then 
			coords=currentspell.targetcombat:GetLocation()
		end
	end
	if(coords)then
		-- print("Coords:",coords)
		-- print("Owner:",self.owner)
		--local targetfacing
		self.owner.targetfacing_spellcast=math.atan2(coords[2]-self.owner.y,coords[1]-self.owner.x)
		self.owner:SetTurnspeed(10)	
	else
		self.owner.targetfacing_spellcast=nil
	end
	
end

function TRAININGGROUNDS_CombatModule:GetLocation()
	return self.owner:GetLocation()
end


function TRAININGGROUNDS_CombatModule:IsIdle()
	--TODO: if spellcast+GCD is less than X ms until cooldown ends
	return ((self.offgcdtime==nil) or (self.offgcdtime<=self.localtime))
	--return(self:CheckTryQueueSpellTimingOK(self.autospell)==nil and self.queuedspell==nil)
	
end

function TRAININGGROUNDS_CombatModule:TryAuto()
	local errorcode=nil
	if(not self.queuedspell)then
		--print("Owner",self.owner,"tries TryAuto",self.autospell,"whose caster is",self.autospell.castercombat)
		-- override; don't call super when overriding
		local queuespell=self.autospell:NewQueue()
		--queuespell.targetcombat=self.targetcombat		-- DEPRECATED, REMOVE
			--TODO: set queuespell's target somewhere
		errorcode=self:TryQueue(queuespell)
	end
	return errorcode
end

-- In order to queue a spell, the player must have resources available at the time TryQueue is called.
-- If the resources would only become available by the time the spell is cast, TryQueue will fail.
-- Returns nil if spell queued successfully; otherwise returns error code.
function TRAININGGROUNDS_CombatModule:TryQueue(queuespell)
	if(self.castedspell)then
		if(self.castedspell.blockqueueingwhilecasting)then
			return "You are busy doing something else"
		end
	end
	if(self.channeledspell)then
		if(self.channeledspell.blockqueueingwhilecasting)then
			return "You are busy doing something else"
		end
	end	
	if(not queuespell.queue)then
		error("Tried to queue a non-queue instance of a spell")
		return
	end
	local spellstatuserrorcode=self:CheckSpellQueueableStatusExceptCooldown(queuespell)
	if(not spellstatuserrorcode)then
		--print("Timing check...")
		local timingerrorcode=self:CheckTryQueueSpellTimingOK(queuespell)
		if(not timingerrorcode)then
			--queue the spell
			self.queuedspell=queuespell
			return nil
		else
			return timingerrorcode
		end
	else
		return spellstatuserrorcode
	end	
end

-- Returns nil if spell is OK to cast; otherwise returns error code.
function TRAININGGROUNDS_CombatModule:CheckSpellQueueableStatusExceptCooldown(queuespell)
	--TODO: check resources
	--TODO: check valid target
	local errorcode=nil
	
	errorcode=queuespell:CheckSpecialCastConditions(self,queuespell.targetcombat)
	
	if(not errorcode)then
		errorcode=queuespell:CheckSpellRange(self,queuespell.targetcombat)
	end
	
	-- if(not errorcode)then
		-- spell:CheckSpellRange(spell.
	-- end
	
	--TODO: AI needs to hear about errorcodes (especially "Out of range.")
	return errorcode
end

-- Returns nil if spell is OK to cast; otherwise returns error code.
function TRAININGGROUNDS_CombatModule:CheckTryQueueSpellTimingOK(spell)
	local errorcode=nil
	--Spell off cooldown?
	local oct=spell:GetFinalOffCooldownTime()
	if(oct)then
		if(oct>self.localtime+self.queuetolerance)then
			errorcode="TRAININGGROUNDS_CASTERRORCODE_COOLDOWN"
		end
	end
	--Castable while casting?
	if(self.castedspell)then
		--TODO: local castbehavior = spell:GetCastableWhileCastingBehavior()
		local ect=self.castedspell:GetCastEndTime()		
		if(ect)then
			if(ect>self.localtime+self.queuetolerance)then								
				errorcode="TRAININGGROUNDS_CASTERRORCODE_FAILSILENTLY_ALREADYCASTING"
			end
		end
	end
	--Castable while channeling?
	--TODO: WARNING: not tested yet.  logic probably wrong.
	if(self.channeledspell)then
		local ect=self.channeledspell:GetChannelEndTime()
		local channelbehavior=spell:CastableWhileChannelingBehavior()
		if(channelbehavior==TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_SIMULTANEOUS)then
			--no error; pass through
		elseif(channelbehavior==TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_PROHIBITED)then
			if(ect)then
				if(ect>self.localtime+self.queuetolerance)then
					errorcode="TRAININGGROUNDS_CASTERRORCODE_FAILSILENTLY_ALREADYCHANNELING"
				end
			end
		elseif(channelbehavior==TRAININGGROUNDS_CASTABLEWHILECHANNELBEHAVIOR_INTERRUPT)then
			--no error; pass through
		end
	end

	if(self:DontClipChannels())then
		if(self.channeledspell)then
			--TODO: 
			
			
		end
	end
	
	return errorcode
end

--TODO: decide if we check if spell exists here, or before calling function
-- (currently before calling function)
function TRAININGGROUNDS_CombatModule:CompleteCastingCurrentSpell(castendtime)
	--print("CombatModule calling CompleteCastingCurrentSpell, castendtime",castendtime)

				--TODO: for the purposes of this training program, maybe only boss spells need to trigger this event?
				--TODO: timestamps in combatlog events
				--TODO: also report STOP_CASTING
				self.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.COMPLETE_CASTING,
							caster=self,
							subject=self.castedspell:Class(),
							target=self.castedspell.targetcombat
							})		
							
	self.castedspell:CompleteCasting(castendtime)
	self.castedspell=nil

end
function TRAININGGROUNDS_CombatModule:CompleteChannelingCurrentSpell(channelendtime)
	self.channeledspell:CompleteChanneling(castendtime)
	self.channeledspell=nil
		--TODO: do we report COMPLETE_CASTING, COMPLETE_CHANNELING, or both?
end
function TRAININGGROUNDS_CombatModule:StopCastingCurrentSpell(caststoptime)
	self.castedspell:StopCasting(caststoptime)
	self.castedspell=nil
end
function TRAININGGROUNDS_CombatModule:StopChannelingCurrentSpell(channelstoptime)
	self.channeledspell:StopChanneling(channelstoptime)
	self.channeledspell=nil
end


function TRAININGGROUNDS_CombatModule:AddAllSpellsToTable(spellstable)
	TRAININGGROUNDS_MergeTables(spellstable,self.spellbook)
end

--TODO: maybe child class CombatModule_Boss
function TRAININGGROUNDS_CombatModule:OverrideCastBossSpell(spell)
	print("OverrideCastBossSpell")

	--TODO: confirm new spell is allowed before stopcasting
	if(self.castedspell)then
		self:StopCastingCurrentSpell(self.localtime)
	end
	if(self.channeledspell)then
		self:StopCastingCurrentSpell(self.localtime)
	end
	
	--TODO: coneofdeath cast animation should reset to start of animation if overridden by itself
	
	--local target=nil
	--target=self.bosscontroller:GetSpellTarget(spell)
	--target=self.bosscontroller:GetSpellTarget(boss,spell)
	
	
	
	
	--print("CombatModule: A")
	if(spell.bosscastingstyle==TRAININGGROUNDS_SpellBossCastingStyle.CURRENTTARGET)then		
		local queuespell=spell:NewQueue()
		-- queuespell.targetcombat=self.targetcombat	-- DEPRECATED, REMOVE
		local errorcode=self:TryQueue(queuespell)
	elseif(spell.bosscastingstyle==TRAININGGROUNDS_SpellBossCastingStyle.RANDOMRANGED)then		
		--print("CombatModule: B")
		local targets=self.owner.environment.game.scenario:GetRandomRangedTargetCombats(spell.min_ranged,spell.num_targets)
		--TODO: fail (more) gracefully if no targets are available
		if(#targets>0)then
			--print("CombatModule: C")
			--TODO:
			if(spell.num_targets==1)then
				self.targetcombat=targets[1]
			end
			--TODO: combine queue code, and probably don't forcequeue so abruptly			
			local queuespell=spell:NewQueue()
			-- queuespell.targetcombat=self.targetcombat	-- DEPRECATED, REMOVE
			local errorcode=self:TryQueue(queuespell)
			--TODO: if there's an error, override it somehow
			
			--print("Queuespell",queuespell,"on target",self.targetcombat,"with owner",self.targetcombat.owner)
		end
	--TODO: removeduplicate code
	elseif(spell.bosscastingstyle==TRAININGGROUNDS_SpellBossCastingStyle.TARGETLESS)then
		--TODO: combine queue code, and probably don't forcequeue so abruptly			
		local queuespell=spell:NewQueue()
		-- queuespell.targetcombat=self.targetcombat	-- DEPRECATED, REMOVE
		local errorcode=self:TryQueue(queuespell)
		--TODO: if there's an error, override it somehow
	
	else
		print("Tried to queue up a spell but its bosscastingstyle is undefined!")
	end
end


--called during aura.setup; adds an instance to the newauras list
-- NOT TO BE CONFUSED WITH ApplyAura, which creates a new aura from scratch
-- TODO: name change
-- TODO: disambiguate with ApplyAuraByClass below
function TRAININGGROUNDS_CombatModule:AddNewAura(aura)
	--print("CombatModule:AddNewAura",self.auramodule,self.auramodule.newauras)
	tinsert(self.auramodule.newauras,aura)
end


function TRAININGGROUNDS_CombatModule:IncomingDamage(amount,spellschool,sourcecombat,sourceability,sourceabilitytemplate)
	-- TODO: spellschool isn't implemented
	-- TODO: (nothing else is implemented either)
	
	self:FlashDamageFlash_Alert()
	
	
end


--TODO: ApplyAuraByClass needs a localtime parameter, and/or maybe don't apply auras until the following frame (like gameobjects)
function TRAININGGROUNDS_CombatModule:ApplyAuraByClass(auraclass, castercombat)
	if(not castercombat)then
		error("Assertion failed: applied aura's castercombat was unspecified or nil")
	end

	local aurainstance=(auraclass).new()
	aurainstance.castercombat=castercombat
	-- must use target's localtime instead of caster's
	-- (remember, localtime starts from 0 at combatmodule.setup)
	--TODO: do we instead need to calculate a new time relative to global?
	--TODO: does localtime have the correct value here, or is it lagging one frame behind?				
	aurainstance:Setup(castercombat,self,self.localtime)
	
	--TODO: check whether aura stacks or ignites
	
	--print("AURA_APPLIED:",TRAININGGROUNDS_CombatEventType.AURA_APPLIED)	
	
	--TODO: rewrite combatlog reference so it's clear that "self.combatlog" is a pointer to scenario's combatlog
	self.combatlog:RecordEvent({
								action=TRAININGGROUNDS_CombatEventType.AURA_APPLIED,
								subject=auraclass,
								target=self
								})
	
	return aurainstance
	
	--print("VoidZone: created aura")
end


function TRAININGGROUNDS_CombatModule:FlashDamageFlash_Alert()
	if(self.damageflash)then
		self.damageflash.alert_starttime=self.localtime
	end
end

function TRAININGGROUNDS_CombatModule:Cleanup()
	--TODO: cleanup
end