
do
	local super=TRAININGGROUNDS_Aura
	TRAININGGROUNDS_Aura_Grip = TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_Aura_Grip

	function class:Setup(castercombat,targetcombat,localtime)
		super.Setup(self,castercombat,targetcombat,localtime)
		self.targetx=nil
		self.targety=nil
		self.targetz=nil
		self.startx=nil
		self.starty=nil
		self.startz=nil
	end
	
	--TODO: check start and end z-coordinate
	function class:SetCustomInfo()
		super.SetCustomInfo(self)

		-- Distance per second.
		self.gripspeed=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(60)
		-- Distance the mob will be lifted into the air from a "full" grip.
		self.archeight=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(3)
		-- Distance of a "full" grip.  --TODO: rename, probably
		self.archeightstandardwavelength=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(30)
	end
	
	function class:SetupNewauraLists(auramodule)
		super.SetupNewauraLists(self,auramodule)
		tinsert(self.auramodulelists,auramodule.grip)
	end
	
	function class:MoveMobile(elapsed)
		local position={x=0,y=0,z=0}
		local mob=self.targetcombat.owner
		--TODO: not sure we want to set speed to 0 (but at the moment, the alternatives are worse)
		mob.xspeed=0
		mob.yspeed=0
		mob.zspeed=0
		--TODO: we're currently ignoring grip speed/distance on the Z-axis.  should we?
		local distx=self.targetx-mob.x
		local disty=self.targety-mob.y
		local distsqr=distx*distx+disty*disty
		local dist=math.sqrt(distsqr)
		local unitvectorx=distx/dist
		local unitvectory=disty/dist
		local scalar=self.gripspeed*elapsed
		
		if(dist>scalar)then
			mob.x=mob.x+unitvectorx*scalar
			mob.y=mob.y+unitvectory*scalar
			--TODO: the following block is only used to compute mob.z, which might change if we use z-axis grip
			--TODO: totaldist (dist from start to target) only needs to be computed once immediately following setup
			local totaldistx=self.startx-self.targetx
			local totaldisty=self.starty-self.targety
			local totaldistsqr=totaldistx*totaldistx+totaldisty*totaldisty
			local totaldist=math.sqrt(totaldistsqr)			
			local ratio=dist/totaldist
			local multiplier=math.sin(ratio*math.pi)*(totaldist/self.archeightstandardwavelength)
			mob.z=multiplier*self.archeight
			
		else
			mob.x=self.targetx
			mob.y=self.targety
			mob.z=self.targetz
			self:Die()
		end
		--return position
	end
end

-- -- Blooper: Reverse Death Grip

	-- function class:MoveMobile(elapsed)
		-- local position={x=0,y=0,z=0}
		-- local mob=self.targetcombat.owner
		-- --TODO: not sure we want to set speed to 0 (but at the moment, the alternatives are worse)
		-- mob.xspeed=0
		-- mob.yspeed=0
		-- mob.zspeed=0
		-- --TODO: we're currently ignoring grip speed/distance on the Z-axis.  should we?
		-- local distx=mob.x-self.targetx		-- -- (this is backwards)
		-- local disty=mob.y-self.targety
		-- local distsqr=distx*distx+disty*disty
		-- local dist=math.sqrt(distsqr)
		-- local unitvectorx=distx/dist
		-- local unitvectory=disty/dist
		-- local scalar=self.gripspeed*elapsed
		
		-- if(dist>scalar)then
			-- mob.x=mob.x+unitvectorx*scalar
			-- mob.y=mob.y+unitvectory*scalar
			-- --TODO: the following block is only used to compute mob.z, which might change if we use z-axis grip
			-- --TODO: totaldist (dist from start to target) only needs to be computed once immediately following setup
			-- local totaldistx=self.startx-self.targetx
			-- local totaldisty=self.starty-self.targety
			-- local totaldistsqr=totaldistx*totaldistx+totaldisty*totaldisty
			-- local totaldist=math.sqrt(totaldistsqr)			
			-- local ratio=dist/totaldist
			-- local multiplier=math.sin(ratio*math.pi)*(self.archeightstandardwavelength/totaldist)	-- -- (division is backwards too)
			-- mob.z=multiplier*self.archeight
			
		-- else
			-- mob.x=self.targetx
			-- mob.y=self.targety
			-- mob.z=self.targetz
			-- self:Die()
		-- end
		-- --return position
	-- end
