
--TODO: a lot of spells reference TRAININGGROUNDS_Aura_Facing directly when they should use a derived class instead
do
	local super=TRAININGGROUNDS_Aura
	TRAININGGROUNDS_Aura_Facing = TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_Aura_Facing

	function class:Setup(castercombat,targetcombat,localtime)
		--TEMP, move to sorting function
		super.Setup(self,castercombat,targetcombat,localtime)
	end
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		TRAININGGROUNDS_Aura_Facing_SetCustomInfo(self)
	end
	
	function class:SetupNewauraLists(auramodule)
		super.SetupNewauraLists(self,auramodule)
		tinsert(self.auramodulelists,auramodule.facing)
	end
	
	function class:GetTargetFacing()
		return TRAININGGROUNDS_Aura_Facing_GetTargetFacing(self)
	end
	
	function class:GetTurnSpeed()
		return TRAININGGROUNDS_Aura_Facing_GetTurnSpeed(self)
	end	
	
	function class:GetTurnStrength()
		return TRAININGGROUNDS_Aura_Facing_GetTurnStrength(self)
	end	

-----------------------------
-----------------------------
-----------------------------
	
	-- It looks like we're about to redefine the class functions here,
	-- but these are actually global static functions shared between this and a few other auras.

	

	function TRAININGGROUNDS_Aura_Facing_SetCustomInfo(self)
		self.baseduration=1.000
		self.targetcoordinate=nil
		self.targetmobile=nil
		self.turnspeed=10
		-- turnstrength: used to combine with movementfacing.  no effect if the character isn't moving.
		-- 	0.5 average of movementfacing and aurafacing, 1.0 ignore movementfacing, 0.0 ignore aura.
		--TODO: not sure if averaging is working correctly; setting to 1.0 for now
		--self.turnstrength=0.5
		self.turnstrength=1.0
		
		--self.priority=0	--TODO: decide whether we want to use priority system (probably requires rewrite of facingauralist)
	end
	
	function TRAININGGROUNDS_Aura_Facing_GetTargetFacing(self)
		if(self.targetmobile)then
			--reminder: "targetcombat" is the character which this aura is applied to.
			local ownermobile=self.targetcombat.owner
			-- "targetmobile" is the character which this aura is "fixated" on.
			local targetmobile=self.targetmobile
			local angle=math.atan2(targetmobile.y-ownermobile.y,targetmobile.x-ownermobile.x)
			--print("GetTargetFacing",self,angle)
			--print("!!! mobiles",ownermobile,targetmobile)
			--print("!!! targetfacing",angle,ownermobile.x,ownermobile.y,targetmobile.x,targetmobile.y)
			return angle
		elseif(self.targetcoordinate)then
			local targetcoordinate=self.targetcoordinate
			return math.atan2(targetcoordinate.y-ownermobile.y,targetcoordinate.x-ownermobile.x)
		end
		return nil
	end
	
	function TRAININGGROUNDS_Aura_Facing_GetTurnSpeed(self)
		return self.turnspeed
	end	

	function TRAININGGROUNDS_Aura_Facing_GetTurnStrength(self)
		return self.turnstrength
	end		
end