do
	TRAININGGROUNDS_AuraModule = {}
	TRAININGGROUNDS_AuraModule.__index = TRAININGGROUNDS_AuraModule

	function TRAININGGROUNDS_AuraModule.new()
		local self=setmetatable({}, TRAININGGROUNDS_AuraModule)
		return self
	end

	function TRAININGGROUNDS_AuraModule:Setup(combat)
		self.combat=combat
		--self.allauras={}
		--self.allcategories={}

		-- self.allauras=TRAININGGROUNDS_AuraCategory.new()
		-- self.allauras:Setup(self)
		-- self.movement=TRAININGGROUNDS_AuraCategory.new()
		-- self.movement:Setup(self)
		-- --forcedmovement differs from knockback in that certain loss of control effects cancel forcedmovement but not knockback
		-- self.forcedmovement=TRAININGGROUNDS_AuraCategory.new()
		-- self.forcedmovement:Setup(self)
		-- self.damage=TRAININGGROUNDS_AuraCategory.new()
		-- self.damage:Setup(self)	
		
		self.newauras={}
		
		self.auralists={}
		self.allauras={}
		tinsert(self.auralists,self.allauras)		
		
		-- Animation auras apply the given animation on every frame.
		-- Auras are automatically added to this list if their animation property is set during SetCustomInfo.
		self.animation={}
		tinsert(self.auralists,self.animation)
		
		-- "Irrelevant" aura makes the object invisible and/or transparent/shadowless
		self.irrelevant={}
		tinsert(self.auralists,self.irrelevant)
		-- "Relevant" aura overrides the "irrelevant" aura and makes the object visible again.
		self.relevant={}
		tinsert(self.auralists,self.relevant)
		
		self.vacuum={}
		tinsert(self.auralists,self.vacuum)

		-- Multiplicative speed boost.  Highest boost overrides the others.
		self.speedboost={}
		tinsert(self.auralists,self.speedboost)
		
		-- TODO: We haven't yet decided how snares are going to stack (or how they work with speedboosts).
		self.snare={}
		tinsert(self.auralists,self.snare)
		
			-- TODO: it turns out auras already have Step.  remove this category?
		-- -- "Step" auras have a Step event called on every frame.
		-- -- Probably best to use this one sparingly.
		-- self.step={}
		-- tinsert(self.auralists,self.step)
		
		self.damageovertime={}
		tinsert(self.auralists,self.damageovertime)
		self.visual_modellighting={}
		tinsert(self.auralists,self.visual_modellighting)
		self.visual_modelalpha={}
		tinsert(self.auralists,self.visual_modelalpha)

		self.facing={}		
		tinsert(self.auralists,self.facing)
		self.facing_telegraph={}
		tinsert(self.auralists,self.facing_telegraph)
		
		
		-- we suspect grip will also be used for "pathed teleport" sequences
		self.grip={}		
		tinsert(self.auralists,self.grip)

		
		-- TODO: we're using this category for rolls and charges; rename SpecialMovementTechnique
		self.forcedmovement={}
		tinsert(self.auralists,self.forcedmovement)
	end


		
	function TRAININGGROUNDS_AuraModule:Step(elapsed)
		for i=1,#self.allauras,1 do
			self.allauras[i]:Step(elapsed)
		end
	end

	--TODO: auras and gameobjects should themselves be responsible for calling Die
		-- (even if we call the function that calls Die from this function)
	function TRAININGGROUNDS_AuraModule:CheckAuraExpiry()
		for i=1,#self.allauras,1 do
			--print("Comparing expiry",self.allauras[i].expiry,"to localtime",self.combat.localtime)
			if(self.allauras[i].expiry)then
				if(self.combat.localtime>=self.allauras[i].expiry)then
					--TODO: PartialTick()
					self.allauras[i]:PartialTick(self.combat.localtime)
					self.allauras[i]:Die()				
					--TODO: OnAuraExpiredEffect()
					--TODO: OnAuraRemovedEffect() somewhere, maybe not here				
				end
			end
		end
	end
	
	
	function TRAININGGROUNDS_AuraModule:DEBUG_DispelEntireAuraList(auralist)
		for i=1,#auralist do
			local aura=auralist[i]
			--TODO: self.allauras[i]:Dispel() or OnDispel()
			aura:Die()
		end
	end
	

	
	--TODO: rename EndOfFrame? (and move to end of frame)
	function TRAININGGROUNDS_AuraModule:RemoveDyingAuras()
		for i=1,#self.newauras,1 do
			--print("Transfer new aura to lists:",self.newauras[i])
			self.newauras[i]:TransferFromNewauraLists(self)
		end
		self.newauras={}	

	
	
	
		for i=#self.allauras,1,-1 do
			local aura=self.allauras[i]
			if(aura.dying)then
				aura:Cleanup()	-- this SHOULD set dead to true
				if(not aura.dead) then
					-- jump into specific aura's file before crashing noisily
					aura:FatalErrorObjNotDeadAfterCleanup()
				end
			end	
		end
		--TODO: iterate through list of aura lists
		for j=1,#self.auralists do
			local auralist=self.auralists[j]
			for i=#auralist,1,-1 do
				local aura=auralist[i]
				if(aura.dead)then
					tremove(auralist,i)
				end
			end
		end
	end
	
	function TRAININGGROUNDS_AuraModule:Cleanup()
		for i=1,#self.allcategories,1 do
			self.allcategories[i]:Cleanup()
		end	
	end
end
