do
	TRAININGGROUNDS_Aura = {}
	TRAININGGROUNDS_Aura.__index = TRAININGGROUNDS_Aura

	function TRAININGGROUNDS_Aura.new()
		local self=setmetatable({}, TRAININGGROUNDS_Aura)
		return self
	end

	--TODO: rename "localtime" arg to "aurastarttime"?
	function TRAININGGROUNDS_Aura:Setup(castercombat,targetcombat,localtime)
		--print("Aura.setup about to call AddNewAura on",targetcombat)
		targetcombat:AddNewAura(self)

		self.castercombat=castercombat
		self.targetcombat=targetcombat				
		--TODO: aura category sorting function, do the same thing GameObject does
		
		self:SetCustomInfo()
		if(self.baseduration)then
			self.expiry=localtime+self.baseduration
			--print("Expiry:",localtime,self.baseduration,self.expiry)
		else
			self.expiry=nil
		end		
		self.starttime=localtime
		
		-- flag set by voidzones, not by the aura itself
		self.inrangeofvoidzone=false
		
		self.dying=false
		self.dead=false
		
		self:SetupNewauraLists(targetcombat.auramodule)
		
		self:OnApply(localtime)
	end
	
	function TRAININGGROUNDS_Aura:SetCustomInfo()
		self.baseduration=nil
		
		self.tickdelay=0.0
		self.basetickrate=nil
		self.usepartialticks=true
		self.dontzeropercenttick=true
		
		-- SIDE EFFECT: if animation is set by a child class, 
		-- SetupNewAuralists will add to auramodule.animation
		self.animation=nil
	end

	
	--reminder: auramodulelists is a list of references to the lists in AuraModule
	function TRAININGGROUNDS_Aura:SetupNewauraLists(auramodule)
		--override, call super when overriding		
		self.auramodulelists={}
		tinsert(self.auramodulelists,auramodule.allauras)
		
		--TODO: not sure why we appear to have a special case for animation
		if(self.animation)then
			tinsert(self.auramodulelists,auramodule.animation)
		end
	end

	--reminder: auramodulelists is a list of references to the lists in AuraModule
	function TRAININGGROUNDS_Aura:TransferFromNewauraLists()
		for i=1,#self.auramodulelists,1 do
			--print("Moving to list",self.auramodulelists[i])
			tinsert(self.auramodulelists[i],self)
		end
	end

	function TRAININGGROUNDS_Aura:Step(elapsed)
		if(self.basetickrate)then
			local nextticktime=self:GetNextTickTime()
			if(self.targetcombat.localtime>=nextticktime)then
				self:Tick(nextticktime)
			end
		end
		if(self.expiry)then
			if(self.targetcombat.localtime>=self.expiry)then
				--print("Aura expires, localtime",self.targetcombat.localtime)
				self:OnExpiry()
			end
		end
	end	

	
	--TODO: not clear if every aura needs tick functions by default
		-- or if this should be one of those pure-virtual-override situations
	function TRAININGGROUNDS_Aura:GetNextTickTime()
		local result
		if(self.previousticktime)then
			--TODO: GetCurrentTickRate()			
			result=self.previousticktime+self.basetickrate				
		else
			result=self.starttime+self.tickdelay
			--print("(first tick)")
		end
		--print("GetNextTickTime:",result)
		return result
		
	end		
		
	function TRAININGGROUNDS_Aura:GetPartialTickPercentage()
		if(self.previousticktime)then
															--TODO: GetCurrentTickRate()
			return (self.targetcombat.localtime-self.previousticktime)/self.basetickrate
		else
			return math.min(0, (self.targetcombat.localtime-self.starttime-self.tickdelay)/self.basetickrate)
		end
	end
	
	function TRAININGGROUNDS_Aura:OnApply(combattime)
		--override
	end
	
	function TRAININGGROUNDS_Aura:Tick(ticktime)
		self:OnTick(ticktime,1.0)
	end
	
	-- (PartialTick is called by AuraModule when aura expires)
	function TRAININGGROUNDS_Aura:PartialTick(ticktime)
		if(self.usepartialticks)then
			if(self.tickrate)then
				local percentage=GetPartialTickPercentage()
				self:OnTick(ticktime,percentage)
			end
		end
	end
	
	
	
	-- protected-ish function to be called by Tick and PartialTick only
		--(derived classes should still override ontick instead of tick/partialtick)
		-- REMEMBER TO CALL SUPER WHEN OVERRIDING ONTICK
			-- OTHERWISE WEIRD THINGS WILL HAPPEN (e.g. tick every frame) WITHOUT CRASHING OUTRIGHT
				--TODO: separate ontick's change-next-tick-time from ontick's tick-effects function
	function TRAININGGROUNDS_Aura:OnTick(ticktime,percentage)
		if(percentage<=0.0 and self.dontzeropercenttick)then return end
		
		self.previousticktime=ticktime
	end
	
	--TODO: still lots of uncertainty whether this is the best way to go about this
	function TRAININGGROUNDS_Aura:OnExpiry()		
		self:Die()
		-- override
		-- MOST auras will want to call super on override
	end	
	
	--TODO: nothing currently calls OnRemove 
	--TODO: OnRemove should probably take localtime as parameter
	--TODO: Cloak of Shadows check, somehow (not looking forward to this)
	function TRAININGGROUNDS_Aura:OnRemove()
		-- override
	end
	
	function TRAININGGROUNDS_Aura:Die()		
		self.dying=true
	end
	
	function TRAININGGROUNDS_Aura:Cleanup()
		self:OnRemove()
		
		self.dead=true
	end
	
	--TODO: "instance" instead of "obj"?
	function TRAININGGROUNDS_Aura:FatalErrorObjNotDeadAfterCleanup()
		error("ERROR: aura not properly flagged as dead after calling Cleanup")
	end
end